/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import com.devskiller.friendly_id.FriendlyId;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.UUID;

public abstract class IdUtils {
    private static final HashFunction HASH_FUNCTION = Hashing.md5();
    private static final char ID_SEPARATOR = '_';

    public static String create() {
        return FriendlyId.createFriendlyId();
    }

    public static String from(String from) {
        return FriendlyId.toFriendlyId((UUID)UUID.nameUUIDFromBytes(HASH_FUNCTION.hashString((CharSequence)from, StandardCharsets.UTF_8).asBytes()));
    }

    public static String fromParts(String ... parts) {
        return IdUtils.fromPartsAndSeparator('_', parts);
    }

    public static String fromPartsAndSeparator(char separator, String ... parts) {
        StringJoiner sj = new StringJoiner(String.valueOf(separator));
        for (String str : parts) {
            if (str == null) continue;
            sj.add(str);
        }
        return sj.toString();
    }
}

