/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapUtils.class);
    private static final String CONFLICT_AT_KEY_MSG = "Conflict at key: '{}', ignoring it. Map keys are: {}";

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Map<String, Object> merge(Map<String, Object> a, Map<String, Object> b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null || a.isEmpty()) {
            return b;
        }
        if (b == null || b.isEmpty()) {
            return a;
        }
        result = HashMap.newHashMap(Math.max(a.size(), b.size()));
        result.putAll(a);
        for (Map.Entry<String, Object> entry : b.entrySet()) {
            block7: {
                block9: {
                    block8: {
                        block6: {
                            key = entry.getKey();
                            valueB = entry.getValue();
                            valueA = result.get(key);
                            if (valueB != null) break block6;
                            mergedValue /* !! */  = valueA;
                            break block7;
                        }
                        if (valueA != null) break block8;
                        mergedValue /* !! */  = valueB;
                        break block7;
                    }
                    if (!(valueA instanceof Map)) break block9;
                    mapA = (Map)valueA;
                    if (!(valueB instanceof Map)) break block9;
                    mapB = (Map)valueB;
                    mergedValue /* !! */  = MapUtils.merge(MapUtils.castMap(mapA), MapUtils.castMap(mapB));
                    break block7;
                }
                if (!(valueA instanceof Collection)) ** GOTO lbl-1000
                colA = (Collection)valueA;
                if (valueB instanceof Collection) {
                    colB = (Collection)valueB;
                    mergedValue /* !! */  = MapUtils.mergeCollections(colA, colB);
                } else lbl-1000:
                // 2 sources

                {
                    mergedValue /* !! */  = valueB;
                }
            }
            result.put(key, mergedValue /* !! */ );
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Map<String, Object> deepMerge(Map<String, Object> a, Map<String, Object> b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null || a.isEmpty()) {
            return b;
        }
        if (b == null || b.isEmpty()) {
            return a;
        }
        result = HashMap.newHashMap(Math.max(a.size(), b.size()));
        result.putAll(MapUtils.deepCloneMap(a));
        for (Map.Entry<String, Object> entry : b.entrySet()) {
            block7: {
                block9: {
                    block8: {
                        block6: {
                            key = entry.getKey();
                            valueB = entry.getValue();
                            valueA = result.get(key);
                            if (valueB != null) break block6;
                            mergedValue /* !! */  = valueA;
                            break block7;
                        }
                        if (valueA != null) break block8;
                        mergedValue /* !! */  = valueB;
                        break block7;
                    }
                    if (!(valueA instanceof Map)) break block9;
                    mapA = (Map)valueA;
                    if (!(valueB instanceof Map)) break block9;
                    mapB = (Map)valueB;
                    mergedValue /* !! */  = MapUtils.deepMerge(MapUtils.castMap(mapA), MapUtils.castMap(mapB));
                    break block7;
                }
                if (!(valueA instanceof Collection)) ** GOTO lbl-1000
                colA = (Collection)valueA;
                if (valueB instanceof Collection) {
                    colB = (Collection)valueB;
                    mergedValue /* !! */  = MapUtils.mergeCollections(colA, colB);
                } else lbl-1000:
                // 2 sources

                {
                    mergedValue /* !! */  = valueB;
                }
            }
            result.put(key, mergedValue /* !! */ );
        }
        return result;
    }

    private static Map<String, Object> deepCloneMap(Map<String, Object> original) {
        HashMap<String, Object> cloned = new HashMap<String, Object>(original.size());
        for (Map.Entry<String, Object> entry : original.entrySet()) {
            cloned.put(entry.getKey(), MapUtils.deepClone(entry.getValue()));
        }
        return cloned;
    }

    private static Object deepClone(Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return MapUtils.deepCloneMap(MapUtils.castMap(map));
        }
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            return MapUtils.cloneCollection(col);
        }
        return value;
    }

    private static Collection<?> mergeCollections(Collection<?> colA, Collection<?> colB) {
        ArrayList merged = new ArrayList(colA.size() + colB.size());
        merged.addAll(colA);
        merged.addAll(colB);
        return merged;
    }

    private static Collection<?> cloneCollection(Collection<?> elements) {
        try {
            Collection newInstance = (Collection)elements.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            newInstance.addAll(elements);
            return newInstance;
        }
        catch (Exception e) {
            return new ArrayList(elements);
        }
    }

    private static Map<String, Object> castMap(Map<?, ?> map) {
        return map;
    }

    public static Map<String, Object> mergeWithNullableValues(Map<String, Object> ... maps) {
        return Arrays.stream(maps).flatMap(map -> map.entrySet().stream()).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue()), HashMap::putAll);
    }

    public static <K, V> Map<K, V> emptyOnNull(Map<K, V> map) {
        return map == null ? new HashMap() : map;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static Map<String, Object> flattenToNestedMap(@NotNull Map<String, ?> flatMap) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (Map.Entry<String, ?> entry : flatMap.entrySet()) {
            String[] keys = entry.getKey().split("\\.");
            Map<String, Object> currentMap = result;
            for (int i = 0; i < keys.length - 1; ++i) {
                String key = keys[i];
                if (!currentMap.containsKey(key)) {
                    currentMap.put(key, new HashMap());
                } else if (!(currentMap.get(key) instanceof Map)) {
                    String invalidKey = String.join((CharSequence)",", Arrays.copyOfRange(keys, 0, i));
                    log.warn(CONFLICT_AT_KEY_MSG, (Object)invalidKey, flatMap.keySet());
                    continue;
                }
                currentMap = (Map)currentMap.get(key);
            }
            String lastKey = keys[keys.length - 1];
            if (currentMap.containsKey(lastKey)) {
                log.warn(CONFLICT_AT_KEY_MSG, (Object)lastKey, flatMap.keySet());
                continue;
            }
            currentMap.put(lastKey, entry.getValue());
        }
        return result;
    }

    public static Map<String, Object> nestedToFlattenMap(@NotNull Map<String, Object> nestedMap) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : nestedMap.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Map) {
                Map map = (Map)object;
                Map<String, Object> flatten = MapUtils.flattenEntry(entry.getKey(), map);
                result.putAll(flatten);
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static Map<String, Object> flattenEntry(String key, Map<String, Object> value) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            String newKey = key + "." + entry.getKey();
            Object newValue = entry.getValue();
            if (newValue instanceof Map) {
                Map map = (Map)newValue;
                result.putAll(MapUtils.flattenEntry(newKey, map));
                continue;
            }
            result.put(newKey, newValue);
        }
        return result;
    }
}

