/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import jakarta.annotation.Nullable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public final class PathMatcherPredicate
implements Predicate<Path> {
    private static final String SYNTAX_GLOB = "glob:";
    private static final String SYNTAX_REGEX = "regex:";
    private final List<String> syntaxAndPatterns;
    private final List<PathMatcher> matchers;

    public static PathMatcherPredicate matches(List<String> patterns) {
        return new PathMatcherPredicate(null, patterns);
    }

    public static PathMatcherPredicate matches(Path basePath, List<String> patterns) {
        return new PathMatcherPredicate(basePath, patterns);
    }

    public static Builder builder() {
        return new Builder();
    }

    private PathMatcherPredicate(@Nullable Path basePath, List<String> patterns) {
        Objects.requireNonNull(patterns, "patterns cannot be null");
        this.syntaxAndPatterns = patterns.stream().map(p -> {
            Object syntaxAndPattern = p;
            if (!PathMatcherPredicate.isPrefixWithSyntax(p)) {
                Object pattern = basePath != null ? String.valueOf(basePath) + PathMatcherPredicate.mayAddLeadingSlash(p) : PathMatcherPredicate.mayAddRecursiveMatch(p);
                syntaxAndPattern = SYNTAX_GLOB + ((String)pattern).replace("\\", "/");
            }
            return syntaxAndPattern;
        }).toList();
        FileSystem fs = FileSystems.getDefault();
        this.matchers = this.syntaxAndPatterns.stream().map(fs::getPathMatcher).toList();
    }

    private static String mayAddRecursiveMatch(String p) {
        return p.matches("\\w+[\\s\\S]*") ? "**/" + p : p;
    }

    public List<String> syntaxAndPatterns() {
        return this.syntaxAndPatterns;
    }

    @Override
    public boolean test(Path path) {
        return this.matchers.stream().anyMatch(p -> p.matches(path));
    }

    private static String mayAddLeadingSlash(String path) {
        return path.startsWith("/") || path.startsWith("\\") ? path : "/" + path;
    }

    public static boolean isPrefixWithSyntax(String pattern) {
        return pattern.startsWith(SYNTAX_REGEX) || pattern.startsWith(SYNTAX_GLOB);
    }

    public static class Builder {
        private List<String> includes = List.of();
        private List<String> excludes = List.of();

        public Builder includes(List<String> includes) {
            this.includes = Optional.ofNullable(includes).orElse(this.includes);
            return this;
        }

        public Builder excludes(List<String> excludes) {
            this.excludes = Optional.ofNullable(excludes).orElse(this.excludes);
            return this;
        }

        public Predicate<Path> build() {
            if (!this.includes.isEmpty() && !this.excludes.isEmpty()) {
                return PathMatcherPredicate.matches(this.includes).and(Predicate.not(PathMatcherPredicate.matches(this.excludes)));
            }
            if (!this.includes.isEmpty()) {
                return PathMatcherPredicate.matches(this.includes);
            }
            if (!this.excludes.isEmpty()) {
                return Predicate.not(PathMatcherPredicate.matches(this.excludes));
            }
            return path -> true;
        }
    }
}

