/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations.validator;

import io.kestra.core.test.flow.Assertion;
import io.kestra.core.validations.TestSuiteAssertionValidation;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.inject.Singleton;
import java.util.ArrayList;

@Singleton
@Introspected
public class TestSuiteAssertionValidator
implements ConstraintValidator<TestSuiteAssertionValidation, Assertion> {
    public boolean isValid(@Nullable Assertion value, @NonNull AnnotationValue<TestSuiteAssertionValidation> annotationMetadata, @NonNull ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        ArrayList<String> violations = new ArrayList<String>();
        if (!value.hasAtLeastOneAssertion()) {
            violations.add("at least one actual assertion is required (equalTo, greaterThan..)");
        }
        if (!violations.isEmpty()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("Invalid TestSuite Assertion: " + String.join((CharSequence)", ", violations)).addConstraintViolation();
            return false;
        }
        return true;
    }
}

