/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations.validator;

import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.dashboards.GraphStyle;
import io.kestra.core.validations.TimeSeriesChartValidation;
import io.kestra.plugin.core.dashboard.chart.TimeSeries;
import io.kestra.plugin.core.dashboard.chart.timeseries.TimeSeriesColumnDescriptor;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Singleton
@Introspected
public class TimeSeriesChartValidator
implements ConstraintValidator<TimeSeriesChartValidation, TimeSeries<?, ?>> {
    public boolean isValid(@Nullable TimeSeries<?, ?> timeSeriesChart, @NonNull AnnotationValue<TimeSeriesChartValidation> annotationMetadata, @NonNull ConstraintValidatorContext context) {
        if (timeSeriesChart == null) {
            return true;
        }
        ArrayList<String> violations = new ArrayList<String>();
        ((DataFilter)timeSeriesChart.getData()).getColumns().entrySet().forEach(columnWithKey -> {
            GraphStyle graphStyle = ((TimeSeriesColumnDescriptor)columnWithKey.getValue()).getGraphStyle();
            if (((TimeSeriesColumnDescriptor)columnWithKey.getValue()).getAgg() == null && graphStyle != null) {
                violations.add("Only aggregations can have `graphStyle` specified and " + (String)columnWithKey.getKey() + " is not one.");
            }
        });
        List<TimeSeriesColumnDescriptor> aggregationsColumns = ((DataFilter)timeSeriesChart.getData()).getColumns().values().stream().filter(column -> column.getAgg() != null).toList();
        Set graphStyles = aggregationsColumns.stream().map(TimeSeriesColumnDescriptor::getGraphStyle).filter(Objects::nonNull).collect(Collectors.toSet());
        if (graphStyles.size() != aggregationsColumns.size()) {
            violations.add("All aggregations must have unique `graphStyle`.");
        }
        if (!violations.isEmpty()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("Invalid TimeSeries chart: " + String.join((CharSequence)", ", violations)).addConstraintViolation();
            return false;
        }
        return true;
    }
}

