/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.Label;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.serializers.ListOrMapOfLabelDeserializer;
import io.kestra.core.serializers.ListOrMapOfLabelSerializer;
import io.kestra.core.validations.NoSystemLabelValidation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@Schema(title="Condition that checks labels of an execution.")
@Plugin(examples={@Example(title="Trigger condition to execute the flow based on execution of another flow(s) with certain execution labels.", full=true, code={"id: flow_condition_executionlabels\nnamespace: company.team\n\ntasks:\n  - id: hello\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute when flow with specified labels enters FAILED state.\"\n\ntriggers:\n  - id: flow_trigger\n    type: io.kestra.plugin.core.trigger.Flow\n    conditions:\n      - type: io.kestra.plugin.core.condition.ExecutionLabels\n        labels:\n          owner: john.doe\n          env: prod\n    states:\n      - FAILED\n"})}, aliases={"io.kestra.core.models.conditions.types.ExecutionLabelsCondition", "io.kestra.plugin.core.condition.ExecutionLabelsCondition"})
public class ExecutionLabels
extends Condition {
    @JsonSerialize(using=ListOrMapOfLabelSerializer.class)
    @JsonDeserialize(using=ListOrMapOfLabelDeserializer.class)
    @NotNull
    @Schema(description="List of labels to match in the execution.", implementation=Object.class, oneOf={List.class, Map.class})
    @PluginProperty
    @NotNull List<@NoSystemLabelValidation Label> labels;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        for (Label label : this.labels) {
            if (conditionContext.getExecution().getLabels() != null && conditionContext.getExecution().getLabels().contains(label)) continue;
            return false;
        }
        return true;
    }

    @Generated
    protected ExecutionLabels(ExecutionLabelsBuilder<?, ?> b) {
        super(b);
        this.labels = b.labels;
    }

    @Generated
    public static ExecutionLabelsBuilder<?, ?> builder() {
        return new ExecutionLabelsBuilderImpl();
    }

    @Generated
    public String toString() {
        return "ExecutionLabels(super=" + super.toString() + ", labels=" + String.valueOf(this.getLabels()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionLabels)) {
            return false;
        }
        ExecutionLabels other = (ExecutionLabels)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Label> this$labels = this.getLabels();
        List<Label> other$labels = other.getLabels();
        return !(this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExecutionLabels;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Label> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        return result;
    }

    @Generated
    public List<@NoSystemLabelValidation Label> getLabels() {
        return this.labels;
    }

    @Generated
    public ExecutionLabels() {
    }

    @Generated
    public static abstract class ExecutionLabelsBuilder<C extends ExecutionLabels, B extends ExecutionLabelsBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private List<@NoSystemLabelValidation Label> labels;

        @JsonDeserialize(using=ListOrMapOfLabelDeserializer.class)
        @Generated
        public B labels(List<@NoSystemLabelValidation Label> labels) {
            this.labels = labels;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ExecutionLabels.ExecutionLabelsBuilder(super=" + super.toString() + ", labels=" + String.valueOf(this.labels) + ")";
        }
    }

    @Generated
    private static final class ExecutionLabelsBuilderImpl
    extends ExecutionLabelsBuilder<ExecutionLabels, ExecutionLabelsBuilderImpl> {
        @Generated
        private ExecutionLabelsBuilderImpl() {
        }

        @Override
        @Generated
        protected ExecutionLabelsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExecutionLabels build() {
            return new ExecutionLabels(this);
        }
    }
}

