/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.property.Property;
import io.kestra.core.utils.MapUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import lombok.Generated;

@Schema(title="Condition based on the outputs of an upstream execution.", description="The condition returns `false` if the execution has no output. If the result is an empty string, a space, or `false`, the condition will also be considered as `false`.")
@Plugin(examples={@Example(title="The upstream `flow_a` must explicitly define its outputs\nto be used in the `ExecutionOutputs` condition.\n\n```yaml\nid: flow_a\nnamespace: company.team\n\ninputs:\n  - id: user_value\n    type: STRING\n    defaults: hello\n\ntasks:\n  - id: hello\n    type: io.kestra.plugin.core.debug.Return\n    format: \"{{ inputs.user_value }}\"\n\noutputs:\n  - id: flow_a_output\n    type: STRING\n    value: \"{{ outputs.hello.value }}\"\n```\n\nThe `flow_condition_executionoutputs` will run whenever `flow_a` finishes successfully\nand returns an output matching the value 'hello':\n", full=true, code={"id: flow_condition_executionoutputs\nnamespace: company.team\n\ntasks:\n  - id: upstream_outputs\n    type: io.kestra.plugin.core.log.Log\n    message: hello from a downstream flow\n\ntriggers:\n  - id: condition_on_flow_execution_outputs\n    type: io.kestra.plugin.core.trigger.Flow\n    states:\n      - SUCCESS\n    conditions:\n      - type: io.kestra.plugin.core.condition.ExecutionOutputs\n        expression: \"{{ trigger.outputs.flow_a_output == 'hello' }}\"\n"})}, aliases={"io.kestra.core.models.conditions.types.ExecutionOutputsCondition", "io.kestra.plugin.core.condition.ExecutionOutputsCondition"})
public class ExecutionOutputs
extends Condition
implements ScheduleCondition {
    private static final String TRIGGER_VAR = "trigger";
    private static final String OUTPUTS_VAR = "outputs";
    @NotNull
    private Property<Boolean> expression;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        if (this.hasNoOutputs(conditionContext.getExecution())) {
            return false;
        }
        Map<String, Object> variables = MapUtils.mergeWithNullableValues(conditionContext.getVariables(), Map.of(TRIGGER_VAR, Map.of(OUTPUTS_VAR, conditionContext.getExecution().getOutputs())));
        return conditionContext.getRunContext().render(this.expression).skipCache().as(Boolean.class, variables).orElseThrow();
    }

    private boolean hasNoOutputs(Execution execution) {
        return execution.getOutputs() == null || execution.getOutputs().isEmpty();
    }

    @Generated
    protected ExecutionOutputs(ExecutionOutputsBuilder<?, ?> b) {
        super(b);
        this.expression = b.expression;
    }

    @Generated
    public static ExecutionOutputsBuilder<?, ?> builder() {
        return new ExecutionOutputsBuilderImpl();
    }

    @Generated
    public String toString() {
        return "ExecutionOutputs(super=" + super.toString() + ", expression=" + String.valueOf(this.getExpression()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionOutputs)) {
            return false;
        }
        ExecutionOutputs other = (ExecutionOutputs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Boolean> this$expression = this.getExpression();
        Property<Boolean> other$expression = other.getExpression();
        return !(this$expression == null ? other$expression != null : !((Object)this$expression).equals(other$expression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExecutionOutputs;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Boolean> $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : ((Object)$expression).hashCode());
        return result;
    }

    @Generated
    public Property<Boolean> getExpression() {
        return this.expression;
    }

    @Generated
    public ExecutionOutputs() {
    }

    @Generated
    public static abstract class ExecutionOutputsBuilder<C extends ExecutionOutputs, B extends ExecutionOutputsBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private Property<Boolean> expression;

        @Generated
        public B expression(Property<Boolean> expression) {
            this.expression = expression;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ExecutionOutputs.ExecutionOutputsBuilder(super=" + super.toString() + ", expression=" + String.valueOf(this.expression) + ")";
        }
    }

    @Generated
    private static final class ExecutionOutputsBuilderImpl
    extends ExecutionOutputsBuilder<ExecutionOutputs, ExecutionOutputsBuilderImpl> {
        @Generated
        private ExecutionOutputsBuilderImpl() {
        }

        @Override
        @Generated
        protected ExecutionOutputsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExecutionOutputs build() {
            return new ExecutionOutputs(this);
        }
    }
}

