/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.models.property.Property;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Condition based on variable expression.", description="If the result is an empty string, a string containing only space or `false`, the condition will be considered as false.")
@Plugin(examples={@Example(title="Trigger condition to execute the flow when the expression evaluates to true.", full=true, code={"id: myflow\nnamespace: company.team\n\ntasks:\n  - id: hello\n    type: io.kestra.plugin.core.log.Log\n    message: Average value has gone below 10\n\ntriggers:\n  - id: expression_trigger\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"*/1 * * * *\"\n    conditions:\n      - type: io.kestra.plugin.core.condition.Expression\n        expression: \"{{ kv('average_value') < 10 }}\"\n"})}, aliases={"io.kestra.core.models.conditions.types.VariableCondition", "io.kestra.plugin.core.condition.ExpressionCondition"})
public class Expression
extends Condition
implements ScheduleCondition {
    @NotNull
    private Property<String> expression;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        String render = conditionContext.getRunContext().render(this.expression).as(String.class, conditionContext.getVariables()).orElseThrow();
        return !render.isBlank() && !render.trim().equals("false");
    }

    @Generated
    protected Expression(ExpressionBuilder<?, ?> b) {
        super(b);
        this.expression = b.expression;
    }

    @Generated
    public static ExpressionBuilder<?, ?> builder() {
        return new ExpressionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Expression(super=" + super.toString() + ", expression=" + String.valueOf(this.getExpression()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$expression = this.getExpression();
        Property<String> other$expression = other.getExpression();
        return !(this$expression == null ? other$expression != null : !((Object)this$expression).equals(other$expression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Expression;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : ((Object)$expression).hashCode());
        return result;
    }

    @Generated
    public Property<String> getExpression() {
        return this.expression;
    }

    @Generated
    public Expression() {
    }

    @Generated
    public static abstract class ExpressionBuilder<C extends Expression, B extends ExpressionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private Property<String> expression;

        @Generated
        public B expression(Property<String> expression) {
            this.expression = expression;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Expression.ExpressionBuilder(super=" + super.toString() + ", expression=" + String.valueOf(this.expression) + ")";
        }
    }

    @Generated
    private static final class ExpressionBuilderImpl
    extends ExpressionBuilder<Expression, ExpressionBuilderImpl> {
        @Generated
        private ExpressionBuilderImpl() {
        }

        @Override
        @Generated
        protected ExpressionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Expression build() {
            return new Expression(this);
        }
    }
}

