/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.triggers.TimeWindow;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(title="Run a flow if the list of preconditions is met in a time window.", description="**This task is deprecated**, use the `preconditions` property of the `io.kestra.plugin.core.trigger.Flow` trigger instead.\nWill trigger an executions when all the flows defined by the preconditions are successfully executed in a specific period of time.\nThe period is defined by the `timeWindow` property and is by default a duration window of 24 hours.")
@Plugin(examples={@Example(full=true, title="A flow that is waiting for 2 flows to run successfully in a day", code={"id: schedule_condition_multiplecondition\nnamespace: company.team\n\ntasks:\n  - id: log_message\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute when `multiplecondition_flow_a` and `multiplecondition_flow_b` are successfully executed in the last 12 hours.\"\n\ntriggers:\n  - id: multiple_listen_flow\n    type: io.kestra.plugin.core.trigger.Flow\n    conditions:\n      - type: io.kestra.plugin.core.condition.ExecutionStatus\n        in:\n          - SUCCESS\n      - id: multiple\n        type: io.kestra.plugin.core.condition.MultipleCondition\n        timeWindow:\n          window: PT12H\n        conditions:\n          flow_a:\n            type: io.kestra.plugin.core.condition.ExecutionFlow\n            namespace: company.team\n            flowId: multiplecondition_flow_a\n          flow_b:\n            type: io.kestra.plugin.core.condition.ExecutionFlow\n            namespace: company.team\n            flowId: multiplecondition_flow_b\n"})}, aliases={"io.kestra.core.models.conditions.types.MultipleCondition"})
@Deprecated
public class MultipleCondition
extends Condition
implements io.kestra.core.models.triggers.multipleflows.MultipleCondition {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultipleCondition.class);
    @NotNull
    @NotBlank
    @Pattern(regexp="^[a-zA-Z0-9][a-zA-Z0-9_-]*")
    @Schema(title="A unique id for the condition")
    @PluginProperty
    private @NotNull @NotBlank @Pattern(regexp="^[a-zA-Z0-9][a-zA-Z0-9_-]*") String id;
    @Schema(title="Define the time period (or window) for evaluating preconditions.", description="You can set the `type` of `sla` to one of the following values:\n1. `DURATION_WINDOW`: this is the default `type`. It uses a start time (`windowAdvance`) and end time (`window`) that are moving forward to the next interval whenever the evaluation time reaches the end time, based on the defined duration `window`. For example, with a 1-day window (the default option: `window: PT1D`), the SLA conditions are always evaluated during 24h starting at midnight (i.e. at time 00:00:00) each day. If you set `windowAdvance: PT6H`, the window will start at 6 AM each day. If you set `windowAdvance: PT6H` and you also override the `window` property to `PT6H`, the window will start at 6 AM and last for 6 hours \u2014 as a result, Kestra will check the SLA conditions during the following time periods: 06:00 to 12:00, 12:00 to 18:00, 18:00 to 00:00, and 00:00 to 06:00, and so on.\n2. `SLIDING_WINDOW`: this option also evaluates SLA conditions over a fixed time `window`, but it always goes backward from the current time. For example, a sliding window of 1 hour (`window: PT1H`) will evaluate executions for the past hour (so between now and one hour before now). It uses a default window of 1 day.\n3. `DAILY_TIME_DEADLINE`: this option declares that some SLA conditions should be met \"before a specific time in a day\". With the string property `deadline`, you can configure a daily cutoff for checking conditions. For example, `deadline: \"09:00:00\"` means that the defined SLA conditions should be met from midnight until 9 AM each day; otherwise, the flow will not be triggered.\n4. `DAILY_TIME_WINDOW`: this option declares that some SLA conditions should be met \"within a given time range in a day\". For example, a window from `startTime: \"06:00:00\"` to `endTime: \"09:00:00\"` evaluates executions within that interval each day. This option is particularly useful for declarative definition of freshness conditions when building data pipelines. For example, if you only need one successful execution within a given time range to guarantee that some data has been successfully refreshed in order for you to proceed with the next steps of your pipeline, this option can be more useful than a strict DAG-based approach. Usually, each failure in your flow would block the entire pipeline, whereas with this option, you can proceed with the next steps of the pipeline as soon as the data is successfully refreshed at least once within the given time range.\n")
    @PluginProperty
    @Valid
    protected TimeWindow timeWindow;
    @Schema(title="Whether to reset the evaluation results of SLA conditions after a first successful evaluation within the given time period.", description="By default, after a successful evaluation of the set of SLA conditions, the evaluation result is reset, so, the same set of conditions needs to be successfully evaluated again in the same time period to trigger a new execution.\nThis means that to create multiple executions, the same set of conditions needs to be evaluated to `true` multiple times.\nYou can disable this by setting this property to `false` so that, within the same period, each time one of the conditions is satisfied again after a successful evaluation, it will trigger a new execution.")
    @PluginProperty
    @NotNull
    private Boolean resetOnSuccess;
    @Schema(title="The duration of the window", description="Deprecated, use `timeWindow.window` instead.")
    @PluginProperty
    @Deprecated
    private Duration window;
    @Schema(title="The window advance duration", description="Deprecated, use `timeWindow.windowAdvance` instead.")
    @PluginProperty
    @Deprecated
    private Duration windowAdvance;
    @NotNull
    @NotEmpty
    @Schema(title="The list of preconditions to wait for", description="The key must be unique for a trigger because it will be used to store the previous evaluation result.")
    @PluginProperty(additionalProperties=Condition.class)
    private Map<String, Condition> conditions;

    public void setWindow(Duration window) {
        this.window = window;
        this.timeWindow = this.getTimeWindow() == null ? TimeWindow.builder().window(window).build() : this.getTimeWindow().withWindow(window);
    }

    public void setWindowAdvance(Duration windowAdvance) {
        this.windowAdvance = windowAdvance;
        this.timeWindow = this.getTimeWindow() == null ? TimeWindow.builder().windowAdvance(windowAdvance).build() : this.getTimeWindow().withWindowAdvance(windowAdvance);
    }

    @Override
    public Logger logger() {
        return log;
    }

    @Generated
    private static TimeWindow $default$timeWindow() {
        return TimeWindow.builder().build();
    }

    @Generated
    private static Boolean $default$resetOnSuccess() {
        return true;
    }

    @Generated
    protected MultipleCondition(MultipleConditionBuilder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.timeWindow = b.timeWindow$set ? b.timeWindow$value : MultipleCondition.$default$timeWindow();
        this.resetOnSuccess = b.resetOnSuccess$set ? b.resetOnSuccess$value : MultipleCondition.$default$resetOnSuccess();
        this.window = b.window;
        this.windowAdvance = b.windowAdvance;
        this.conditions = b.conditions;
    }

    @Generated
    public static MultipleConditionBuilder<?, ?> builder() {
        return new MultipleConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "MultipleCondition(super=" + super.toString() + ", id=" + this.getId() + ", timeWindow=" + String.valueOf(this.getTimeWindow()) + ", resetOnSuccess=" + this.getResetOnSuccess() + ", window=" + String.valueOf(this.getWindow()) + ", windowAdvance=" + String.valueOf(this.getWindowAdvance()) + ", conditions=" + String.valueOf(this.getConditions()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipleCondition)) {
            return false;
        }
        MultipleCondition other = (MultipleCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$resetOnSuccess = this.getResetOnSuccess();
        Boolean other$resetOnSuccess = other.getResetOnSuccess();
        if (this$resetOnSuccess == null ? other$resetOnSuccess != null : !((Object)this$resetOnSuccess).equals(other$resetOnSuccess)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        TimeWindow this$timeWindow = this.getTimeWindow();
        TimeWindow other$timeWindow = other.getTimeWindow();
        if (this$timeWindow == null ? other$timeWindow != null : !this$timeWindow.equals(other$timeWindow)) {
            return false;
        }
        Duration this$window = this.getWindow();
        Duration other$window = other.getWindow();
        if (this$window == null ? other$window != null : !((Object)this$window).equals(other$window)) {
            return false;
        }
        Duration this$windowAdvance = this.getWindowAdvance();
        Duration other$windowAdvance = other.getWindowAdvance();
        if (this$windowAdvance == null ? other$windowAdvance != null : !((Object)this$windowAdvance).equals(other$windowAdvance)) {
            return false;
        }
        Map<String, Condition> this$conditions = this.getConditions();
        Map<String, Condition> other$conditions = other.getConditions();
        return !(this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MultipleCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $resetOnSuccess = this.getResetOnSuccess();
        result = result * 59 + ($resetOnSuccess == null ? 43 : ((Object)$resetOnSuccess).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        TimeWindow $timeWindow = this.getTimeWindow();
        result = result * 59 + ($timeWindow == null ? 43 : $timeWindow.hashCode());
        Duration $window = this.getWindow();
        result = result * 59 + ($window == null ? 43 : ((Object)$window).hashCode());
        Duration $windowAdvance = this.getWindowAdvance();
        result = result * 59 + ($windowAdvance == null ? 43 : ((Object)$windowAdvance).hashCode());
        Map<String, Condition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public TimeWindow getTimeWindow() {
        return this.timeWindow;
    }

    @Override
    @Generated
    public Boolean getResetOnSuccess() {
        return this.resetOnSuccess;
    }

    @Deprecated
    @Generated
    public Duration getWindow() {
        return this.window;
    }

    @Deprecated
    @Generated
    public Duration getWindowAdvance() {
        return this.windowAdvance;
    }

    @Override
    @Generated
    public Map<String, Condition> getConditions() {
        return this.conditions;
    }

    @Generated
    public MultipleCondition() {
        this.timeWindow = MultipleCondition.$default$timeWindow();
        this.resetOnSuccess = MultipleCondition.$default$resetOnSuccess();
    }

    @Generated
    public static abstract class MultipleConditionBuilder<C extends MultipleCondition, B extends MultipleConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private String id;
        @Generated
        private boolean timeWindow$set;
        @Generated
        private TimeWindow timeWindow$value;
        @Generated
        private boolean resetOnSuccess$set;
        @Generated
        private Boolean resetOnSuccess$value;
        @Generated
        private Duration window;
        @Generated
        private Duration windowAdvance;
        @Generated
        private Map<String, Condition> conditions;

        @Generated
        public B id(String id) {
            this.id = id;
            return (B)this.self();
        }

        @Generated
        public B timeWindow(TimeWindow timeWindow) {
            this.timeWindow$value = timeWindow;
            this.timeWindow$set = true;
            return (B)this.self();
        }

        @Generated
        public B resetOnSuccess(Boolean resetOnSuccess) {
            this.resetOnSuccess$value = resetOnSuccess;
            this.resetOnSuccess$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B window(Duration window) {
            this.window = window;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B windowAdvance(Duration windowAdvance) {
            this.windowAdvance = windowAdvance;
            return (B)this.self();
        }

        @Generated
        public B conditions(Map<String, Condition> conditions) {
            this.conditions = conditions;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MultipleCondition.MultipleConditionBuilder(super=" + super.toString() + ", id=" + this.id + ", timeWindow$value=" + String.valueOf(this.timeWindow$value) + ", resetOnSuccess$value=" + this.resetOnSuccess$value + ", window=" + String.valueOf(this.window) + ", windowAdvance=" + String.valueOf(this.windowAdvance) + ", conditions=" + String.valueOf(this.conditions) + ")";
        }
    }

    @Generated
    private static final class MultipleConditionBuilderImpl
    extends MultipleConditionBuilder<MultipleCondition, MultipleConditionBuilderImpl> {
        @Generated
        private MultipleConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected MultipleConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MultipleCondition build() {
            return new MultipleCondition(this);
        }
    }
}

