/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.exceptions.IllegalConditionEvaluation;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.DateUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetTime;
import java.util.Map;
import lombok.Generated;

@Schema(title="Condition to allow events between two specific times.")
@Plugin(examples={@Example(title="Trigger condition to execute the flow between two specific times.", full=true, code={"id: schedule_condition_timebetween\nnamespace: company.team\n\ntasks:\n  - id: log_message\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute every 5 minutes between 4pm and 8pm.\"\n\ntriggers:\n  - id: schedule\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"*/5 * * * *\"\n    conditions:\n      - type: io.kestra.plugin.core.condition.TimeBetween\n        after: \"16:00:00+02:00\"\n        before: \"20:00:00+02:00\"\n"})}, aliases={"io.kestra.core.models.conditions.types.TimeBetweenCondition", "io.kestra.plugin.core.condition.TimeBetweenCondition"})
public class TimeBetween
extends Condition
implements ScheduleCondition {
    @NotNull
    @Schema(title="The time to test.", description="Can be any variable or any valid ISO 8601 time. By default, it will use the trigger date.")
    private final Property<String> date;
    @Schema(title="The time to test must be after this one.", description="Must be a valid ISO 8601 time with offset.")
    private Property<OffsetTime> after;
    @Schema(title="The time to test must be before this one.", description="Must be a valid ISO 8601 time with offset.")
    private Property<OffsetTime> before;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        RunContext runContext = conditionContext.getRunContext();
        Map<String, Object> variables = conditionContext.getVariables();
        String dateRendered = runContext.render(this.date).as(String.class, variables).orElseThrow();
        OffsetTime currentDate = DateUtils.parseZonedDateTime(dateRendered).toOffsetDateTime().toOffsetTime();
        OffsetTime beforeRendered = runContext.render(this.before).as(OffsetTime.class, variables).orElse(null);
        OffsetTime afterRendered = runContext.render(this.after).as(OffsetTime.class, variables).orElse(null);
        if (beforeRendered != null && afterRendered != null) {
            return currentDate.isAfter(afterRendered) && currentDate.isBefore(beforeRendered);
        }
        if (beforeRendered != null) {
            return currentDate.isBefore(beforeRendered);
        }
        if (afterRendered != null) {
            return currentDate.isAfter(afterRendered);
        }
        throw new IllegalConditionEvaluation("Invalid condition with no before nor after");
    }

    @Generated
    private static Property<String> $default$date() {
        return Property.ofExpression("{{ trigger.date }}");
    }

    @Generated
    protected TimeBetween(TimeBetweenBuilder<?, ?> b) {
        super(b);
        this.date = b.date$set ? b.date$value : TimeBetween.$default$date();
        this.after = b.after;
        this.before = b.before;
    }

    @Generated
    public static TimeBetweenBuilder<?, ?> builder() {
        return new TimeBetweenBuilderImpl();
    }

    @Generated
    public String toString() {
        return "TimeBetween(super=" + super.toString() + ", date=" + String.valueOf(this.getDate()) + ", after=" + String.valueOf(this.getAfter()) + ", before=" + String.valueOf(this.getBefore()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeBetween)) {
            return false;
        }
        TimeBetween other = (TimeBetween)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$date = this.getDate();
        Property<String> other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Property<OffsetTime> this$after = this.getAfter();
        Property<OffsetTime> other$after = other.getAfter();
        if (this$after == null ? other$after != null : !((Object)this$after).equals(other$after)) {
            return false;
        }
        Property<OffsetTime> this$before = this.getBefore();
        Property<OffsetTime> other$before = other.getBefore();
        return !(this$before == null ? other$before != null : !((Object)this$before).equals(other$before));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeBetween;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Property<OffsetTime> $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : ((Object)$after).hashCode());
        Property<OffsetTime> $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : ((Object)$before).hashCode());
        return result;
    }

    @Generated
    public Property<String> getDate() {
        return this.date;
    }

    @Generated
    public Property<OffsetTime> getAfter() {
        return this.after;
    }

    @Generated
    public Property<OffsetTime> getBefore() {
        return this.before;
    }

    @Generated
    public TimeBetween() {
        this.date = TimeBetween.$default$date();
    }

    @Generated
    public static abstract class TimeBetweenBuilder<C extends TimeBetween, B extends TimeBetweenBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private boolean date$set;
        @Generated
        private Property<String> date$value;
        @Generated
        private Property<OffsetTime> after;
        @Generated
        private Property<OffsetTime> before;

        @Generated
        public B date(Property<String> date) {
            this.date$value = date;
            this.date$set = true;
            return (B)this.self();
        }

        @Generated
        public B after(Property<OffsetTime> after) {
            this.after = after;
            return (B)this.self();
        }

        @Generated
        public B before(Property<OffsetTime> before) {
            this.before = before;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TimeBetween.TimeBetweenBuilder(super=" + super.toString() + ", date$value=" + String.valueOf(this.date$value) + ", after=" + String.valueOf(this.after) + ", before=" + String.valueOf(this.before) + ")";
        }
    }

    @Generated
    private static final class TimeBetweenBuilderImpl
    extends TimeBetweenBuilder<TimeBetween, TimeBetweenBuilderImpl> {
        @Generated
        private TimeBetweenBuilderImpl() {
        }

        @Override
        @Generated
        protected TimeBetweenBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TimeBetween build() {
            return new TimeBetween(this);
        }
    }
}

