/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.dashboard.chart;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.dashboards.charts.DataChart;
import io.kestra.core.validations.TimeSeriesChartValidation;
import io.kestra.plugin.core.dashboard.chart.timeseries.TimeSeriesColumnDescriptor;
import io.kestra.plugin.core.dashboard.chart.timeseries.TimeSeriesOption;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@TimeSeriesChartValidation
@Schema(title="Track trends over time with dynamic time series charts.")
@Plugin(examples={@Example(title="Display a chart with Executions over the last week.", full=true, code={"charts:\n  - id: executions_timeseries\n    type: io.kestra.plugin.core.dashboard.chart.TimeSeries\n    chartOptions:\n        displayName: Total Executions\n        description: Executions last week\n        legend:\n            enabled: true\n        column: date\n        colorByColumn: state\n    data:\n        type: io.kestra.plugin.core.dashboard.data.Executions\n        columns:\n            date:\n                field: START_DATE\n                displayName: Date\n            state:\n                field: STATE\n            total:\n                displayName: Executions\n                agg: COUNT\n                graphStyle: BARS\n            duration:\n                displayName: Duration\n                field: DURATION\n                agg: SUM\n                graphStyle: LINES\n"})})
public class TimeSeries<F extends Enum<F>, D extends DataFilter<F, ? extends TimeSeriesColumnDescriptor<F>>>
extends DataChart<TimeSeriesOption, D> {
    @Override
    public Integer minNumberOfAggregations() {
        return 1;
    }

    @Override
    public Integer maxNumberOfAggregations() {
        return 2;
    }

    @Generated
    protected TimeSeries(TimeSeriesBuilder<F, D, ?, ?> b) {
        super(b);
    }

    @Generated
    public static <F extends Enum<F>, D extends DataFilter<F, ? extends TimeSeriesColumnDescriptor<F>>> TimeSeriesBuilder<F, D, ?, ?> builder() {
        return new TimeSeriesBuilderImpl();
    }

    @Generated
    public TimeSeriesBuilder<F, D, ?, ?> toBuilder() {
        return new TimeSeriesBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public TimeSeries() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeSeries)) {
            return false;
        }
        TimeSeries other = (TimeSeries)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeSeries;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    private static final class TimeSeriesBuilderImpl<F extends Enum<F>, D extends DataFilter<F, ? extends TimeSeriesColumnDescriptor<F>>>
    extends TimeSeriesBuilder<F, D, TimeSeries<F, D>, TimeSeriesBuilderImpl<F, D>> {
        @Generated
        private TimeSeriesBuilderImpl() {
        }

        @Override
        @Generated
        protected TimeSeriesBuilderImpl<F, D> self() {
            return this;
        }

        @Override
        @Generated
        public TimeSeries<F, D> build() {
            return new TimeSeries(this);
        }
    }

    @Generated
    public static abstract class TimeSeriesBuilder<F extends Enum<F>, D extends DataFilter<F, ? extends TimeSeriesColumnDescriptor<F>>, C extends TimeSeries<F, D>, B extends TimeSeriesBuilder<F, D, C, B>>
    extends DataChart.DataChartBuilder<TimeSeriesOption, D, C, B> {
        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TimeSeriesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static <F extends Enum<F>, D extends DataFilter<F, ? extends TimeSeriesColumnDescriptor<F>>> void $fillValuesFromInstanceIntoBuilder(TimeSeries<F, D> instance, TimeSeriesBuilder<F, D, ?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TimeSeries.TimeSeriesBuilder(super=" + super.toString() + ")";
        }
    }
}

