/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKilled;
import io.kestra.core.models.executions.ExecutionKilledExecution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.ExecutionUpdatableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(title="Terminate an execution in the state defined by the property state.", description="Note that if this execution has running tasks, for example in a parallel branch, the tasks will not be terminated except if `state` is set to `KILLED`.")
@Plugin(examples={@Example(full=true, code={"id: exit\nnamespace: company.team\n\ninputs:\n  - id: state\n    type: SELECT\n    values:\n      - CONTINUE\n      - END\n    defaults: CONTINUE\n\ntasks:\n  - id: if\n    type: io.kestra.plugin.core.flow.If\n    condition: \"{{inputs.state == 'CONTINUE'}}\"\n    then:\n      - id: hello\n        type: io.kestra.plugin.core.log.Log\n        message: I'm continuing\n    else:\n      - id: exit\n        type: io.kestra.plugin.core.execution.Exit\n        state: KILLED\n  - id: end\n    type: io.kestra.plugin.core.log.Log\n    message: I'm ending\n"})})
public class Exit
extends Task
implements ExecutionUpdatableTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Exit.class);
    @NotNull
    @Schema(title="The execution exit state", description="Using `KILLED` will end existing running tasks, and any other execution with a different state will continue to run.")
    private Property<ExitState> state;

    @Override
    public Execution update(Execution execution, RunContext runContext) throws Exception {
        State.Type exitState = this.executionState(runContext);
        if (exitState == State.Type.KILLED) {
            QueueInterface killQueue = (QueueInterface)((DefaultRunContext)runContext).getApplicationContext().getBean(QueueInterface.class, Qualifiers.byName((String)"executionKilledQueue"));
            killQueue.emit(((ExecutionKilledExecution.ExecutionKilledExecutionBuilder)((ExecutionKilled.ExecutionKilledBuilder)((ExecutionKilledExecution.ExecutionKilledExecutionBuilder)((ExecutionKilledExecution.ExecutionKilledExecutionBuilder)ExecutionKilledExecution.builder().state(ExecutionKilled.State.REQUESTED)).executionId(execution.getId())).isOnKillCascade(false)).tenantId(execution.getTenantId())).build());
            return execution.withState(exitState);
        }
        return execution.findLastNotTerminated().map(taskRun -> {
            try {
                TaskRun newTaskRun = taskRun.withState(exitState);
                Execution newExecution = execution.withTaskRun(newTaskRun);
                while (newTaskRun.getParentTaskRunId() != null) {
                    newTaskRun = newExecution.findTaskRunByTaskRunId(newTaskRun.getParentTaskRunId()).withState(exitState);
                    newExecution = newExecution.withTaskRun(newTaskRun);
                }
                return newExecution;
            }
            catch (InternalException e) {
                log.warn("Unable to update the taskrun state", (Throwable)e);
                return execution.withState(exitState);
            }
        }).orElse(execution).withState(exitState);
    }

    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution) throws IllegalVariableEvaluationException {
        return Optional.of(this.executionState(runContext));
    }

    private State.Type executionState(RunContext runContext) throws IllegalVariableEvaluationException {
        return switch (runContext.render(this.state).as(ExitState.class).orElseThrow().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> State.Type.SUCCESS;
            case 1 -> State.Type.WARNING;
            case 2 -> State.Type.KILLED;
            case 3 -> State.Type.FAILED;
            case 4 -> State.Type.CANCELLED;
        };
    }

    @Generated
    private static Property<ExitState> $default$state() {
        return Property.ofValue(ExitState.SUCCESS);
    }

    @Generated
    protected Exit(ExitBuilder<?, ?> b) {
        super(b);
        this.state = b.state$set ? b.state$value : Exit.$default$state();
    }

    @Generated
    public static ExitBuilder<?, ?> builder() {
        return new ExitBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Exit(super=" + super.toString() + ", state=" + String.valueOf(this.getState()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Exit)) {
            return false;
        }
        Exit other = (Exit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<ExitState> this$state = this.getState();
        Property<ExitState> other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)this$state).equals(other$state));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Exit;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<ExitState> $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        return result;
    }

    @Generated
    public Property<ExitState> getState() {
        return this.state;
    }

    @Generated
    public Exit() {
        this.state = Exit.$default$state();
    }

    public static enum ExitState {
        SUCCESS,
        WARNING,
        KILLED,
        FAILED,
        CANCELED;

    }

    @Generated
    public static abstract class ExitBuilder<C extends Exit, B extends ExitBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private boolean state$set;
        @Generated
        private Property<ExitState> state$value;

        @Generated
        public B state(Property<ExitState> state) {
            this.state$value = state;
            this.state$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Exit.ExitBuilder(super=" + super.toString() + ", state$value=" + String.valueOf(this.state$value) + ")";
        }
    }

    @Generated
    private static final class ExitBuilderImpl
    extends ExitBuilder<Exit, ExitBuilderImpl> {
        @Generated
        private ExitBuilderImpl() {
        }

        @Override
        @Generated
        protected ExitBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Exit build() {
            return new Exit(this);
        }
    }
}

