/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.TruthUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

@Schema(title="Intentionally fail the execution.", description="Used to fail the execution, for example, on a switch branch or on some conditions based on the execution context.")
@Plugin(examples={@Example(full=true, title="Fail on a switch branch", code={"id: fail_on_switch\nnamespace: company.team\n\ninputs:\n  - id: param\n    type: STRING\n    required: true\n\ntasks:\n  - id: switch\n    type: io.kestra.plugin.core.flow.Switch\n    value: \"{{inputs.param}}\"\n    cases:\n      case1:\n        - id: case1\n          type: io.kestra.plugin.core.log.Log\n          message: Case 1\n      case2:\n        - id: case2\n          type: io.kestra.plugin.core.log.Log\n          message: Case 2\n      notexist:\n        - id: fail\n          type: io.kestra.plugin.core.execution.Fail\n      default:\n        - id: default\n          type: io.kestra.plugin.core.log.Log\n          message: default\n"}), @Example(full=true, title="Fail on a condition", code={"id: fail_on_condition\nnamespace: company.team\n\ninputs:\n  - name: param\n    type: STRING\n    required: true\n\ntasks:\n  - id: before\n    type: io.kestra.plugin.core.debug.Echo\n    format: I'm before the fail on condition\n\n  - id: fail\n    type: io.kestra.plugin.core.execution.Fail\n    condition: '{{ inputs.param == \"fail\" }}'\n\n  - id: after\n    type: io.kestra.plugin.core.debug.Echo\n    format: I'm after the fail on condition\n"}), @Example(full=true, title="Using errorLogs function to send error message to Slack", code={"id: error_logs\nnamespace: company.team\n\ntasks:\n- id: fail\n    type: io.kestra.plugin.core.execution.Fail\n    errorMessage: Something went wrong, make sure to fix it asap!\n\nerrors:\n- id: slack\n    type: io.kestra.plugin.notifications.slack.SlackIncomingWebhook\n    url: \"{{ secret('SLACK_WEBHOOK') }}\"\n    payload: |\n    {\n        \"text\": \"Failure alert for flow `{{ flow.namespace }}.{{ flow.id }}` with ID `{{ execution.id }}`. Here is a bit more context about why the execution failed: `{{ errorLogs()[0]['message'] }}`\"\n    }\n"})}, aliases={"io.kestra.core.tasks.executions.Fail"})
public class Fail
extends Task
implements RunnableTask<VoidOutput> {
    @Schema(title="Optional condition, must coerce to a boolean.", description="Boolean coercion allows 0, -0, and '' to coerce to false, all other values to coerce to true.")
    private Property<String> condition;
    @Schema(title="Optional error message")
    private Property<String> errorMessage;

    @Override
    public VoidOutput run(RunContext runContext) throws Exception {
        if (this.condition != null) {
            String rendered = runContext.render(this.condition).as(String.class).orElse(null);
            if (TruthUtils.isTruthy(rendered)) {
                runContext.logger().error((String)runContext.render(this.errorMessage).as(String.class).orElse(null));
                throw new Exception("Fail on a condition");
            }
            return null;
        }
        throw new Exception(runContext.render(this.errorMessage).as(String.class).orElse(null));
    }

    @Generated
    private static Property<String> $default$errorMessage() {
        return Property.ofValue("Task failure");
    }

    @Generated
    protected Fail(FailBuilder<?, ?> b) {
        super(b);
        this.condition = b.condition;
        this.errorMessage = b.errorMessage$set ? b.errorMessage$value : Fail.$default$errorMessage();
    }

    @Generated
    public static FailBuilder<?, ?> builder() {
        return new FailBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Fail(super=" + super.toString() + ", condition=" + String.valueOf(this.getCondition()) + ", errorMessage=" + String.valueOf(this.getErrorMessage()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fail)) {
            return false;
        }
        Fail other = (Fail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$condition = this.getCondition();
        Property<String> other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition)) {
            return false;
        }
        Property<String> this$errorMessage = this.getErrorMessage();
        Property<String> other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !((Object)this$errorMessage).equals(other$errorMessage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Fail;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        Property<String> $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : ((Object)$errorMessage).hashCode());
        return result;
    }

    @Generated
    public Property<String> getCondition() {
        return this.condition;
    }

    @Generated
    public Property<String> getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public Fail() {
        this.errorMessage = Fail.$default$errorMessage();
    }

    @Generated
    public static abstract class FailBuilder<C extends Fail, B extends FailBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> condition;
        @Generated
        private boolean errorMessage$set;
        @Generated
        private Property<String> errorMessage$value;

        @Generated
        public B condition(Property<String> condition) {
            this.condition = condition;
            return (B)this.self();
        }

        @Generated
        public B errorMessage(Property<String> errorMessage) {
            this.errorMessage$value = errorMessage;
            this.errorMessage$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Fail.FailBuilder(super=" + super.toString() + ", condition=" + String.valueOf(this.condition) + ", errorMessage$value=" + String.valueOf(this.errorMessage$value) + ")";
        }
    }

    @Generated
    private static final class FailBuilderImpl
    extends FailBuilder<Fail, FailBuilderImpl> {
        @Generated
        private FailBuilderImpl() {
        }

        @Override
        @Generated
        protected FailBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Fail build() {
            return new Fail(this);
        }
    }
}

