/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.ExecutionUpdatableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.MapUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@Schema(title="Allow to set execution variables. These variables are available via the `{{ vars.name }}` expression.")
@Plugin(examples={@Example(full=true, title="Set variables", code={"id: variables\nnamespace: company.team\n\nvariables:\n  name: World\n\ntasks:\n  - id: set_vars\n    type: io.kestra.plugin.core.execution.SetVariables\n    variables:\n      message: Hello\n      name: Lo\u00efc\n  - id: hello\n    type: io.kestra.plugin.core.log.Log\n    message: \"{{ vars.message }} {{ vars.name }}\""})})
public class SetVariables
extends Task
implements ExecutionUpdatableTask {
    @Schema(title="The variables")
    @NotNull
    private Property<Map<String, Object>> variables;
    @Schema(title="Flag specifying whether to overwrite existing variables")
    @NotNull
    private Property<Boolean> overwrite;

    @Override
    public Execution update(Execution execution, RunContext runContext) throws Exception {
        List<String> duplicated;
        Map<String, Object> renderedVars = runContext.render(this.variables).asMap(String.class, Object.class);
        boolean renderedOverwrite = runContext.render(this.overwrite).as(Boolean.class).orElseThrow();
        if (!renderedOverwrite && !(duplicated = renderedVars.keySet().stream().filter(key -> execution.getVariables().containsKey(key)).toList()).isEmpty()) {
            throw new IllegalArgumentException("`overwrite` is set to false and the following variables already exist: " + String.join((CharSequence)",", duplicated));
        }
        return execution.withVariables(MapUtils.deepMerge(execution.getVariables(), renderedVars));
    }

    @Generated
    private static Property<Boolean> $default$overwrite() {
        return Property.ofValue(true);
    }

    @Generated
    protected SetVariables(SetVariablesBuilder<?, ?> b) {
        super(b);
        this.variables = b.variables;
        this.overwrite = b.overwrite$set ? b.overwrite$value : SetVariables.$default$overwrite();
    }

    @Generated
    public static SetVariablesBuilder<?, ?> builder() {
        return new SetVariablesBuilderImpl();
    }

    @Generated
    public String toString() {
        return "SetVariables(super=" + super.toString() + ", variables=" + String.valueOf(this.getVariables()) + ", overwrite=" + String.valueOf(this.getOverwrite()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetVariables)) {
            return false;
        }
        SetVariables other = (SetVariables)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Map<String, Object>> this$variables = this.getVariables();
        Property<Map<String, Object>> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        Property<Boolean> this$overwrite = this.getOverwrite();
        Property<Boolean> other$overwrite = other.getOverwrite();
        return !(this$overwrite == null ? other$overwrite != null : !((Object)this$overwrite).equals(other$overwrite));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetVariables;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Map<String, Object>> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        Property<Boolean> $overwrite = this.getOverwrite();
        result = result * 59 + ($overwrite == null ? 43 : ((Object)$overwrite).hashCode());
        return result;
    }

    @Generated
    public Property<Map<String, Object>> getVariables() {
        return this.variables;
    }

    @Generated
    public Property<Boolean> getOverwrite() {
        return this.overwrite;
    }

    @Generated
    public SetVariables() {
        this.overwrite = SetVariables.$default$overwrite();
    }

    @Generated
    public static abstract class SetVariablesBuilder<C extends SetVariables, B extends SetVariablesBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<Map<String, Object>> variables;
        @Generated
        private boolean overwrite$set;
        @Generated
        private Property<Boolean> overwrite$value;

        @Generated
        public B variables(Property<Map<String, Object>> variables) {
            this.variables = variables;
            return (B)this.self();
        }

        @Generated
        public B overwrite(Property<Boolean> overwrite) {
            this.overwrite$value = overwrite;
            this.overwrite$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SetVariables.SetVariablesBuilder(super=" + super.toString() + ", variables=" + String.valueOf(this.variables) + ", overwrite$value=" + String.valueOf(this.overwrite$value) + ")";
        }
    }

    @Generated
    private static final class SetVariablesBuilderImpl
    extends SetVariablesBuilder<SetVariables, SetVariablesBuilderImpl> {
        @Generated
        private SetVariablesBuilderImpl() {
        }

        @Override
        @Generated
        protected SetVariablesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SetVariables build() {
            return new SetVariables(this);
        }
    }
}

