/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.GraphUtils;
import io.kestra.core.validations.DagTaskValidation;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;

@DagTaskValidation
@Schema(title="Create a DAG of tasks without explicitly specifying the order in which the tasks must run.", description="List your tasks and their dependencies, and Kestra will figure out the execution sequence.\nEach task can only depend on other tasks from the DAG task.\nFor technical reasons, low-code interaction via UI forms is disabled for now when using this task.")
@Plugin(examples={@Example(title="Run a series of tasks for which the execution order is defined by their upstream dependencies.", full=true, code={"id: dag_flow\nnamespace: company.team\ntasks:\n  - id: dag\n    type: io.kestra.plugin.core.flow.Dag\n    tasks:\n      - task:\n          id: task1\n          type: io.kestra.plugin.core.log.Log\n          message: task 1\n      - task:\n          id: task2\n          type: io.kestra.plugin.core.log.Log\n          message: task 2\n        dependsOn:\n          - task1\n      - task:\n          id: task3\n          type: io.kestra.plugin.core.log.Log\n          message: task 3\n        dependsOn:\n          - task1\n      - task:\n          id: task4\n          type: io.kestra.plugin.core.log.Log\n          message: task 4\n        dependsOn:\n          - task2\n      - task:\n          id: task5\n          type: io.kestra.plugin.core.log.Log\n          message: task 5\n        dependsOn:\n          - task4\n          - task3\n"})}, aliases={"io.kestra.core.tasks.flows.Dag"})
public class Dag
extends Task
implements FlowableTask<VoidOutput> {
    @NotNull
    @Schema(title="Number of concurrent parallel tasks that can be running at any point in time", description="If the value is `0`, no concurrency limit exists for the tasks in a DAG and all tasks that can run in parallel will start at the same time.")
    private final Property<Integer> concurrent;
    @Valid
    @NotEmpty
    private List<DagTask> tasks;
    @Valid
    @PluginProperty
    protected List<Task> errors;
    @Valid
    @JsonProperty(value="finally")
    protected List<Task> _finally;

    @Override
    public List<Task> getFinally() {
        return this._finally;
    }

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.DYNAMIC);
        this.controlTask();
        GraphUtils.dag(subGraph, this.getTasks(), this.errors, this._finally, taskRun, execution);
        return subGraph;
    }

    private void controlTask() throws IllegalVariableEvaluationException {
        List<String> dagCheckNotExistTasks = this.dagCheckNotExistTask(this.tasks);
        if (!dagCheckNotExistTasks.isEmpty()) {
            throw new IllegalVariableEvaluationException("Some task doesn't exist on task '" + this.id + "': " + String.join((CharSequence)", ", dagCheckNotExistTasks));
        }
        ArrayList<String> cyclicDependenciesTasks = this.dagCheckCyclicDependencies(this.tasks);
        if (!cyclicDependenciesTasks.isEmpty()) {
            throw new IllegalVariableEvaluationException("Infinite loop detected on task '" + this.id + "': " + String.join((CharSequence)", ", cyclicDependenciesTasks));
        }
    }

    @Override
    public List<Task> allChildTasks() {
        return Stream.concat(this.tasks != null ? this.tasks.stream().map(DagTask::getTask) : Stream.empty(), Stream.concat(this.errors != null ? this.errors.stream() : Stream.empty(), this._finally != null ? this._finally.stream() : Stream.empty())).toList();
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveTasks(this.tasks.stream().map(DagTask::getTask).toList(), parentTaskRun);
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        this.controlTask();
        return FlowableUtils.resolveDagNexts(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.errors, parentTaskRun), FlowableUtils.resolveTasks(this._finally, parentTaskRun), parentTaskRun, runContext.render(this.concurrent).as(Integer.class).orElseThrow(), this.tasks);
    }

    public List<String> dagCheckNotExistTask(List<DagTask> taskDepends) {
        List dependenciesIds = taskDepends.stream().map(DagTask::getDependsOn).filter(Objects::nonNull).flatMap(Collection::stream).toList();
        List<String> tasksIds = taskDepends.stream().map(taskDepend -> taskDepend.getTask().getId()).toList();
        return dependenciesIds.stream().filter(dependencyId -> !tasksIds.contains(dependencyId)).toList();
    }

    public ArrayList<String> dagCheckCyclicDependencies(List<DagTask> taskDepends) {
        ArrayList<String> cyclicDependency = new ArrayList<String>();
        taskDepends.forEach(taskDepend -> {
            ArrayList<String> nestedDependencies;
            if (taskDepend.getDependsOn() != null && (nestedDependencies = this.nestedDependencies((DagTask)taskDepend, taskDepends, (List<String>)new ArrayList<String>())).contains(taskDepend.getTask().getId())) {
                cyclicDependency.add(taskDepend.getTask().getId());
            }
        });
        return cyclicDependency;
    }

    private ArrayList<String> nestedDependencies(DagTask taskDepend, List<DagTask> tasks, List<String> visited) {
        ArrayList<String> localVisited = new ArrayList<String>(visited);
        if (taskDepend.getDependsOn() != null) {
            taskDepend.getDependsOn().stream().filter(depend -> !localVisited.contains(depend)).forEach(depend -> {
                localVisited.add((String)depend);
                Optional<DagTask> task = tasks.stream().filter(t -> t.getTask().getId().equals(depend)).findFirst();
                if (task.isPresent()) {
                    localVisited.addAll(this.nestedDependencies(task.get(), tasks, localVisited));
                }
            });
        }
        return localVisited;
    }

    @Generated
    private static Property<Integer> $default$concurrent() {
        return Property.ofValue(0);
    }

    @Generated
    protected Dag(DagBuilder<?, ?> b) {
        super(b);
        this.concurrent = b.concurrent$set ? b.concurrent$value : Dag.$default$concurrent();
        this.tasks = b.tasks;
        this.errors = b.errors;
        this._finally = b._finally;
    }

    @Generated
    public static DagBuilder<?, ?> builder() {
        return new DagBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Dag(super=" + super.toString() + ", concurrent=" + String.valueOf(this.getConcurrent()) + ", tasks=" + String.valueOf(this.getTasks()) + ", errors=" + String.valueOf(this.getErrors()) + ", _finally=" + String.valueOf(this._finally) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dag)) {
            return false;
        }
        Dag other = (Dag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Integer> this$concurrent = this.getConcurrent();
        Property<Integer> other$concurrent = other.getConcurrent();
        if (this$concurrent == null ? other$concurrent != null : !((Object)this$concurrent).equals(other$concurrent)) {
            return false;
        }
        List<DagTask> this$tasks = this.getTasks();
        List<DagTask> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<Task> this$_finally = this._finally;
        List<Task> other$_finally = other._finally;
        return !(this$_finally == null ? other$_finally != null : !((Object)this$_finally).equals(other$_finally));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Integer> $concurrent = this.getConcurrent();
        result = result * 59 + ($concurrent == null ? 43 : ((Object)$concurrent).hashCode());
        List<DagTask> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<Task> $_finally = this._finally;
        result = result * 59 + ($_finally == null ? 43 : ((Object)$_finally).hashCode());
        return result;
    }

    @Generated
    public Property<Integer> getConcurrent() {
        return this.concurrent;
    }

    @Generated
    public List<DagTask> getTasks() {
        return this.tasks;
    }

    @Override
    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Generated
    public Dag() {
        this.concurrent = Dag.$default$concurrent();
    }

    @Introspected
    public static class DagTask {
        @NotNull
        @Schema(title="The task within the DAG")
        @PluginProperty
        private Task task;
        @PluginProperty
        @Schema(title="The list of task IDs that should have been successfully executed before starting this task")
        private List<String> dependsOn;

        @Generated
        protected DagTask(DagTaskBuilder<?, ?> b) {
            this.task = b.task;
            this.dependsOn = b.dependsOn;
        }

        @Generated
        public static DagTaskBuilder<?, ?> builder() {
            return new DagTaskBuilderImpl();
        }

        @Generated
        public String toString() {
            return "Dag.DagTask(task=" + String.valueOf(this.getTask()) + ", dependsOn=" + String.valueOf(this.getDependsOn()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DagTask)) {
                return false;
            }
            DagTask other = (DagTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Task this$task = this.getTask();
            Task other$task = other.getTask();
            if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
                return false;
            }
            List<String> this$dependsOn = this.getDependsOn();
            List<String> other$dependsOn = other.getDependsOn();
            return !(this$dependsOn == null ? other$dependsOn != null : !((Object)this$dependsOn).equals(other$dependsOn));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DagTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Task $task = this.getTask();
            result = result * 59 + ($task == null ? 43 : $task.hashCode());
            List<String> $dependsOn = this.getDependsOn();
            result = result * 59 + ($dependsOn == null ? 43 : ((Object)$dependsOn).hashCode());
            return result;
        }

        @Generated
        public Task getTask() {
            return this.task;
        }

        @Generated
        public List<String> getDependsOn() {
            return this.dependsOn;
        }

        @Generated
        public DagTask() {
        }

        @Generated
        public static abstract class DagTaskBuilder<C extends DagTask, B extends DagTaskBuilder<C, B>> {
            @Generated
            private Task task;
            @Generated
            private List<String> dependsOn;

            @Generated
            public B task(Task task) {
                this.task = task;
                return this.self();
            }

            @Generated
            public B dependsOn(List<String> dependsOn) {
                this.dependsOn = dependsOn;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "Dag.DagTask.DagTaskBuilder(task=" + String.valueOf(this.task) + ", dependsOn=" + String.valueOf(this.dependsOn) + ")";
            }
        }

        @Generated
        private static final class DagTaskBuilderImpl
        extends DagTaskBuilder<DagTask, DagTaskBuilderImpl> {
            @Generated
            private DagTaskBuilderImpl() {
            }

            @Override
            @Generated
            protected DagTaskBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DagTask build() {
                return new DagTask(this);
            }
        }
    }

    @Generated
    public static abstract class DagBuilder<C extends Dag, B extends DagBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private boolean concurrent$set;
        @Generated
        private Property<Integer> concurrent$value;
        @Generated
        private List<DagTask> tasks;
        @Generated
        private List<Task> errors;
        @Generated
        private List<Task> _finally;

        @Generated
        public B concurrent(Property<Integer> concurrent) {
            this.concurrent$value = concurrent;
            this.concurrent$set = true;
            return (B)this.self();
        }

        @Generated
        public B tasks(List<DagTask> tasks) {
            this.tasks = tasks;
            return (B)this.self();
        }

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @JsonProperty(value="finally")
        @Generated
        public B _finally(List<Task> _finally) {
            this._finally = _finally;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Dag.DagBuilder(super=" + super.toString() + ", concurrent$value=" + String.valueOf(this.concurrent$value) + ", tasks=" + String.valueOf(this.tasks) + ", errors=" + String.valueOf(this.errors) + ", _finally=" + String.valueOf(this._finally) + ")";
        }
    }

    @Generated
    private static final class DagBuilderImpl
    extends DagBuilder<Dag, DagBuilderImpl> {
        @Generated
        private DagBuilderImpl() {
        }

        @Override
        @Generated
        protected DagBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Dag build() {
            return new Dag(this);
        }
    }
}

