/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.GraphUtils;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.TruthUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;

@Schema(title="Process tasks conditionally depending on a contextual value.", description="Allow some workflow based on context variables, for example, branch a flow based on a previous task.")
@Plugin(examples={@Example(full=true, code={"id: if\nnamespace: company.team\n\ninputs:\n  - id: string\n    type: STRING\n    required: true\n\ntasks:\n  - id: if\n    type: io.kestra.plugin.core.flow.If\n    condition: \"{{ inputs.string == 'Condition' }}\"\n    then:\n      - id: when_true\n        type: io.kestra.plugin.core.log.Log\n        message: \"Condition was true\"\n    else:\n      - id: when_false\n        type: io.kestra.plugin.core.log.Log\n        message: \"Condition was false\"\n"})}, aliases={"io.kestra.core.tasks.flows.If"})
public class If
extends Task
implements FlowableTask<Output> {
    @Schema(title="The `If` condition which can be any expression that evaluates to a boolean value.", description="Boolean coercion allows 0, -0, null and '' to evaluate to false, all other values will evaluate to true.")
    @PluginProperty(dynamic=true)
    private String condition;
    @Valid
    @PluginProperty
    @Schema(title="List of tasks to execute if the condition is true")
    @NotEmpty
    private List<Task> then;
    @Valid
    @PluginProperty
    @Schema(title="List of tasks to execute if the condition is false")
    @JsonProperty(value="else")
    private List<Task> _else;
    @Valid
    @PluginProperty
    @Schema(title="List of tasks to execute in case of errors of a child task")
    private List<Task> errors;
    @Valid
    @JsonProperty(value="finally")
    protected List<Task> _finally;

    @Override
    public List<Task> getFinally() {
        return this._finally;
    }

    @Override
    public List<Task> getErrors() {
        return this.errors;
    }

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.CHOICE);
        GraphUtils.ifElse(subGraph, this.then, this._else, this._finally, this.errors, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<Task> allChildTasks() {
        return Stream.concat(this.then != null ? this.then.stream() : Stream.empty(), Stream.concat(this._else != null ? this._else.stream() : Stream.empty(), Stream.concat(this.errors != null ? this.errors.stream() : Stream.empty(), this._finally != null ? this._finally.stream() : Stream.empty()))).toList();
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        Boolean evaluationResult = parentTaskRun.getOutputs() == null || parentTaskRun.getOutputs().get("evaluationResult") == null ? this.isTrue(runContext) : (Boolean)parentTaskRun.getOutputs().get("evaluationResult");
        if (Boolean.TRUE.equals(evaluationResult)) {
            return FlowableUtils.resolveTasks(this.then, parentTaskRun);
        }
        return FlowableUtils.resolveTasks(this._else, parentTaskRun);
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveSequentialNexts(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.errors, parentTaskRun), FlowableUtils.resolveTasks(this._finally, parentTaskRun), parentTaskRun);
    }

    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        List<ResolvedTask> childTasks = ListUtils.emptyOnNull(this.childTasks(runContext, parentTaskRun)).stream().filter(resolvedTask -> resolvedTask.getTask().getDisabled() == false).toList();
        if (ListUtils.isEmpty(childTasks)) {
            return Optional.of(execution.guessFinalState(null, parentTaskRun, this.isAllowFailure(), this.isAllowWarning()));
        }
        return FlowableUtils.resolveState(execution, childTasks, FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), FlowableUtils.resolveTasks(this.getFinally(), parentTaskRun), parentTaskRun, runContext, this.isAllowFailure(), this.isAllowWarning());
    }

    @Override
    public Output outputs(RunContext runContext) throws Exception {
        Boolean evaluationResult = this.isTrue(runContext);
        return Output.builder().evaluationResult(evaluationResult).build();
    }

    private Boolean isTrue(RunContext runContext) throws IllegalVariableEvaluationException {
        String rendered = runContext.render(this.condition);
        return TruthUtils.isTruthy(rendered);
    }

    @Generated
    protected If(IfBuilder<?, ?> b) {
        super(b);
        this.condition = b.condition;
        this.then = b.then;
        this._else = b._else;
        this.errors = b.errors;
        this._finally = b._finally;
    }

    @Generated
    public static IfBuilder<?, ?> builder() {
        return new IfBuilderImpl();
    }

    @Generated
    public String toString() {
        return "If(super=" + super.toString() + ", condition=" + this.getCondition() + ", then=" + String.valueOf(this.getThen()) + ", _else=" + String.valueOf(this.get_else()) + ", errors=" + String.valueOf(this.getErrors()) + ", _finally=" + String.valueOf(this._finally) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof If)) {
            return false;
        }
        If other = (If)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        List<Task> this$then = this.getThen();
        List<Task> other$then = other.getThen();
        if (this$then == null ? other$then != null : !((Object)this$then).equals(other$then)) {
            return false;
        }
        List<Task> this$_else = this.get_else();
        List<Task> other$_else = other.get_else();
        if (this$_else == null ? other$_else != null : !((Object)this$_else).equals(other$_else)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<Task> this$_finally = this._finally;
        List<Task> other$_finally = other._finally;
        return !(this$_finally == null ? other$_finally != null : !((Object)this$_finally).equals(other$_finally));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof If;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        List<Task> $then = this.getThen();
        result = result * 59 + ($then == null ? 43 : ((Object)$then).hashCode());
        List<Task> $_else = this.get_else();
        result = result * 59 + ($_else == null ? 43 : ((Object)$_else).hashCode());
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<Task> $_finally = this._finally;
        result = result * 59 + ($_finally == null ? 43 : ((Object)$_finally).hashCode());
        return result;
    }

    @Generated
    public String getCondition() {
        return this.condition;
    }

    @Generated
    public List<Task> getThen() {
        return this.then;
    }

    @Generated
    public List<Task> get_else() {
        return this._else;
    }

    @Generated
    public If() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="Condition evaluation result")
        public Boolean evaluationResult;

        @ConstructorProperties(value={"evaluationResult"})
        @Generated
        Output(Boolean evaluationResult) {
            this.evaluationResult = evaluationResult;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Boolean getEvaluationResult() {
            return this.evaluationResult;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Boolean evaluationResult;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder evaluationResult(Boolean evaluationResult) {
                this.evaluationResult = evaluationResult;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.evaluationResult);
            }

            @Generated
            public String toString() {
                return "If.Output.OutputBuilder(evaluationResult=" + this.evaluationResult + ")";
            }
        }
    }

    @Generated
    public static abstract class IfBuilder<C extends If, B extends IfBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String condition;
        @Generated
        private List<Task> then;
        @Generated
        private List<Task> _else;
        @Generated
        private List<Task> errors;
        @Generated
        private List<Task> _finally;

        @Generated
        public B condition(String condition) {
            this.condition = condition;
            return (B)this.self();
        }

        @Generated
        public B then(List<Task> then) {
            this.then = then;
            return (B)this.self();
        }

        @JsonProperty(value="else")
        @Generated
        public B _else(List<Task> _else) {
            this._else = _else;
            return (B)this.self();
        }

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @JsonProperty(value="finally")
        @Generated
        public B _finally(List<Task> _finally) {
            this._finally = _finally;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "If.IfBuilder(super=" + super.toString() + ", condition=" + this.condition + ", then=" + String.valueOf(this.then) + ", _else=" + String.valueOf(this._else) + ", errors=" + String.valueOf(this.errors) + ", _finally=" + String.valueOf(this._finally) + ")";
        }
    }

    @Generated
    private static final class IfBuilderImpl
    extends IfBuilder<If, IfBuilderImpl> {
        @Generated
        private IfBuilderImpl() {
        }

        @Override
        @Generated
        protected IfBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public If build() {
            return new If(this);
        }
    }
}

