/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.hierarchies.AbstractGraph;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.GraphUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;

@Schema(title="Run tasks sequentially in the order they are defined.", description="Used to visually group tasks.")
@Plugin(examples={@Example(full=true, code={"id: sequential\nnamespace: company.team\n\ntasks:\n  - id: sequential\n    type: io.kestra.plugin.core.flow.Sequential\n    tasks:\n      - id: first_task\n        type: io.kestra.plugin.core.debug.Return\n        format: \"{{ task.id }} > {{ taskrun.startDate }}\"\n\n      - id: second_task\n        type: io.kestra.plugin.core.debug.Return\n        format: \"{{ task.id }} > {{ taskrun.id }}\"\n\n  - id: last\n    type: io.kestra.plugin.core.debug.Return\n    format: \"{{ task.id }} > {{ taskrun.startDate }}\"\n"})}, aliases={"io.kestra.core.tasks.flows.Sequential"})
public class Sequential
extends Task
implements FlowableTask<VoidOutput> {
    @Valid
    protected List<Task> errors;
    @Valid
    @JsonProperty(value="finally")
    protected List<Task> _finally;
    @Valid
    @PluginProperty
    @NotEmpty(message="The 'tasks' property cannot be empty")
    private @Valid @NotEmpty(message="The 'tasks' property cannot be empty") List<Task> tasks;

    @Override
    public List<Task> getFinally() {
        return this._finally;
    }

    @Override
    public AbstractGraph tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.SEQUENTIAL);
        GraphUtils.sequential(subGraph, this.getTasks(), this.errors, this._finally, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<Task> allChildTasks() {
        return Stream.concat(this.getTasks() != null ? this.getTasks().stream() : Stream.empty(), Stream.concat(this.getErrors() != null ? this.getErrors().stream() : Stream.empty(), this.getFinally() != null ? this.getFinally().stream() : Stream.empty())).toList();
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveTasks(this.getTasks(), parentTaskRun);
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveSequentialNexts(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), FlowableUtils.resolveTasks(this.getFinally(), parentTaskRun), parentTaskRun);
    }

    @Generated
    protected Sequential(SequentialBuilder<?, ?> b) {
        super(b);
        this.errors = b.errors;
        this._finally = b._finally;
        this.tasks = b.tasks;
    }

    @Generated
    public static SequentialBuilder<?, ?> builder() {
        return new SequentialBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Sequential(super=" + super.toString() + ", errors=" + String.valueOf(this.getErrors()) + ", _finally=" + String.valueOf(this._finally) + ", tasks=" + String.valueOf(this.getTasks()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sequential)) {
            return false;
        }
        Sequential other = (Sequential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<Task> this$_finally = this._finally;
        List<Task> other$_finally = other._finally;
        if (this$_finally == null ? other$_finally != null : !((Object)this$_finally).equals(other$_finally)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Sequential;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<Task> $_finally = this._finally;
        result = result * 59 + ($_finally == null ? 43 : ((Object)$_finally).hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        return result;
    }

    @Override
    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Generated
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Generated
    public Sequential() {
    }

    @Generated
    public static abstract class SequentialBuilder<C extends Sequential, B extends SequentialBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private List<Task> errors;
        @Generated
        private List<Task> _finally;
        @Generated
        private List<Task> tasks;

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @JsonProperty(value="finally")
        @Generated
        public B _finally(List<Task> _finally) {
            this._finally = _finally;
            return (B)this.self();
        }

        @Generated
        public B tasks(List<Task> tasks) {
            this.tasks = tasks;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Sequential.SequentialBuilder(super=" + super.toString() + ", errors=" + String.valueOf(this.errors) + ", _finally=" + String.valueOf(this._finally) + ", tasks=" + String.valueOf(this.tasks) + ")";
        }
    }

    @Generated
    private static final class SequentialBuilderImpl
    extends SequentialBuilder<Sequential, SequentialBuilderImpl> {
        @Generated
        private SequentialBuilderImpl() {
        }

        @Override
        @Generated
        protected SequentialBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Sequential build() {
            return new Sequential(this);
        }
    }
}

