/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.GraphUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.validations.SwitchTaskValidation;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@Schema(title="Run tasks conditionally based on a given value.", description="This task runs a set of tasks based on a given value.\nThe value is evaluated at runtime and compared to the list of cases.\nIf the value matches a case, the corresponding tasks are executed.\nIf the value does not match any case, the default tasks are executed.")
@Plugin(examples={@Example(full=true, code={"id: switch\nnamespace: company.team\n\ninputs:\n  - id: string\n    type: STRING\n    required: true\n\ntasks:\n  - id: switch\n    type: io.kestra.plugin.core.flow.Switch\n    value: \"{{ inputs.string }}\"\n    cases:\n      FIRST:\n        - id: first\n          type: io.kestra.plugin.core.debug.Return\n          format: \"{{ task.id }} > {{ taskrun.startDate }}\"\n      SECOND:\n        - id: second\n          type: io.kestra.plugin.core.debug.Return\n          format: \"{{ task.id }} > {{ taskrun.startDate }}\"\n      THIRD:\n        - id: third\n          type: io.kestra.plugin.core.debug.Return\n          format: \"{{ task.id }} > {{ taskrun.startDate }}\"\n    defaults:\n      - id: default\n        type: io.kestra.plugin.core.debug.Return\n        format: \"{{ task.id }} > {{ taskrun.startDate }}\"\n"})}, aliases={"io.kestra.core.tasks.flows.Switch"})
@Introspected
@SwitchTaskValidation
public class Switch
extends Task
implements FlowableTask<Output> {
    @NotNull
    @Schema(title="The value to be evaluated")
    private Property<String> value;
    @Schema(title="The map of keys and a list of tasks to be executed if the conditional `value` matches the key")
    @PluginProperty
    private Map<String, List<Task>> cases;
    @Valid
    @PluginProperty
    private List<Task> defaults;
    @Valid
    @PluginProperty
    protected List<Task> errors;
    @Valid
    @JsonProperty(value="finally")
    protected List<Task> _finally;

    @Override
    public List<Task> getFinally() {
        return this._finally;
    }

    private String rendererValue(RunContext runContext) throws IllegalVariableEvaluationException {
        return runContext.render(this.value).as(String.class).orElseThrow();
    }

    @Override
    public List<Task> allChildTasks() {
        return Stream.concat(this.defaults != null ? this.defaults.stream() : Stream.empty(), Stream.concat(this.cases != null ? this.cases.values().stream().flatMap(Collection::stream) : Stream.empty(), Stream.concat(this.errors != null ? this.errors.stream() : Stream.empty(), this._finally != null ? this._finally.stream() : Stream.empty()))).toList();
    }

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.CHOICE);
        GraphUtils.switchCase(subGraph, Stream.concat(this.defaults != null ? ImmutableMap.of((Object)"defaults", this.defaults).entrySet().stream() : Stream.empty(), this.cases != null ? this.cases.entrySet().stream() : Stream.empty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), this.errors, this._finally, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        String value = this.rendererValue(runContext);
        return this.cases.entrySet().stream().filter(Rethrow.throwPredicate(entry -> ((String)entry.getKey()).equals(value))).map(Map.Entry::getValue).map(tasks -> FlowableUtils.resolveTasks(tasks, parentTaskRun)).findFirst().orElse(FlowableUtils.resolveTasks(this.defaults, parentTaskRun));
    }

    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveState(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), FlowableUtils.resolveTasks(this.getFinally(), parentTaskRun), parentTaskRun, runContext, this.isAllowFailure(), this.isAllowWarning());
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveSequentialNexts(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.errors, parentTaskRun), FlowableUtils.resolveTasks(this._finally, parentTaskRun), parentTaskRun);
    }

    @Override
    public Output outputs(RunContext runContext) throws IllegalVariableEvaluationException {
        return Output.builder().value(this.rendererValue(runContext)).defaults(this.cases.entrySet().stream().noneMatch(Rethrow.throwPredicate(entry -> ((String)entry.getKey()).equals(this.rendererValue(runContext))))).build();
    }

    @Generated
    protected Switch(SwitchBuilder<?, ?> b) {
        super(b);
        this.value = b.value;
        this.cases = b.cases;
        this.defaults = b.defaults;
        this.errors = b.errors;
        this._finally = b._finally;
    }

    @Generated
    public static SwitchBuilder<?, ?> builder() {
        return new SwitchBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Switch(super=" + super.toString() + ", value=" + String.valueOf(this.getValue()) + ", cases=" + String.valueOf(this.getCases()) + ", defaults=" + String.valueOf(this.getDefaults()) + ", errors=" + String.valueOf(this.getErrors()) + ", _finally=" + String.valueOf(this._finally) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Switch)) {
            return false;
        }
        Switch other = (Switch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$value = this.getValue();
        Property<String> other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Map<String, List<Task>> this$cases = this.getCases();
        Map<String, List<Task>> other$cases = other.getCases();
        if (this$cases == null ? other$cases != null : !((Object)this$cases).equals(other$cases)) {
            return false;
        }
        List<Task> this$defaults = this.getDefaults();
        List<Task> other$defaults = other.getDefaults();
        if (this$defaults == null ? other$defaults != null : !((Object)this$defaults).equals(other$defaults)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<Task> this$_finally = this._finally;
        List<Task> other$_finally = other._finally;
        return !(this$_finally == null ? other$_finally != null : !((Object)this$_finally).equals(other$_finally));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Switch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Map<String, List<Task>> $cases = this.getCases();
        result = result * 59 + ($cases == null ? 43 : ((Object)$cases).hashCode());
        List<Task> $defaults = this.getDefaults();
        result = result * 59 + ($defaults == null ? 43 : ((Object)$defaults).hashCode());
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<Task> $_finally = this._finally;
        result = result * 59 + ($_finally == null ? 43 : ((Object)$_finally).hashCode());
        return result;
    }

    @Generated
    public Property<String> getValue() {
        return this.value;
    }

    @Generated
    public Map<String, List<Task>> getCases() {
        return this.cases;
    }

    @Generated
    public List<Task> getDefaults() {
        return this.defaults;
    }

    @Override
    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Generated
    public Switch() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        private String value;
        private boolean defaults;

        @ConstructorProperties(value={"value", "defaults"})
        @Generated
        Output(String value, boolean defaults) {
            this.value = value;
            this.defaults = defaults;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public boolean isDefaults() {
            return this.defaults;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private String value;
            @Generated
            private boolean defaults;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder value(String value) {
                this.value = value;
                return this;
            }

            @Generated
            public OutputBuilder defaults(boolean defaults) {
                this.defaults = defaults;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.value, this.defaults);
            }

            @Generated
            public String toString() {
                return "Switch.Output.OutputBuilder(value=" + this.value + ", defaults=" + this.defaults + ")";
            }
        }
    }

    @Generated
    public static abstract class SwitchBuilder<C extends Switch, B extends SwitchBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> value;
        @Generated
        private Map<String, List<Task>> cases;
        @Generated
        private List<Task> defaults;
        @Generated
        private List<Task> errors;
        @Generated
        private List<Task> _finally;

        @Generated
        public B value(Property<String> value) {
            this.value = value;
            return (B)this.self();
        }

        @Generated
        public B cases(Map<String, List<Task>> cases) {
            this.cases = cases;
            return (B)this.self();
        }

        @Generated
        public B defaults(List<Task> defaults) {
            this.defaults = defaults;
            return (B)this.self();
        }

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @JsonProperty(value="finally")
        @Generated
        public B _finally(List<Task> _finally) {
            this._finally = _finally;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Switch.SwitchBuilder(super=" + super.toString() + ", value=" + String.valueOf(this.value) + ", cases=" + String.valueOf(this.cases) + ", defaults=" + String.valueOf(this.defaults) + ", errors=" + String.valueOf(this.errors) + ", _finally=" + String.valueOf(this._finally) + ")";
        }
    }

    @Generated
    private static final class SwitchBuilderImpl
    extends SwitchBuilder<Switch, SwitchBuilderImpl> {
        @Generated
        private SwitchBuilderImpl() {
        }

        @Override
        @Generated
        protected SwitchBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Switch build() {
            return new Switch(this);
        }
    }
}

