/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.http;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.http.HttpRequest;
import io.kestra.core.http.client.HttpClient;
import io.kestra.core.http.client.configurations.HttpConfiguration;
import io.kestra.core.http.client.configurations.SslOptions;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.core.http.HttpInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpHeaders;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttp
extends Task
implements HttpInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHttp.class);
    @NotNull
    protected Property<String> uri;
    protected Property<String> method;
    protected Property<String> body;
    protected Property<Map<String, Object>> formData;
    protected Property<String> contentType;
    protected Property<Map<CharSequence, CharSequence>> headers;
    protected HttpConfiguration options;
    @Deprecated
    @Schema(title="If true, allow a failed response code (response code >= 400).", description="Deprecated, use `options.allowFailed` instead.")
    private Property<Boolean> allowFailed;
    @Deprecated
    protected SslOptions sslOptions;

    @Deprecated
    public void setAllowFailed(Property<Boolean> allowFailed) {
        if (this.options == null) {
            this.options = HttpConfiguration.builder().build();
        }
        this.options.setAllowFailed(allowFailed);
    }

    @Deprecated
    public void sslOptions(SslOptions sslOptions) {
        if (this.options == null) {
            this.options = HttpConfiguration.builder().build();
        }
        this.sslOptions = sslOptions;
        this.options.setSsl(sslOptions);
    }

    protected HttpClient client(RunContext runContext) throws IllegalVariableEvaluationException, MalformedURLException, URISyntaxException {
        return HttpClient.builder().configuration(this.options).runContext(runContext).build();
    }

    protected HttpRequest request(RunContext runContext) throws IllegalVariableEvaluationException, URISyntaxException, IOException {
        String renderedUri = runContext.render(this.uri).as(String.class).map(s -> s.replace(" ", "%20")).orElseThrow();
        HttpRequest.HttpRequestBuilder request = HttpRequest.builder().method(runContext.render(this.method).as(String.class).orElse(null)).uri(new URI(renderedUri));
        Map<String, Object> renderedFormData = runContext.render(this.formData).asMap(String.class, Object.class);
        if (!renderedFormData.isEmpty()) {
            if ("multipart/form-data".equals(runContext.render(this.contentType).as(String.class).orElse(null))) {
                HashMap<String, Object> multipart = new HashMap<String, Object>();
                for (Map.Entry<String, Object> e2 : renderedFormData.entrySet()) {
                    Map mapValue;
                    Object render;
                    String key = runContext.render(e2.getKey());
                    Object object = e2.getValue();
                    if (object instanceof String) {
                        String stringValue = (String)object;
                        render = runContext.render(stringValue);
                        if (((String)render).startsWith("kestra://")) {
                            File tempFile = runContext.workingDir().createTempFile().toFile();
                            try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                                IOUtils.copyLarge((InputStream)runContext.storage().getFile(new URI((String)render)), (OutputStream)outputStream);
                            }
                            multipart.put(key, tempFile);
                            continue;
                        }
                        multipart.put(key, render);
                        continue;
                    }
                    render = e2.getValue();
                    if (render instanceof Map && (mapValue = (Map)render).containsKey("name") && mapValue.containsKey("content")) {
                        String name = runContext.render((String)mapValue.get("name"));
                        String content = runContext.render((String)mapValue.get("content"));
                        File tempFile = runContext.workingDir().createTempFile().toFile();
                        File renamedFile = new File(Files.move(tempFile.toPath(), tempFile.toPath().resolveSibling(name), new CopyOption[0]).toUri());
                        try (FileOutputStream outputStream = new FileOutputStream(renamedFile);){
                            IOUtils.copyLarge((InputStream)runContext.storage().getFile(new URI(content)), (OutputStream)outputStream);
                        }
                        multipart.put(key, renamedFile);
                        continue;
                    }
                    multipart.put(key, JacksonMapper.ofJson().writeValueAsString(e2.getValue()));
                }
                request.body(((HttpRequest.MultipartRequestBody.MultipartRequestBodyBuilder)HttpRequest.MultipartRequestBody.builder().content(multipart)).build());
            } else {
                request.body(((HttpRequest.UrlEncodedRequestBody.UrlEncodedRequestBodyBuilder)HttpRequest.UrlEncodedRequestBody.builder().content(renderedFormData)).build());
            }
        } else if (this.body != null) {
            request.body(((HttpRequest.StringRequestBody.StringRequestBodyBuilder)((HttpRequest.StringRequestBody.StringRequestBodyBuilder)((HttpRequest.StringRequestBody.StringRequestBodyBuilder)HttpRequest.StringRequestBody.builder().content(runContext.render(this.body).as(String.class).orElseThrow())).contentType(runContext.render(this.contentType).as(String.class).orElse(null))).charset(this.options != null && this.options.getDefaultCharset() != null ? (Charset)runContext.render(this.options.getDefaultCharset()).as(Charset.class).orElse(null) : null)).build());
        } else if (this.contentType != null) {
            request.addHeader("Content-Type", runContext.render(this.contentType).as(String.class).orElse(null));
        }
        Map<CharSequence, CharSequence> renderedHeader = runContext.render(this.headers).asMap(CharSequence.class, CharSequence.class);
        if (!renderedHeader.isEmpty()) {
            request.headers(HttpHeaders.of(renderedHeader.entrySet().stream().map(Rethrow.throwFunction(e -> new AbstractMap.SimpleEntry<String, String>(((CharSequence)e.getKey()).toString(), runContext.render(((CharSequence)e.getValue()).toString())))).collect(Collectors.groupingBy(AbstractMap.SimpleEntry::getKey, Collectors.mapping(AbstractMap.SimpleEntry::getValue, Collectors.toList()))), (a, b) -> true));
        }
        return request.build();
    }

    @Generated
    private static Property<String> $default$method() {
        return Property.ofValue("GET");
    }

    @Generated
    private static Property<String> $default$contentType() {
        return Property.ofValue("application/json");
    }

    @Generated
    private static HttpConfiguration $default$options() {
        return HttpConfiguration.builder().build();
    }

    @Generated
    protected AbstractHttp(AbstractHttpBuilder<?, ?> b) {
        super(b);
        this.uri = b.uri;
        this.method = b.method$set ? b.method$value : AbstractHttp.$default$method();
        this.body = b.body;
        this.formData = b.formData;
        this.contentType = b.contentType$set ? b.contentType$value : AbstractHttp.$default$contentType();
        this.headers = b.headers;
        this.options = b.options$set ? b.options$value : AbstractHttp.$default$options();
        this.allowFailed = b.allowFailed;
        this.sslOptions = b.sslOptions;
    }

    @Generated
    public String toString() {
        return "AbstractHttp(super=" + super.toString() + ", uri=" + String.valueOf(this.getUri()) + ", method=" + String.valueOf(this.getMethod()) + ", body=" + String.valueOf(this.getBody()) + ", formData=" + String.valueOf(this.getFormData()) + ", contentType=" + String.valueOf(this.getContentType()) + ", headers=" + String.valueOf(this.getHeaders()) + ", options=" + String.valueOf(this.getOptions()) + ", allowFailed=" + String.valueOf(this.getAllowFailed()) + ", sslOptions=" + String.valueOf(this.getSslOptions()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractHttp)) {
            return false;
        }
        AbstractHttp other = (AbstractHttp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$uri = this.getUri();
        Property<String> other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        Property<String> this$method = this.getMethod();
        Property<String> other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        Property<String> this$body = this.getBody();
        Property<String> other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        Property<Map<String, Object>> this$formData = this.getFormData();
        Property<Map<String, Object>> other$formData = other.getFormData();
        if (this$formData == null ? other$formData != null : !((Object)this$formData).equals(other$formData)) {
            return false;
        }
        Property<String> this$contentType = this.getContentType();
        Property<String> other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !((Object)this$contentType).equals(other$contentType)) {
            return false;
        }
        Property<Map<CharSequence, CharSequence>> this$headers = this.getHeaders();
        Property<Map<CharSequence, CharSequence>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        HttpConfiguration this$options = this.getOptions();
        HttpConfiguration other$options = other.getOptions();
        if (this$options == null ? other$options != null : !this$options.equals(other$options)) {
            return false;
        }
        Property<Boolean> this$allowFailed = this.getAllowFailed();
        Property<Boolean> other$allowFailed = other.getAllowFailed();
        if (this$allowFailed == null ? other$allowFailed != null : !((Object)this$allowFailed).equals(other$allowFailed)) {
            return false;
        }
        SslOptions this$sslOptions = this.getSslOptions();
        SslOptions other$sslOptions = other.getSslOptions();
        return !(this$sslOptions == null ? other$sslOptions != null : !this$sslOptions.equals(other$sslOptions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractHttp;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        Property<String> $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        Property<String> $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        Property<Map<String, Object>> $formData = this.getFormData();
        result = result * 59 + ($formData == null ? 43 : ((Object)$formData).hashCode());
        Property<String> $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)$contentType).hashCode());
        Property<Map<CharSequence, CharSequence>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        HttpConfiguration $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        Property<Boolean> $allowFailed = this.getAllowFailed();
        result = result * 59 + ($allowFailed == null ? 43 : ((Object)$allowFailed).hashCode());
        SslOptions $sslOptions = this.getSslOptions();
        result = result * 59 + ($sslOptions == null ? 43 : $sslOptions.hashCode());
        return result;
    }

    @Override
    @Generated
    public Property<String> getUri() {
        return this.uri;
    }

    @Override
    @Generated
    public Property<String> getMethod() {
        return this.method;
    }

    @Override
    @Generated
    public Property<String> getBody() {
        return this.body;
    }

    @Override
    @Generated
    public Property<Map<String, Object>> getFormData() {
        return this.formData;
    }

    @Override
    @Generated
    public Property<String> getContentType() {
        return this.contentType;
    }

    @Override
    @Generated
    public Property<Map<CharSequence, CharSequence>> getHeaders() {
        return this.headers;
    }

    @Override
    @Generated
    public HttpConfiguration getOptions() {
        return this.options;
    }

    @Deprecated
    @Generated
    public Property<Boolean> getAllowFailed() {
        return this.allowFailed;
    }

    @Override
    @Deprecated
    @Generated
    public SslOptions getSslOptions() {
        return this.sslOptions;
    }

    @Generated
    public AbstractHttp() {
        this.method = AbstractHttp.$default$method();
        this.contentType = AbstractHttp.$default$contentType();
        this.options = AbstractHttp.$default$options();
    }

    @Generated
    public static abstract class AbstractHttpBuilder<C extends AbstractHttp, B extends AbstractHttpBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> uri;
        @Generated
        private boolean method$set;
        @Generated
        private Property<String> method$value;
        @Generated
        private Property<String> body;
        @Generated
        private Property<Map<String, Object>> formData;
        @Generated
        private boolean contentType$set;
        @Generated
        private Property<String> contentType$value;
        @Generated
        private Property<Map<CharSequence, CharSequence>> headers;
        @Generated
        private boolean options$set;
        @Generated
        private HttpConfiguration options$value;
        @Generated
        private Property<Boolean> allowFailed;
        @Generated
        private SslOptions sslOptions;

        @Generated
        public B uri(Property<String> uri) {
            this.uri = uri;
            return (B)this.self();
        }

        @Generated
        public B method(Property<String> method) {
            this.method$value = method;
            this.method$set = true;
            return (B)this.self();
        }

        @Generated
        public B body(Property<String> body) {
            this.body = body;
            return (B)this.self();
        }

        @Generated
        public B formData(Property<Map<String, Object>> formData) {
            this.formData = formData;
            return (B)this.self();
        }

        @Generated
        public B contentType(Property<String> contentType) {
            this.contentType$value = contentType;
            this.contentType$set = true;
            return (B)this.self();
        }

        @Generated
        public B headers(Property<Map<CharSequence, CharSequence>> headers) {
            this.headers = headers;
            return (B)this.self();
        }

        @Generated
        public B options(HttpConfiguration options) {
            this.options$value = options;
            this.options$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B allowFailed(Property<Boolean> allowFailed) {
            this.allowFailed = allowFailed;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B sslOptions(SslOptions sslOptions) {
            this.sslOptions = sslOptions;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AbstractHttp.AbstractHttpBuilder(super=" + super.toString() + ", uri=" + String.valueOf(this.uri) + ", method$value=" + String.valueOf(this.method$value) + ", body=" + String.valueOf(this.body) + ", formData=" + String.valueOf(this.formData) + ", contentType$value=" + String.valueOf(this.contentType$value) + ", headers=" + String.valueOf(this.headers) + ", options$value=" + String.valueOf(this.options$value) + ", allowFailed=" + String.valueOf(this.allowFailed) + ", sslOptions=" + String.valueOf(this.sslOptions) + ")";
        }
    }
}

