/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.kv;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.FlowService;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.NoSuchElementException;
import lombok.Generated;

@Schema(title="Delete a KV pair.")
@Plugin(examples={@Example(title="Delete a KV pair.", full=true, code={"id: kv_store_delete\nnamespace: company.team\n\ntasks:\n  - id: kv_delete\n    type: io.kestra.plugin.core.kv.Delete\n    key: my_variable\n    namespace: dev # the current namespace of the flow will be used by default\n"})})
public class Delete
extends Task
implements RunnableTask<Output> {
    @NotNull
    @Schema(title="The key specifying the value to delete")
    private Property<String> key;
    @NotNull
    @Schema(title="The namespace to set the value in")
    private Property<String> namespace;
    @NotNull
    @Schema(title="Flag specifying whether to fail if there is no value for the given key")
    private Property<Boolean> errorOnMissing;

    @Override
    public Output run(RunContext runContext) throws Exception {
        String renderedNamespace = runContext.render(this.namespace).as(String.class).orElseThrow();
        FlowService flowService = (FlowService)((DefaultRunContext)runContext).getApplicationContext().getBean(FlowService.class);
        flowService.checkAllowedNamespace(runContext.flowInfo().tenantId(), renderedNamespace, runContext.flowInfo().tenantId(), runContext.flowInfo().namespace());
        String renderedKey = runContext.render(this.key).as(String.class).orElseThrow();
        boolean deleted = runContext.namespaceKv(renderedNamespace).delete(renderedKey);
        if (Boolean.TRUE.equals(runContext.render(this.errorOnMissing).as(Boolean.class).orElseThrow()) && !deleted) {
            throw new NoSuchElementException("No value found for key '" + renderedKey + "' in namespace '" + renderedNamespace + "' and `errorOnMissing` is set to true");
        }
        return Output.builder().deleted(deleted).build();
    }

    @Generated
    private static Property<String> $default$namespace() {
        return Property.ofExpression("{{ flow.namespace }}");
    }

    @Generated
    private static Property<Boolean> $default$errorOnMissing() {
        return Property.ofValue(false);
    }

    @Generated
    protected Delete(DeleteBuilder<?, ?> b) {
        super(b);
        this.key = b.key;
        this.namespace = b.namespace$set ? b.namespace$value : Delete.$default$namespace();
        this.errorOnMissing = b.errorOnMissing$set ? b.errorOnMissing$value : Delete.$default$errorOnMissing();
    }

    @Generated
    public static DeleteBuilder<?, ?> builder() {
        return new DeleteBuilderImpl();
    }

    @Generated
    public DeleteBuilder<?, ?> toBuilder() {
        return new DeleteBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Property<String> getKey() {
        return this.key;
    }

    @Generated
    public Property<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Property<Boolean> getErrorOnMissing() {
        return this.errorOnMissing;
    }

    @Generated
    public Delete() {
        this.namespace = Delete.$default$namespace();
        this.errorOnMissing = Delete.$default$errorOnMissing();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="Flag specifying whether the deletion was successful and had a value")
        private final boolean deleted;

        @ConstructorProperties(value={"deleted"})
        @Generated
        Output(boolean deleted) {
            this.deleted = deleted;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public boolean isDeleted() {
            return this.deleted;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private boolean deleted;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder deleted(boolean deleted) {
                this.deleted = deleted;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.deleted);
            }

            @Generated
            public String toString() {
                return "Delete.Output.OutputBuilder(deleted=" + this.deleted + ")";
            }
        }
    }

    @Generated
    public static abstract class DeleteBuilder<C extends Delete, B extends DeleteBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> key;
        @Generated
        private boolean namespace$set;
        @Generated
        private Property<String> namespace$value;
        @Generated
        private boolean errorOnMissing$set;
        @Generated
        private Property<Boolean> errorOnMissing$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DeleteBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Delete instance, DeleteBuilder<?, ?> b) {
            b.key(instance.key);
            b.namespace(instance.namespace);
            b.errorOnMissing(instance.errorOnMissing);
        }

        @Generated
        public B key(Property<String> key) {
            this.key = key;
            return (B)this.self();
        }

        @Generated
        public B namespace(Property<String> namespace) {
            this.namespace$value = namespace;
            this.namespace$set = true;
            return (B)this.self();
        }

        @Generated
        public B errorOnMissing(Property<Boolean> errorOnMissing) {
            this.errorOnMissing$value = errorOnMissing;
            this.errorOnMissing$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Delete.DeleteBuilder(super=" + super.toString() + ", key=" + String.valueOf(this.key) + ", namespace$value=" + String.valueOf(this.namespace$value) + ", errorOnMissing$value=" + String.valueOf(this.errorOnMissing$value) + ")";
        }
    }

    @Generated
    private static final class DeleteBuilderImpl
    extends DeleteBuilder<Delete, DeleteBuilderImpl> {
        @Generated
        private DeleteBuilderImpl() {
        }

        @Override
        @Generated
        protected DeleteBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Delete build() {
            return new Delete(this);
        }
    }
}

