/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.kv;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.FlowService;
import io.kestra.core.storages.kv.KVEntry;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(title="Fetch all keys matching a given KV pair prefix.")
@Plugin(examples={@Example(title="Get keys that are prefixed by `my_var`.", full=true, code={"id: kv_store_getkeys\nnamespace: company.team\n\ntasks:\n  - id: kv_getkeys\n    type: io.kestra.plugin.core.kv.GetKeys\n    prefix: my_var\n    namespace: dev # the current namespace of the flow will be used by default\n"})})
public class GetKeys
extends Task
implements RunnableTask<Output> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetKeys.class);
    @Schema(title="The key for which to get the values")
    private Property<String> prefix;
    @NotNull
    @Schema(title="The namespace from which to get the KV pairs")
    private Property<String> namespace;

    @Override
    public Output run(RunContext runContext) throws Exception {
        String renderedNamespace = runContext.render(this.namespace).as(String.class).orElse(null);
        FlowService flowService = (FlowService)((DefaultRunContext)runContext).getApplicationContext().getBean(FlowService.class);
        flowService.checkAllowedNamespace(runContext.flowInfo().tenantId(), renderedNamespace, runContext.flowInfo().tenantId(), runContext.flowInfo().namespace());
        String renderedPrefix = runContext.render(this.prefix).as(String.class).orElse(null);
        Predicate<String> filter = renderedPrefix == null ? key -> true : key -> key.startsWith(renderedPrefix);
        List<String> keys = runContext.namespaceKv(renderedNamespace).list().stream().map(KVEntry::key).filter(filter).toList();
        return Output.builder().keys(keys).build();
    }

    @Generated
    private static Property<String> $default$namespace() {
        return Property.ofExpression("{{ flow.namespace }}");
    }

    @Generated
    protected GetKeys(GetKeysBuilder<?, ?> b) {
        super(b);
        this.prefix = b.prefix;
        this.namespace = b.namespace$set ? b.namespace$value : GetKeys.$default$namespace();
    }

    @Generated
    public static GetKeysBuilder<?, ?> builder() {
        return new GetKeysBuilderImpl();
    }

    @Generated
    public GetKeysBuilder<?, ?> toBuilder() {
        return new GetKeysBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Property<String> getPrefix() {
        return this.prefix;
    }

    @Generated
    public Property<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public GetKeys() {
        this.namespace = GetKeys.$default$namespace();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="Found keys for given prefix")
        private final List<String> keys;

        @ConstructorProperties(value={"keys"})
        @Generated
        Output(List<String> keys) {
            this.keys = keys;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public List<String> getKeys() {
            return this.keys;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private List<String> keys;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder keys(List<String> keys) {
                this.keys = keys;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.keys);
            }

            @Generated
            public String toString() {
                return "GetKeys.Output.OutputBuilder(keys=" + String.valueOf(this.keys) + ")";
            }
        }
    }

    @Generated
    public static abstract class GetKeysBuilder<C extends GetKeys, B extends GetKeysBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> prefix;
        @Generated
        private boolean namespace$set;
        @Generated
        private Property<String> namespace$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GetKeysBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(GetKeys instance, GetKeysBuilder<?, ?> b) {
            b.prefix(instance.prefix);
            b.namespace(instance.namespace);
        }

        @Generated
        public B prefix(Property<String> prefix) {
            this.prefix = prefix;
            return (B)this.self();
        }

        @Generated
        public B namespace(Property<String> namespace) {
            this.namespace$value = namespace;
            this.namespace$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "GetKeys.GetKeysBuilder(super=" + super.toString() + ", prefix=" + String.valueOf(this.prefix) + ", namespace$value=" + String.valueOf(this.namespace$value) + ")";
        }
    }

    @Generated
    private static final class GetKeysBuilderImpl
    extends GetKeysBuilder<GetKeys, GetKeysBuilderImpl> {
        @Generated
        private GetKeysBuilderImpl() {
        }

        @Override
        @Generated
        protected GetKeysBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GetKeys build() {
            return new GetKeys(this);
        }
    }
}

