/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.runner;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.runners.AbstractLogConsumer;
import io.kestra.core.models.tasks.runners.TaskCommands;
import io.kestra.core.models.tasks.runners.TaskException;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.models.tasks.runners.TaskRunnerDetailResult;
import io.kestra.core.models.tasks.runners.TaskRunnerResult;
import io.kestra.core.runners.RunContext;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;

@Introspected
@Schema(title="Task runner that executes a task as a subprocess on the Kestra host.", description="To access the task's working directory, use the `{{workingDir}}` Pebble expression or the `WORKING_DIR` environment variable. Input files and namespace files will be available in this directory.\n\nTo generate output files you can either use the `outputFiles` task's property and create a file with the same name in the task's working directory, or create any file in the output directory which can be accessed by the `{{outputDir}}` Pebble expression or the `OUTPUT_DIR` environment variables.\n\nNote that:\n\n- This task runner is independent of any Operating System. You can use it equally on Linux, Mac, or Windows without any additional configuration.\n- When the Kestra Worker running this task is shut down, the process will be interrupted and re-created as soon as the worker is restarted.")
@Plugin(examples={@Example(title="Execute a Shell command.", code={"id: new_shell\nnamespace: company.team\n\ntasks:\n  - id: shell\n    type: io.kestra.plugin.scripts.shell.Commands\n    taskRunner:\n      type: io.kestra.plugin.core.runner.Process\n    commands:\n      - echo \"Hello World\""}, full=true), @Example(title="Install custom Python packages before executing a Python script. Note how we use the `--break-system-packages` flag to avoid conflicts with the system packages. Make sure to use this flag if you see errors similar to `error: externally-managed-environment`.", code={"id: before_commands_example\nnamespace: company.team\n\ninputs:\n  - id: url\n    type: URI\n    defaults: https://jsonplaceholder.typicode.com/todos/1\n\ntasks:\n  - id: transform\n    type: io.kestra.plugin.scripts.python.Script\n    taskRunner:\n      type: io.kestra.plugin.core.runner.Process\n    beforeCommands:\n      - pip install kestra requests --break-system-packages\n    script: |\n      import requests\n      from kestra import Kestra\n\n      url = \"{{ inputs.url }}\"\n\n      response = requests.get(url)\n      print('Status Code:', response.status_code)\n      Kestra.outputs(response.json())\n"}, full=true), @Example(title="Pass input files to the task, execute a Shell command, then retrieve output files.", code={"id: new_shell_with_file\nnamespace: company.team\n\ninputs:\n  - id: file\n    type: FILE\n\ntasks:\n  - id: shell\n    type: io.kestra.plugin.scripts.shell.Commands\n    inputFiles:\n      data.txt: \"{{inputs.file}}\"\n    outputFiles:\n      - out.txt\n    taskRunner:\n      type: io.kestra.plugin.core.runner.Process\n    commands:\n      - cp {{workingDir}}/data.txt {{workingDir}}/out.txt"}, full=true)})
public class Process
extends TaskRunner<TaskRunnerDetailResult> {
    public static Process instance() {
        return ((ProcessBuilder)Process.builder().type(Process.class.getName())).build();
    }

    @Override
    public TaskRunnerResult<TaskRunnerDetailResult> run(RunContext runContext, TaskCommands taskCommands, List<String> filesToDownload) throws Exception {
        Logger logger = runContext.logger();
        AbstractLogConsumer defaultLogConsumer = taskCommands.getLogConsumer();
        java.lang.ProcessBuilder processBuilder = new java.lang.ProcessBuilder(new String[0]);
        Map<String, String> environment = processBuilder.environment();
        environment.putAll(this.env(runContext, taskCommands));
        processBuilder.directory(taskCommands.getWorkingDirectory().toFile());
        List<String> renderedCommands = runContext.render(taskCommands.getCommands()).asList(String.class);
        processBuilder.command(renderedCommands);
        java.lang.Process process = processBuilder.start();
        long pid = process.pid();
        logger.debug("Starting command with pid {} [{}]", (Object)pid, (Object)String.join((CharSequence)" ", renderedCommands));
        LogRunnable stdOutRunnable = new LogRunnable(process.getInputStream(), defaultLogConsumer, false);
        LogRunnable stdErrRunnable = new LogRunnable(process.getErrorStream(), defaultLogConsumer, true);
        Thread stdOut = Thread.startVirtualThread(stdOutRunnable);
        Thread stdErr = Thread.startVirtualThread(stdErrRunnable);
        try {
            int exitCode = process.waitFor();
            stdOut.join();
            stdErr.join();
            if (exitCode != 0) {
                throw new TaskException(exitCode, defaultLogConsumer);
            }
            logger.debug("Command succeed with exit code {}", (Object)exitCode);
            TaskRunnerResult<TaskRunnerDetailResult> taskRunnerResult = new TaskRunnerResult<TaskRunnerDetailResult>(exitCode, defaultLogConsumer);
            return taskRunnerResult;
        }
        catch (InterruptedException e) {
            logger.warn("Killing process {} for InterruptedException", (Object)pid);
            this.killDescendantsOf(process.toHandle(), logger);
            process.destroy();
            throw e;
        }
        finally {
            stdOut.join();
            stdErr.join();
        }
    }

    @Override
    protected Map<String, Object> runnerAdditionalVars(RunContext runContext, TaskCommands taskCommands) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("workingDir", taskCommands.getWorkingDirectory());
        if (taskCommands.outputDirectoryEnabled()) {
            vars.put("outputDir", taskCommands.getOutputDirectory());
        }
        return vars;
    }

    private void killDescendantsOf(ProcessHandle process, Logger logger) {
        process.descendants().forEach(processHandle -> {
            if (!processHandle.destroy()) {
                logger.warn("Descendant process {} of {} couldn't be killed", (Object)processHandle.pid(), (Object)process.pid());
            }
        });
    }

    @Generated
    protected Process(ProcessBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static ProcessBuilder<?, ?> builder() {
        return new ProcessBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Process(super=" + super.toString() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Process)) {
            return false;
        }
        Process other = (Process)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Process;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Process() {
    }

    @Generated
    public static abstract class ProcessBuilder<C extends Process, B extends ProcessBuilder<C, B>>
    extends TaskRunner.TaskRunnerBuilder<TaskRunnerDetailResult, C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Process.ProcessBuilder(super=" + super.toString() + ")";
        }
    }

    public static class LogRunnable
    implements Runnable {
        private final InputStream inputStream;
        private final AbstractLogConsumer logConsumerInterface;
        private final boolean isStdErr;

        protected LogRunnable(InputStream inputStream, AbstractLogConsumer logConsumerInterface, boolean isStdErr) {
            this.inputStream = inputStream;
            this.logConsumerInterface = logConsumerInterface;
            this.isStdErr = isStdErr;
        }

        @Override
        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream, StandardCharsets.UTF_8);
                try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        this.logConsumerInterface.accept(line, this.isStdErr);
                    }
                }
            }
            catch (Exception e) {
                try {
                    this.logConsumerInterface.accept(e.getMessage(), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Generated
    private static final class ProcessBuilderImpl
    extends ProcessBuilder<Process, ProcessBuilderImpl> {
        @Generated
        private ProcessBuilderImpl() {
        }

        @Override
        @Generated
        protected ProcessBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Process build() {
            return new Process(this);
        }
    }
}

