/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.trigger;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.RecoverMissedSchedules;
import io.kestra.core.models.triggers.Schedulable;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.TriggerOutput;
import io.kestra.core.models.triggers.TriggerService;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.LabelService;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.validations.TimezoneId;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(title="Schedule a flow on specific dates.")
@Plugin
public class ScheduleOnDates
extends AbstractTrigger
implements Schedulable,
TriggerOutput<VoidOutput> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduleOnDates.class);
    private static final String PLUGIN_PROPERTY_RECOVER_MISSED_SCHEDULES = "recoverMissedSchedules";
    @Schema(hidden=true)
    @Null
    private final Duration interval;
    @Schema(title="The inputs to pass to the scheduled flow")
    @PluginProperty(dynamic=true)
    private Map<String, Object> inputs;
    @TimezoneId
    @Schema(title="The [time zone identifier](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) (i.e. the second column in [the Wikipedia table](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones#List)) to use for evaluating the cron expression. Default value is the server default zone ID.")
    @PluginProperty(dynamic=true)
    private String timezone;
    @NotNull
    private Property<List<ZonedDateTime>> dates;
    @Schema(title="Action to take in the case of missed schedules", description="`ALL` will recover all missed schedules, `LAST`  will only recovered the last missing one, `NONE` will not recover any missing schedule.\nThe default is `ALL` unless a different value is configured using the global plugin configuration.")
    @PluginProperty
    private RecoverMissedSchedules recoverMissedSchedules;

    @Override
    public Optional<Execution> evaluate(ConditionContext conditionContext, TriggerContext triggerContext) throws Exception {
        ZonedDateTime lastEvaluation;
        RunContext runContext = conditionContext.getRunContext();
        Optional<ZonedDateTime> nextDate = this.nextDate(runContext, arg_0 -> ScheduleOnDates.lambda$evaluate$0(lastEvaluation = triggerContext.getDate(), arg_0));
        if (nextDate.isPresent()) {
            log.info("Schedule execution on {}", (Object)nextDate.get());
            Execution execution = TriggerService.generateScheduledExecution(this, conditionContext, triggerContext, LabelService.fromTrigger(runContext, conditionContext.getFlow(), this), this.inputs != null ? runContext.render(this.inputs) : Collections.emptyMap(), Collections.emptyMap(), nextDate);
            return Optional.of(execution);
        }
        return Optional.empty();
    }

    @Override
    public ZonedDateTime nextEvaluationDate(ConditionContext conditionContext, Optional<? extends TriggerContext> last) throws Exception {
        return last.map(Rethrow.throwFunction(context -> this.nextDate(conditionContext.getRunContext(), date -> date.isAfter(context.getDate())).orElse(ZonedDateTime.now().plusYears(1L)))).orElse(conditionContext.getRunContext().render(this.dates).asList(ZonedDateTime.class).stream().sorted().findFirst().orElse(ZonedDateTime.now())).truncatedTo(ChronoUnit.SECONDS);
    }

    @Override
    public ZonedDateTime nextEvaluationDate() {
        return ZonedDateTime.now();
    }

    @Override
    public ZonedDateTime previousEvaluationDate(ConditionContext conditionContext) throws IllegalVariableEvaluationException {
        ZonedDateTime now = ZonedDateTime.now();
        SequencedCollection previousDates = conditionContext.getRunContext().render(this.dates).asList(ZonedDateTime.class).stream().sorted().takeWhile(date -> date.isBefore(now)).toList().reversed();
        return previousDates.isEmpty() ? ZonedDateTime.now() : (ZonedDateTime)previousDates.getFirst();
    }

    private Optional<ZonedDateTime> nextDate(RunContext runContext, Predicate<ZonedDateTime> filter) throws IllegalVariableEvaluationException {
        return runContext.render(this.dates).asList(ZonedDateTime.class).stream().sorted().filter(date -> filter.test((ZonedDateTime)date)).map(Rethrow.throwFunction(date -> this.timezone == null ? date : date.withZoneSameInstant(ZoneId.of(runContext.render(this.timezone))))).findFirst().map(date -> date.truncatedTo(ChronoUnit.SECONDS));
    }

    @Generated
    private static Duration $default$interval() {
        return null;
    }

    @Generated
    private static String $default$timezone() {
        return ZoneId.systemDefault().toString();
    }

    @Generated
    protected ScheduleOnDates(ScheduleOnDatesBuilder<?, ?> b) {
        super(b);
        this.interval = b.interval$set ? b.interval$value : ScheduleOnDates.$default$interval();
        this.inputs = b.inputs;
        this.timezone = b.timezone$set ? b.timezone$value : ScheduleOnDates.$default$timezone();
        this.dates = b.dates;
        this.recoverMissedSchedules = b.recoverMissedSchedules;
    }

    @Generated
    public static ScheduleOnDatesBuilder<?, ?> builder() {
        return new ScheduleOnDatesBuilderImpl();
    }

    @Generated
    public String toString() {
        return "ScheduleOnDates(super=" + super.toString() + ", interval=" + String.valueOf(this.getInterval()) + ", inputs=" + String.valueOf(this.getInputs()) + ", timezone=" + this.getTimezone() + ", dates=" + String.valueOf(this.getDates()) + ", recoverMissedSchedules=" + String.valueOf((Object)this.getRecoverMissedSchedules()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduleOnDates)) {
            return false;
        }
        ScheduleOnDates other = (ScheduleOnDates)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Duration this$interval = this.getInterval();
        Duration other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
            return false;
        }
        Map<String, Object> this$inputs = this.getInputs();
        Map<String, Object> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        Property<List<ZonedDateTime>> this$dates = this.getDates();
        Property<List<ZonedDateTime>> other$dates = other.getDates();
        if (this$dates == null ? other$dates != null : !((Object)this$dates).equals(other$dates)) {
            return false;
        }
        RecoverMissedSchedules this$recoverMissedSchedules = this.getRecoverMissedSchedules();
        RecoverMissedSchedules other$recoverMissedSchedules = other.getRecoverMissedSchedules();
        return !(this$recoverMissedSchedules == null ? other$recoverMissedSchedules != null : !((Object)((Object)this$recoverMissedSchedules)).equals((Object)other$recoverMissedSchedules));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScheduleOnDates;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Duration $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
        Map<String, Object> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        Property<List<ZonedDateTime>> $dates = this.getDates();
        result = result * 59 + ($dates == null ? 43 : ((Object)$dates).hashCode());
        RecoverMissedSchedules $recoverMissedSchedules = this.getRecoverMissedSchedules();
        result = result * 59 + ($recoverMissedSchedules == null ? 43 : ((Object)((Object)$recoverMissedSchedules)).hashCode());
        return result;
    }

    @Override
    @Generated
    public Duration getInterval() {
        return this.interval;
    }

    @Generated
    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    @Generated
    public String getTimezone() {
        return this.timezone;
    }

    @Generated
    public Property<List<ZonedDateTime>> getDates() {
        return this.dates;
    }

    @Override
    @Generated
    public RecoverMissedSchedules getRecoverMissedSchedules() {
        return this.recoverMissedSchedules;
    }

    @Generated
    public ScheduleOnDates() {
        this.interval = ScheduleOnDates.$default$interval();
        this.timezone = ScheduleOnDates.$default$timezone();
    }

    private static /* synthetic */ boolean lambda$evaluate$0(ZonedDateTime lastEvaluation, ZonedDateTime date) {
        return date.isEqual(lastEvaluation) || date.isAfter(lastEvaluation);
    }

    @Generated
    public static abstract class ScheduleOnDatesBuilder<C extends ScheduleOnDates, B extends ScheduleOnDatesBuilder<C, B>>
    extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
        @Generated
        private boolean interval$set;
        @Generated
        private Duration interval$value;
        @Generated
        private Map<String, Object> inputs;
        @Generated
        private boolean timezone$set;
        @Generated
        private String timezone$value;
        @Generated
        private Property<List<ZonedDateTime>> dates;
        @Generated
        private RecoverMissedSchedules recoverMissedSchedules;

        @Generated
        public B interval(Duration interval) {
            this.interval$value = interval;
            this.interval$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputs(Map<String, Object> inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Generated
        public B timezone(String timezone) {
            this.timezone$value = timezone;
            this.timezone$set = true;
            return (B)this.self();
        }

        @Generated
        public B dates(Property<List<ZonedDateTime>> dates) {
            this.dates = dates;
            return (B)this.self();
        }

        @Generated
        public B recoverMissedSchedules(RecoverMissedSchedules recoverMissedSchedules) {
            this.recoverMissedSchedules = recoverMissedSchedules;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ScheduleOnDates.ScheduleOnDatesBuilder(super=" + super.toString() + ", interval$value=" + String.valueOf(this.interval$value) + ", inputs=" + String.valueOf(this.inputs) + ", timezone$value=" + this.timezone$value + ", dates=" + String.valueOf(this.dates) + ", recoverMissedSchedules=" + String.valueOf((Object)this.recoverMissedSchedules) + ")";
        }
    }

    @Generated
    private static final class ScheduleOnDatesBuilderImpl
    extends ScheduleOnDatesBuilder<ScheduleOnDates, ScheduleOnDatesBuilderImpl> {
        @Generated
        private ScheduleOnDatesBuilderImpl() {
        }

        @Override
        @Generated
        protected ScheduleOnDatesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ScheduleOnDates build() {
            return new ScheduleOnDates(this);
        }
    }
}

