/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import io.kestra.core.docs.JsonSchemaGenerator;
import io.kestra.core.docs.SchemaType;
import io.kestra.core.models.dashboards.Dashboard;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.PluginDefault;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.templates.Template;
import io.kestra.core.models.triggers.AbstractTrigger;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Singleton
public class JsonSchemaCache {
    private final JsonSchemaGenerator jsonSchemaGenerator;
    private final ConcurrentMap<CacheKey, Map<String, Object>> schemaCache = new ConcurrentHashMap<CacheKey, Map<String, Object>>();
    private final ConcurrentMap<SchemaType, Map<String, Object>> propertiesCache = new ConcurrentHashMap<SchemaType, Map<String, Object>>();
    private final Map<SchemaType, Class<?>> classesBySchemaType = new HashMap();

    public JsonSchemaCache(JsonSchemaGenerator jsonSchemaGenerator) {
        this.jsonSchemaGenerator = Objects.requireNonNull(jsonSchemaGenerator, "JsonSchemaGenerator cannot be null");
        this.registerClassForType(SchemaType.FLOW, Flow.class);
        this.registerClassForType(SchemaType.TEMPLATE, Template.class);
        this.registerClassForType(SchemaType.TASK, Task.class);
        this.registerClassForType(SchemaType.TRIGGER, AbstractTrigger.class);
        this.registerClassForType(SchemaType.PLUGINDEFAULT, PluginDefault.class);
        this.registerClassForType(SchemaType.DASHBOARD, Dashboard.class);
    }

    public Map<String, Object> getSchemaForType(SchemaType type, boolean arrayOf) {
        return this.schemaCache.computeIfAbsent(new CacheKey(type, arrayOf), key -> {
            Class<?> cls = Optional.ofNullable(this.classesBySchemaType.get((Object)type)).orElseThrow(() -> new IllegalArgumentException("Cannot found schema for type '" + String.valueOf((Object)type) + "'"));
            return this.jsonSchemaGenerator.schemas(cls, arrayOf);
        });
    }

    public Map<String, Object> getPropertiesForType(SchemaType type) {
        return this.propertiesCache.computeIfAbsent(type, key -> {
            Class<?> cls = Optional.ofNullable(this.classesBySchemaType.get((Object)type)).orElseThrow(() -> new IllegalArgumentException("Cannot found properties for type '" + String.valueOf((Object)type) + "'"));
            return this.jsonSchemaGenerator.properties(null, cls);
        });
    }

    public void registerClassForType(SchemaType type, Class<?> clazz) {
        this.classesBySchemaType.put(type, clazz);
    }

    public void clear() {
        this.schemaCache.clear();
    }

    private record CacheKey(SchemaType type, boolean arrayOf) {
    }
}

