/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.HierarchicType;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.DefinitionKey;
import com.github.victools.jsonschema.generator.naming.DefaultSchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.generator.naming.SchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.jakarta.validation.JakartaValidationModule;
import com.github.victools.jsonschema.module.jakarta.validation.JakartaValidationOption;
import com.github.victools.jsonschema.module.swagger2.Swagger2Module;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.docs.AbstractClassDocumentation;
import io.kestra.core.models.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.models.dashboards.charts.Chart;
import io.kestra.core.models.dashboards.charts.DataChart;
import io.kestra.core.models.dashboards.charts.DataChartKPI;
import io.kestra.core.models.property.Data;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.common.EncryptedString;
import io.kestra.core.models.tasks.logs.LogExporter;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.plugins.AdditionalPlugin;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.plugins.RegisteredPlugin;
import io.kestra.core.serializers.JacksonMapper;
import io.micronaut.core.annotation.Nullable;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@Singleton
public class JsonSchemaGenerator {
    private static final List<Class<?>> TYPES_RESOLVED_AS_STRING = List.of(Duration.class, LocalTime.class, LocalDate.class, LocalDateTime.class, ZonedDateTime.class, OffsetDateTime.class, OffsetTime.class);
    private static final List<Class<?>> SUBTYPE_RESOLUTION_EXCLUSION_FOR_PLUGIN_SCHEMA = List.of(Task.class, AbstractTrigger.class);
    private static final ObjectMapper MAPPER = JacksonMapper.ofJson().copy().configure(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS, false);
    private static final ObjectMapper YAML_MAPPER = JacksonMapper.ofYaml().copy().configure(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS, false);
    private final PluginRegistry pluginRegistry;
    Map<Class<?>, Object> defaultInstances = new HashMap();

    @Inject
    public JsonSchemaGenerator(PluginRegistry pluginRegistry) {
        this.pluginRegistry = pluginRegistry;
    }

    public <T> Map<String, Object> schemas(Class<? extends T> cls) {
        return this.schemas(cls, false);
    }

    private void replaceOneOfWithAnyOf(ObjectNode objectNode) {
        objectNode.findParents("oneOf").forEach(jsonNode -> {
            if (jsonNode instanceof ObjectNode) {
                ObjectNode oNode = (ObjectNode)jsonNode;
                oNode.set("anyOf", oNode.remove("oneOf"));
            }
        });
    }

    public <T> Map<String, Object> schemas(Class<? extends T> cls, boolean arrayOf) {
        return this.schemas(cls, arrayOf, Collections.emptyList());
    }

    public <T> Map<String, Object> schemas(Class<? extends T> cls, boolean arrayOf, List<String> allowedPluginTypes) {
        return this.schemas(cls, arrayOf, allowedPluginTypes, false);
    }

    public <T> Map<String, Object> schemas(Class<? extends T> cls, boolean arrayOf, List<String> allowedPluginTypes, boolean withOutputs) {
        SchemaGeneratorConfigBuilder builder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_7, OptionPreset.PLAIN_JSON);
        this.build(builder, true, allowedPluginTypes, withOutputs);
        SchemaGeneratorConfig schemaGeneratorConfig = builder.build();
        SchemaGenerator generator = new SchemaGenerator(schemaGeneratorConfig);
        try {
            ObjectNode objectNode = generator.generateSchema(cls, new Type[0]);
            if (arrayOf) {
                objectNode.put("type", "array");
            }
            this.replaceOneOfWithAnyOf(objectNode);
            this.pullDocumentationAndDefaultFromAnyOf(objectNode);
            this.removeRequiredOnPropsWithDefaults(objectNode);
            return (Map)MAPPER.convertValue((Object)objectNode, JacksonMapper.MAP_TYPE_REFERENCE);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to generate jsonschema for '" + cls.getName() + "'", e);
        }
    }

    private void removeRequiredOnPropsWithDefaults(ObjectNode objectNode) {
        objectNode.findParents("required").forEach(jsonNode -> {
            ObjectNode clazzSchema;
            JsonNode patt0$temp;
            if (jsonNode instanceof ObjectNode && (patt0$temp = (clazzSchema = (ObjectNode)jsonNode).get("required")) instanceof ArrayNode) {
                ArrayNode requiredPropsNode = (ArrayNode)patt0$temp;
                JsonNode patt1$temp = clazzSchema.get("properties");
                if (patt1$temp instanceof ObjectNode) {
                    ObjectNode properties = (ObjectNode)patt1$temp;
                    List requiredFieldValues = StreamSupport.stream(requiredPropsNode.spliterator(), false).map(JsonNode::asText).collect(Collectors.toList());
                    properties.fields().forEachRemaining(e -> {
                        ObjectNode valueNode;
                        Object patt0$temp;
                        int indexInRequiredArray = requiredFieldValues.indexOf(e.getKey());
                        if (indexInRequiredArray != -1 && (patt0$temp = e.getValue()) instanceof ObjectNode && (valueNode = (ObjectNode)patt0$temp).has("default")) {
                            requiredPropsNode.remove(indexInRequiredArray);
                            requiredFieldValues.remove(indexInRequiredArray);
                        }
                    });
                    if (requiredPropsNode.isEmpty()) {
                        clazzSchema.remove("required");
                    }
                }
            }
        });
        JsonNode jsonNode2 = objectNode.get("definitions");
        if (jsonNode2 instanceof ObjectNode) {
            ObjectNode definitions = (ObjectNode)jsonNode2;
            definitions.forEach(jsonNode -> {
                if (jsonNode instanceof ObjectNode) {
                    ObjectNode definition = (ObjectNode)jsonNode;
                    this.removeRequiredOnPropsWithDefaults(definition);
                }
            });
        }
    }

    private void pullDocumentationAndDefaultFromAnyOf(ObjectNode objectNode) {
        objectNode.findParents("anyOf").forEach(jsonNode -> {
            ObjectNode oNode;
            JsonNode anyOf;
            if (jsonNode instanceof ObjectNode && (anyOf = (oNode = (ObjectNode)jsonNode).get("anyOf")) instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)anyOf;
                Iterator it = arrayNode.elements();
                HashMap nodesToPullUp = new HashMap(Map.ofEntries(Map.entry("default", Optional.empty()), Map.entry("title", Optional.empty()), Map.entry("description", Optional.empty()), Map.entry("$deprecated", Optional.empty())));
                while (it.hasNext() && nodesToPullUp.containsValue(Optional.empty())) {
                    JsonNode next = (JsonNode)it.next();
                    if (!(next instanceof ObjectNode)) continue;
                    ObjectNode nextAsObj = (ObjectNode)next;
                    nodesToPullUp.entrySet().stream().filter(node -> ((Optional)node.getValue()).isEmpty()).forEach(node -> node.setValue(Optional.ofNullable(nextAsObj.get((String)node.getKey()))));
                }
                nodesToPullUp.entrySet().stream().filter(node -> ((Optional)node.getValue()).isPresent()).forEach(node -> oNode.set((String)node.getKey(), (JsonNode)((Optional)node.getValue()).get()));
            }
        });
    }

    private void mutateDescription(ObjectNode collectedTypeAttributes) {
        if (collectedTypeAttributes.has("description")) {
            collectedTypeAttributes.set("markdownDescription", collectedTypeAttributes.get("description"));
            collectedTypeAttributes.remove("description");
        }
        if (collectedTypeAttributes.has("description")) {
            collectedTypeAttributes.set("markdownDescription", collectedTypeAttributes.get("description"));
            collectedTypeAttributes.remove("description");
        }
        if (collectedTypeAttributes.has("default")) {
            StringBuilder sb = new StringBuilder();
            if (collectedTypeAttributes.has("markdownDescription")) {
                sb.append(collectedTypeAttributes.get("markdownDescription").asText());
                sb.append("\n\n");
            }
            try {
                sb.append("Default value is : `").append(YAML_MAPPER.writeValueAsString((Object)collectedTypeAttributes.get("default")).trim()).append("`");
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            collectedTypeAttributes.set("markdownDescription", (JsonNode)new TextNode(sb.toString()));
        }
    }

    public <T> Map<String, Object> properties(Class<T> base, Class<? extends T> cls) {
        return this.generate(cls, base);
    }

    public <T> Map<String, Object> outputs(Class<T> base, Class<? extends T> cls) {
        ArrayList<Class<T>> superClass = new ArrayList<Class<T>>();
        for (Class<T> c2 = cls; c2 != null && c2 != base; c2 = c2.getSuperclass()) {
            superClass.add(c2);
        }
        return superClass.stream().flatMap(r -> Arrays.stream(r.getGenericInterfaces())).filter(type -> type instanceof ParameterizedType).map(type -> (ParameterizedType)type).flatMap(parameterizedType -> Arrays.stream(parameterizedType.getActualTypeArguments())).filter(type -> type instanceof Class).map(type -> (Class)type).filter(Output.class::isAssignableFrom).findFirst().map(c -> this.generate((Class)c, null)).orElse((Map)ImmutableMap.of());
    }

    protected void build(SchemaGeneratorConfigBuilder builder, boolean draft7) {
        this.build(builder, draft7, Collections.emptyList());
    }

    protected void build(SchemaGeneratorConfigBuilder builder, boolean draft7, List<String> allowedPluginTypes) {
        this.build(builder, draft7, allowedPluginTypes, false);
    }

    protected void build(SchemaGeneratorConfigBuilder builder, boolean draft7, List<String> allowedPluginTypes, boolean withOutputs) {
        builder.with((Module)new JakartaValidationModule(new JakartaValidationOption[]{JakartaValidationOption.NOT_NULLABLE_METHOD_IS_REQUIRED, JakartaValidationOption.NOT_NULLABLE_FIELD_IS_REQUIRED, JakartaValidationOption.INCLUDE_PATTERN_EXPRESSIONS})).with((Module)new Swagger2Module()).with(Option.DEFINITIONS_FOR_ALL_OBJECTS, new Option[0]).with(Option.DEFINITION_FOR_MAIN_SCHEMA, new Option[0]).with(Option.PLAIN_DEFINITION_KEYS, new Option[0]).with(Option.ALLOF_CLEANUP_AT_THE_END, new Option[0]);
        if (!draft7) {
            builder.with((Module)new JacksonModule(new JacksonOption[]{JacksonOption.IGNORE_TYPE_INFO_TRANSFORM}));
        } else {
            builder.with((Module)new JacksonModule());
        }
        builder.forFields().withDefaultResolver(this::defaults);
        builder.forTypesInGeneral().withDefinitionNamingStrategy((SchemaDefinitionNamingStrategy)new DefaultSchemaDefinitionNamingStrategy(this){

            public String getDefinitionNameForKey(DefinitionKey key, SchemaGenerationContext context) {
                TypeContext typeContext = context.getTypeContext();
                ResolvedType type = key.getType();
                return typeContext.getFullTypeDescription(type);
            }

            public String adjustNullableName(DefinitionKey key, String definitionName, SchemaGenerationContext context) {
                return definitionName;
            }
        });
        builder.forTypesInGeneral().withCustomDefinitionProvider(new CustomDefinitionProviderV2(this){

            public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
                if (javaType.isInstanceOf(Map.class) || javaType.isInstanceOf(Enum.class)) {
                    ObjectNode definition = context.createStandardDefinition(javaType, (CustomDefinitionProviderV2)this);
                    return new CustomDefinition(definition, true);
                }
                if (javaType.isInstanceOf(Duration.class)) {
                    ObjectNode definitionReference = context.createDefinitionReference(context.getTypeContext().resolve(String.class, new Type[0])).put("format", "duration");
                    return new CustomDefinition(definitionReference, true);
                }
                if (javaType.isInstanceOf(LocalTime.class)) {
                    ObjectNode definitionReference = context.createDefinitionReference(context.getTypeContext().resolve(String.class, new Type[0])).put("format", "partial-time");
                    return new CustomDefinition(definitionReference, true);
                }
                return null;
            }
        });
        builder.forFields().withTargetTypeOverridesResolver(target -> {
            ResolvedType javaType = target.getType();
            if (javaType.isInstanceOf(Property.class)) {
                TypeContext context = target.getContext();
                Class erasedType = ((ResolvedType)javaType.getTypeParameters().getFirst()).getErasedType();
                if (String.class.isAssignableFrom(erasedType)) {
                    return List.of(context.resolve(String.class, new Type[0]));
                }
                if (Object.class.equals((Object)erasedType)) {
                    return List.of(context.resolve(Object.class, new Type[0]));
                }
                if (erasedType.isEnum()) {
                    return List.of((ResolvedType)javaType.getTypeParameters().getFirst());
                }
                if (List.class.isAssignableFrom(erasedType) || Map.class.isAssignableFrom(erasedType)) {
                    return List.of((ResolvedType)javaType.getTypeParameters().getFirst());
                }
                if (this.isAssignableFromResolvedAsString(erasedType)) {
                    return List.of((ResolvedType)javaType.getTypeParameters().getFirst());
                }
                return List.of((ResolvedType)javaType.getTypeParameters().getFirst(), context.resolve(String.class, new Type[0]));
            }
            if (javaType.isInstanceOf(EncryptedString.class)) {
                TypeContext context = target.getContext();
                return List.of(context.resolve(String.class, new Type[0]));
            }
            return null;
        });
        builder.forFields().withInstanceAttributeOverride((memberAttributes, member, context) -> {
            Deprecated deprecated;
            Schema schema;
            PluginProperty pluginPropertyAnnotation = (PluginProperty)member.getAnnotationConsideringFieldAndGetter(PluginProperty.class);
            if (pluginPropertyAnnotation != null) {
                memberAttributes.put("$dynamic", pluginPropertyAnnotation.dynamic());
                if (pluginPropertyAnnotation.beta()) {
                    memberAttributes.put("$beta", true);
                }
                if (pluginPropertyAnnotation.internalStorageURI()) {
                    memberAttributes.put("$internalStorageURI", true);
                }
                if (!pluginPropertyAnnotation.group().isEmpty()) {
                    memberAttributes.put("$group", pluginPropertyAnnotation.group());
                }
            }
            if ((schema = (Schema)member.getAnnotationConsideringFieldAndGetter(Schema.class)) != null && schema.deprecated()) {
                memberAttributes.put("$deprecated", true);
            }
            if ((deprecated = (Deprecated)member.getAnnotationConsideringFieldAndGetter(Deprecated.class)) != null) {
                memberAttributes.put("$deprecated", true);
            }
            if (member.getDeclaredType().isInstanceOf(Property.class)) {
                memberAttributes.put("$dynamic", true);
            } else if (member.getDeclaredType().isInstanceOf(Data.class)) {
                memberAttributes.put("$dynamic", false);
            }
        });
        builder.forTypesInGeneral().withTypeAttributeOverride((collectedTypeAttributes, scope, context) -> {
            io.kestra.core.models.annotations.Plugin pluginAnnotation = scope.getType().getErasedType().getAnnotation(io.kestra.core.models.annotations.Plugin.class);
            if (pluginAnnotation != null) {
                List<ObjectNode> metrics;
                List<ObjectNode> examples = Arrays.stream(pluginAnnotation.examples()).map(example -> context.getGeneratorConfig().createObjectNode().put("full", example.full()).put("code", String.join((CharSequence)"\n", example.code())).put("lang", example.lang()).put("title", example.title())).toList();
                if (!examples.isEmpty()) {
                    collectedTypeAttributes.set("$examples", (JsonNode)context.getGeneratorConfig().createArrayNode().addAll(examples));
                }
                if (!(metrics = Arrays.stream(pluginAnnotation.metrics()).map(metric -> context.getGeneratorConfig().createObjectNode().put("name", metric.name()).put("type", metric.type()).put("unit", metric.unit()).put("description", metric.description())).toList()).isEmpty()) {
                    collectedTypeAttributes.set("$metrics", (JsonNode)context.getGeneratorConfig().createArrayNode().addAll(metrics));
                }
                if (pluginAnnotation.beta()) {
                    collectedTypeAttributes.put("$beta", true);
                }
                if (withOutputs) {
                    Map<String, Object> outputsSchema = this.outputs(null, scope.getType().getErasedType());
                    collectedTypeAttributes.set("outputs", (JsonNode)context.getGeneratorConfig().createObjectNode().pojoNode(AbstractClassDocumentation.flattenWithoutType(AbstractClassDocumentation.properties(outputsSchema), AbstractClassDocumentation.required(outputsSchema))));
                }
            }
            Schema schema = scope.getType().getErasedType().getAnnotation(Schema.class);
            Deprecated deprecated = scope.getType().getErasedType().getAnnotation(Deprecated.class);
            if (schema != null && schema.deprecated() || deprecated != null) {
                collectedTypeAttributes.put("$deprecated", "true");
            }
        });
        builder.forFields().withAdditionalPropertiesResolver(target -> {
            Schema contentSchemaAnnotation;
            PluginProperty pluginPropertyAnnotation = (PluginProperty)target.getAnnotationConsideringFieldAndGetter(PluginProperty.class);
            Schema schemaAnnotation = (Schema)target.getAnnotationConsideringFieldAndGetter(Schema.class);
            Content contentAnnotation = (Content)target.getAnnotationConsideringFieldAndGetter(Content.class);
            Schema schema = contentSchemaAnnotation = contentAnnotation == null ? null : contentAnnotation.additionalPropertiesSchema();
            if (pluginPropertyAnnotation != null) {
                return pluginPropertyAnnotation.additionalProperties();
            }
            if (target.getType().isInstanceOf(Map.class)) {
                return target.getTypeParameterFor(Map.class, 1);
            }
            if (schemaAnnotation != null && schemaAnnotation.additionalPropertiesSchema() != Void.class) {
                return schemaAnnotation.additionalPropertiesSchema();
            }
            if (contentSchemaAnnotation != null && contentSchemaAnnotation.additionalPropertiesSchema() != Void.class) {
                return contentSchemaAnnotation.additionalPropertiesSchema();
            }
            return Object.class;
        });
        if (builder.build().getSchemaVersion() != SchemaVersion.DRAFT_2019_09) {
            builder.forTypesInGeneral().withSubtypeResolver((declaredType, context) -> {
                TypeContext typeContext = context.getTypeContext();
                return this.subtypeResolver(declaredType, typeContext, allowedPluginTypes);
            });
            builder.forTypesInGeneral().withTypeAttributeOverride((collectedTypeAttributes, scope, context) -> this.mutateDescription(collectedTypeAttributes));
            builder.forFields().withInstanceAttributeOverride((collectedTypeAttributes, scope, context) -> this.mutateDescription(collectedTypeAttributes));
            builder.forTypesInGeneral().withTypeAttributeOverride((collectedTypeAttributes, scope, context) -> {
                if (collectedTypeAttributes.has("required") && collectedTypeAttributes.get("required") instanceof ArrayNode) {
                    ArrayNode required = context.getGeneratorConfig().createArrayNode();
                    collectedTypeAttributes.get("required").forEach(jsonNode -> {
                        if (!collectedTypeAttributes.get("properties").get(jsonNode.asText()).has("default") && !this.defaultInAllOf(collectedTypeAttributes.get("properties").get(jsonNode.asText()))) {
                            required.add(jsonNode.asText());
                        }
                    });
                    collectedTypeAttributes.set("required", (JsonNode)required);
                }
            });
            builder.forFields().withInstanceAttributeOverride((collectedTypeAttributes, scope, context) -> {
                if (collectedTypeAttributes.has("pattern") && collectedTypeAttributes.get("pattern").asText().contains("javaJavaIdentifier")) {
                    collectedTypeAttributes.remove("pattern");
                }
            });
            builder.forTypesInGeneral().withTypeAttributeOverride((collectedTypeAttributes, scope, context) -> {
                if (collectedTypeAttributes.has("$examples")) {
                    ArrayNode examples = (ArrayNode)collectedTypeAttributes.get("$examples");
                    String doc = StreamSupport.stream(examples.spliterator(), true).map(jsonNode -> {
                        Object description = "";
                        if (jsonNode.has("title")) {
                            description = (String)description + "> " + jsonNode.get("title").asText() + "\n";
                        }
                        description = (String)description + "```" + (jsonNode.has("lang") ? jsonNode.get("lang").asText() : "yaml") + "\n" + jsonNode.get("code").asText() + "\n```";
                        return description;
                    }).collect(Collectors.joining("\n\n"));
                    Object description = collectedTypeAttributes.has("markdownDescription") ? collectedTypeAttributes.get("markdownDescription").asText() : "";
                    description = (String)description + "##### Examples\n" + doc;
                    collectedTypeAttributes.set("markdownDescription", (JsonNode)new TextNode((String)description));
                    collectedTypeAttributes.remove("$examples");
                }
            });
        } else {
            builder.forTypesInGeneral().withSubtypeResolver((declaredType, context) -> {
                TypeContext typeContext = context.getTypeContext();
                if (SUBTYPE_RESOLUTION_EXCLUSION_FOR_PLUGIN_SCHEMA.contains(declaredType.getErasedType())) {
                    return null;
                }
                return this.subtypeResolver(declaredType, typeContext, allowedPluginTypes);
            });
        }
        builder.forTypesInGeneral().withTypeAttributeOverride((collectedTypeAttributes, scope, context) -> {
            ObjectNode properties;
            Class pluginType = scope.getType().getErasedType();
            if (pluginType.getAnnotation(io.kestra.core.models.annotations.Plugin.class) != null && (properties = (ObjectNode)collectedTypeAttributes.get("properties")) != null) {
                properties.set("type", (JsonNode)context.getGeneratorConfig().createObjectNode().put("const", pluginType.getName()));
            }
        });
        this.typeDefiningPropertiesToConst(builder);
    }

    private void typeDefiningPropertiesToConst(SchemaGeneratorConfigBuilder builder) {
        builder.forTypesInGeneral().withTypeAttributeOverride((collectedTypeAttributes, scope, context) -> {
            Class targetType = scope.getType().getErasedType();
            JsonTypeInfo jsonTypeInfo = Optional.ofNullable(targetType.getSuperclass()).map(c -> c.getAnnotation(JsonTypeInfo.class)).orElse(null);
            if (jsonTypeInfo == null) {
                return;
            }
            String property = jsonTypeInfo.property();
            if (property == null) {
                return;
            }
            ObjectNode properties = (ObjectNode)collectedTypeAttributes.get("properties");
            if (properties == null) {
                return;
            }
            String defaultValue = Optional.ofNullable(properties.get(property)).flatMap(p -> {
                Optional<String> defaultOpt = p.optional("default").map(JsonNode::asText);
                if (defaultOpt.isPresent()) {
                    return defaultOpt;
                }
                return p.optional("allOf").flatMap(node -> {
                    if (node.isArray()) {
                        Iterable iterable = () -> ((JsonNode)node).values();
                        return StreamSupport.stream(iterable.spliterator(), false).filter(subNode -> subNode.has("default")).findFirst().map(subNode -> subNode.get("default").asText());
                    }
                    return Optional.empty();
                });
            }).orElse(null);
            if (defaultValue == null) {
                return;
            }
            properties.set(property, (JsonNode)context.getGeneratorConfig().createObjectNode().put("const", defaultValue));
        });
    }

    private boolean isAssignableFromResolvedAsString(Class<?> declaredType) {
        for (Class<?> clazz : TYPES_RESOLVED_AS_STRING) {
            if (!clazz.isAssignableFrom(declaredType)) continue;
            return true;
        }
        return false;
    }

    protected List<ResolvedType> subtypeResolver(ResolvedType declaredType, TypeContext typeContext, List<String> allowedPluginTypes) {
        if (declaredType.getErasedType() == Task.class) {
            return this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getTasks().stream()).filter(p -> allowedPluginTypes.isEmpty() || allowedPluginTypes.contains(p.getName())).filter(Predicate.not(Plugin::isInternal)).flatMap(clz -> JsonSchemaGenerator.safelyResolveSubtype(declaredType, clz, typeContext).stream()).toList();
        }
        if (declaredType.getErasedType() == AbstractTrigger.class) {
            return this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getTriggers().stream()).filter(p -> allowedPluginTypes.isEmpty() || allowedPluginTypes.contains(p.getName())).filter(Predicate.not(Plugin::isInternal)).flatMap(clz -> JsonSchemaGenerator.safelyResolveSubtype(declaredType, clz, typeContext).stream()).toList();
        }
        if (declaredType.getErasedType() == Condition.class) {
            return this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getConditions().stream()).filter(p -> allowedPluginTypes.isEmpty() || allowedPluginTypes.contains(p.getName())).filter(Predicate.not(Plugin::isInternal)).flatMap(clz -> JsonSchemaGenerator.safelyResolveSubtype(declaredType, clz, typeContext).stream()).toList();
        }
        if (declaredType.getErasedType() == ScheduleCondition.class) {
            return this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getConditions().stream()).filter(ScheduleCondition.class::isAssignableFrom).filter(p -> allowedPluginTypes.isEmpty() || allowedPluginTypes.contains(p.getName())).filter(Predicate.not(Plugin::isInternal)).flatMap(clz -> JsonSchemaGenerator.safelyResolveSubtype(declaredType, clz, typeContext).stream()).toList();
        }
        if (declaredType.getErasedType() == TaskRunner.class) {
            return this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getTaskRunners().stream()).filter(p -> allowedPluginTypes.isEmpty() || allowedPluginTypes.contains(p.getName())).filter(Predicate.not(Plugin::isInternal)).map(x$0 -> typeContext.resolve(x$0, new Type[0])).toList();
        }
        if (declaredType.getErasedType() == LogExporter.class) {
            return this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getLogExporters().stream()).filter(p -> allowedPluginTypes.isEmpty() || allowedPluginTypes.contains(p.getName())).filter(Predicate.not(Plugin::isInternal)).map(x$0 -> typeContext.resolve(x$0, new Type[0])).toList();
        }
        if (AdditionalPlugin.class.isAssignableFrom(declaredType.getErasedType())) {
            return this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getAdditionalPlugins().stream()).filter(cls -> declaredType.getErasedType().isAssignableFrom((Class<?>)cls)).filter(p -> allowedPluginTypes.isEmpty() || allowedPluginTypes.contains(p.getName())).filter(cls -> cls != declaredType.getErasedType()).filter(Predicate.not(Plugin::isInternal)).map(x$0 -> typeContext.resolve(x$0, new Type[0])).toList();
        }
        if (declaredType.getErasedType() == Chart.class) {
            return this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getCharts().stream()).filter(p -> allowedPluginTypes.isEmpty() || allowedPluginTypes.contains(p.getName())).filter(Predicate.not(Plugin::isInternal)).mapMulti((clz, consumer) -> {
                if (DataChart.class.isAssignableFrom((Class<?>)clz)) {
                    List<Class> dataFilters = this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getDataFilters().stream()).filter(Predicate.not(Plugin::isInternal)).toList();
                    TypeVariable dataFilterType = clz.getTypeParameters()[1];
                    ParameterizedType chartAwareColumnDescriptor = (ParameterizedType)((WildcardType)((ParameterizedType)dataFilterType.getBounds()[0]).getActualTypeArguments()[1]).getUpperBounds()[0];
                    dataFilters.forEach(dataFilter -> {
                        Type fieldsEnum = ((ParameterizedType)dataFilter.getGenericSuperclass()).getActualTypeArguments()[0];
                        consumer.accept(typeContext.resolve((Type)clz, new Type[]{fieldsEnum, typeContext.resolve((Type)dataFilter, new Type[]{typeContext.resolve((Type)chartAwareColumnDescriptor, new Type[]{fieldsEnum})})}));
                    });
                } else if (DataChartKPI.class.isAssignableFrom((Class<?>)clz)) {
                    List<Class> dataFilterKPIs = this.getRegisteredPlugins().stream().flatMap(registeredPlugin -> registeredPlugin.getDataFiltersKPI().stream()).filter(Predicate.not(Plugin::isInternal)).toList();
                    TypeVariable dataFilterType = clz.getTypeParameters()[1];
                    ParameterizedType chartAwareColumnDescriptor = (ParameterizedType)((WildcardType)((ParameterizedType)dataFilterType.getBounds()[0]).getActualTypeArguments()[1]).getUpperBounds()[0];
                    dataFilterKPIs.forEach(dataFilterKPI -> {
                        Type fieldsEnum = ((ParameterizedType)dataFilterKPI.getGenericSuperclass()).getActualTypeArguments()[0];
                        consumer.accept(typeContext.resolve((Type)clz, new Type[]{fieldsEnum, typeContext.resolve((Type)dataFilterKPI, new Type[]{typeContext.resolve((Type)chartAwareColumnDescriptor, new Type[]{fieldsEnum})})}));
                    });
                } else {
                    consumer.accept(typeContext.resolve((Type)clz, new Type[0]));
                }
            }).toList();
        }
        return null;
    }

    protected static Optional<ResolvedType> safelyResolveSubtype(ResolvedType declaredType, Class<?> clz, TypeContext typeContext) {
        try {
            return Optional.ofNullable(typeContext.resolveSubtype(declaredType, clz));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    protected List<RegisteredPlugin> getRegisteredPlugins() {
        return this.pluginRegistry.plugins();
    }

    private boolean defaultInAllOf(JsonNode property) {
        if (property.has("allOf")) {
            Iterator it = property.get("allOf").elements();
            while (it.hasNext()) {
                JsonNode child = (JsonNode)it.next();
                if (!child.has("default")) continue;
                return true;
            }
        }
        return false;
    }

    protected <T> Map<String, Object> generate(Class<? extends T> cls, @Nullable Class<T> base) {
        return this.generate(cls, base, Collections.emptyList());
    }

    protected <T> Map<String, Object> generate(Class<? extends T> cls, @Nullable Class<T> base, List<String> allowedPluginTypes) {
        SchemaGeneratorConfigBuilder builder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2019_09, OptionPreset.PLAIN_JSON);
        this.build(builder, false, allowedPluginTypes);
        builder.forFields().withIgnoreCheck(fieldScope -> base != null && (fieldScope.getAnnotation(PluginProperty.class) == null || ((PluginProperty)fieldScope.getAnnotation(PluginProperty.class)).hidden()) && fieldScope.getDeclaringType().getTypeName().equals(base.getName()));
        SchemaGeneratorConfig schemaGeneratorConfig = builder.build();
        SchemaGenerator generator = new SchemaGenerator(schemaGeneratorConfig);
        try {
            ObjectNode objectNode = generator.generateSchema(cls, new Type[0]);
            this.replaceOneOfWithAnyOf(objectNode);
            this.pullDocumentationAndDefaultFromAnyOf(objectNode);
            this.removeRequiredOnPropsWithDefaults(objectNode);
            return (Map)MAPPER.convertValue((Object)this.extractMainRef(objectNode), JacksonMapper.MAP_TYPE_REFERENCE);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to generate jsonschema for '" + cls.getName() + "'", e);
        }
    }

    protected Object defaults(FieldScope target) {
        Object instance;
        Optional<HierarchicType> concreteCls;
        if (!target.getDeclaredType().isInstanceOf(Property.class) && target.getOverriddenType() != null) {
            return null;
        }
        Class baseCls = ((ResolvedField)target.getMember()).getDeclaringType().getErasedType();
        if (Modifier.isAbstract(baseCls.getModifiers()) && (concreteCls = target.getDeclaringTypeMembers().mainTypeAndOverrides().stream().filter(type -> !type.isMixin()).findFirst()).isPresent()) {
            baseCls = concreteCls.get().getErasedType();
        }
        if (!this.defaultInstances.containsKey(baseCls)) {
            this.defaultInstances.put(baseCls, this.buildDefaultInstance(baseCls));
        }
        return (instance = this.defaultInstances.get(baseCls)) == null ? null : this.defaultValue(instance, baseCls, target.getName());
    }

    private ObjectNode extractMainRef(ObjectNode objectNode) {
        TextNode ref = (TextNode)objectNode.get("$ref");
        ObjectNode defs = (ObjectNode)objectNode.get("$defs");
        if (ref == null) {
            throw new IllegalArgumentException("Missing $ref");
        }
        String mainClassName = ref.asText().substring(ref.asText().lastIndexOf("/") + 1);
        if (mainClassName.endsWith("-2")) {
            mainClassName = mainClassName.substring(0, mainClassName.length() - 2);
            JsonNode mainClassDef = defs.get(mainClassName + "-1");
            this.addMainRefProperties(mainClassDef, objectNode);
            defs.remove(mainClassName + "-1");
            defs.remove(mainClassName + "-2");
        } else {
            JsonNode mainClassDef = defs.get(mainClassName);
            this.addMainRefProperties(mainClassDef, objectNode);
            defs.remove(mainClassName);
        }
        objectNode.remove("$ref");
        return objectNode;
    }

    private void addMainRefProperties(JsonNode mainClassDef, ObjectNode objectNode) {
        objectNode.set("properties", mainClassDef.get("properties"));
        if (mainClassDef.has("required")) {
            objectNode.set("required", mainClassDef.get("required"));
        }
        if (mainClassDef.has("title")) {
            objectNode.set("title", mainClassDef.get("title"));
        }
        if (mainClassDef.has("description")) {
            objectNode.set("description", mainClassDef.get("description"));
        }
        if (mainClassDef.has("$examples")) {
            objectNode.set("$examples", mainClassDef.get("$examples"));
        }
        if (mainClassDef.has("$metrics")) {
            objectNode.set("$metrics", mainClassDef.get("$metrics"));
        }
        if (mainClassDef.has("$deprecated")) {
            objectNode.set("$deprecated", mainClassDef.get("$deprecated"));
        }
        if (mainClassDef.has("$beta")) {
            objectNode.set("$beta", mainClassDef.get("$beta"));
        }
    }

    private Object buildDefaultInstance(Class<?> cls) {
        try {
            Method builderMethod = cls.getMethod("builder", new Class[0]);
            Object builder = builderMethod.invoke(null, new Object[0]);
            Method build = builder.getClass().getMethod("build", new Class[0]);
            build.setAccessible(true);
            return build.invoke(builder, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private Object defaultValue(Object instance, Class<?> cls, String fieldName) {
        try {
            Method field = cls.getMethod("get" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1), new Class[0]);
            field.setAccessible(true);
            return field.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException field) {
            try {
                Method field2 = cls.getMethod("is" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1), new Class[0]);
                field2.setAccessible(true);
                return field2.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
                return null;
            }
        }
    }
}

