/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.http;

import io.kestra.core.http.HttpRequest;
import io.kestra.core.http.HttpService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.net.http.HttpHeaders;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.protocol.HttpContext;

public final class HttpResponse<T> {
    private final Status status;
    private final HttpHeaders headers;
    private final T body;
    private final EndpointDetail endpointDetail;
    private final HttpRequest request;

    public static HttpResponse<byte[]> from(org.apache.hc.core5.http.HttpResponse response, HttpContext context) throws IOException {
        EndpointDetail endpointDetail;
        ClassicHttpResponse classicHttpResponse;
        HttpRequest httpRequest;
        HttpClientContext httpClientContext;
        HttpResponseBuilder httpResponseBuilder = HttpResponse.builder().status(Status.builder().code(response.getCode()).reason(response.getReasonPhrase()).build());
        if (context instanceof HttpClientContext) {
            httpClientContext = (HttpClientContext)context;
            httpRequest = HttpRequest.from(httpClientContext.getRequest());
        } else {
            httpRequest = null;
        }
        HttpResponseBuilder<Object> httpResponseBuilder2 = httpResponseBuilder.request(httpRequest).headers(HttpService.toHttpHeaders(response.getHeaders())).body(response instanceof ClassicHttpResponse && (classicHttpResponse = (ClassicHttpResponse)response).getEntity() != null ? IOUtils.toByteArray((InputStream)classicHttpResponse.getEntity().getContent()) : null);
        if (context instanceof HttpClientContext) {
            httpClientContext = (HttpClientContext)context;
            endpointDetail = EndpointDetail.from(httpClientContext.getEndpointDetails());
        } else {
            endpointDetail = null;
        }
        return httpResponseBuilder2.endpointDetail(endpointDetail).build();
    }

    public static <T> HttpResponse<T> from(ClassicHttpResponse httpResponse, T body, HttpRequest request, HttpContext context) {
        EndpointDetail endpointDetail;
        HttpResponseBuilder<T> httpResponseBuilder = HttpResponse.builder().status(Status.builder().code(httpResponse.getCode()).reason(httpResponse.getReasonPhrase()).build()).request(request).headers(HttpService.toHttpHeaders(httpResponse.getHeaders())).body(body);
        if (context instanceof HttpClientContext) {
            HttpClientContext httpClientContext = (HttpClientContext)context;
            endpointDetail = EndpointDetail.from(httpClientContext.getEndpointDetails());
        } else {
            endpointDetail = null;
        }
        return httpResponseBuilder.endpointDetail(endpointDetail).build();
    }

    @ConstructorProperties(value={"status", "headers", "body", "endpointDetail", "request"})
    @Generated
    HttpResponse(Status status, HttpHeaders headers, T body, EndpointDetail endpointDetail, HttpRequest request) {
        this.status = status;
        this.headers = headers;
        this.body = body;
        this.endpointDetail = endpointDetail;
        this.request = request;
    }

    @Generated
    public static <T> HttpResponseBuilder<T> builder() {
        return new HttpResponseBuilder();
    }

    @Generated
    public HttpResponseBuilder<T> toBuilder() {
        return new HttpResponseBuilder().status(this.status).headers(this.headers).body(this.body).endpointDetail(this.endpointDetail).request(this.request);
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Generated
    public T getBody() {
        return this.body;
    }

    @Generated
    public EndpointDetail getEndpointDetail() {
        return this.endpointDetail;
    }

    @Generated
    public HttpRequest getRequest() {
        return this.request;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        HttpHeaders this$headers = this.getHeaders();
        HttpHeaders other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        T this$body = this.getBody();
        T other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        EndpointDetail this$endpointDetail = this.getEndpointDetail();
        EndpointDetail other$endpointDetail = other.getEndpointDetail();
        if (this$endpointDetail == null ? other$endpointDetail != null : !((Object)this$endpointDetail).equals(other$endpointDetail)) {
            return false;
        }
        HttpRequest this$request = this.getRequest();
        HttpRequest other$request = other.getRequest();
        return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        HttpHeaders $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        T $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        EndpointDetail $endpointDetail = this.getEndpointDetail();
        result = result * 59 + ($endpointDetail == null ? 43 : ((Object)$endpointDetail).hashCode());
        HttpRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpResponse(status=" + String.valueOf(this.getStatus()) + ", headers=" + String.valueOf(this.getHeaders()) + ", body=" + String.valueOf(this.getBody()) + ", endpointDetail=" + String.valueOf(this.getEndpointDetail()) + ", request=" + String.valueOf(this.getRequest()) + ")";
    }

    @Generated
    public static class HttpResponseBuilder<T> {
        @Generated
        private Status status;
        @Generated
        private HttpHeaders headers;
        @Generated
        private T body;
        @Generated
        private EndpointDetail endpointDetail;
        @Generated
        private HttpRequest request;

        @Generated
        HttpResponseBuilder() {
        }

        @Generated
        public HttpResponseBuilder<T> status(Status status) {
            this.status = status;
            return this;
        }

        @Generated
        public HttpResponseBuilder<T> headers(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public HttpResponseBuilder<T> body(T body) {
            this.body = body;
            return this;
        }

        @Generated
        public HttpResponseBuilder<T> endpointDetail(EndpointDetail endpointDetail) {
            this.endpointDetail = endpointDetail;
            return this;
        }

        @Generated
        public HttpResponseBuilder<T> request(HttpRequest request) {
            this.request = request;
            return this;
        }

        @Generated
        public HttpResponse<T> build() {
            return new HttpResponse<T>(this.status, this.headers, this.body, this.endpointDetail, this.request);
        }

        @Generated
        public String toString() {
            return "HttpResponse.HttpResponseBuilder(status=" + String.valueOf(this.status) + ", headers=" + String.valueOf(this.headers) + ", body=" + String.valueOf(this.body) + ", endpointDetail=" + String.valueOf(this.endpointDetail) + ", request=" + String.valueOf(this.request) + ")";
        }
    }

    public static final class Status {
        private final int code;
        private final String reason;

        @ConstructorProperties(value={"code", "reason"})
        @Generated
        Status(int code, String reason) {
            this.code = code;
            this.reason = reason;
        }

        @Generated
        public static StatusBuilder builder() {
            return new StatusBuilder();
        }

        @Generated
        public int getCode() {
            return this.code;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Status)) {
                return false;
            }
            Status other = (Status)o;
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HttpResponse.Status(code=" + this.getCode() + ", reason=" + this.getReason() + ")";
        }

        @Generated
        public static class StatusBuilder {
            @Generated
            private int code;
            @Generated
            private String reason;

            @Generated
            StatusBuilder() {
            }

            @Generated
            public StatusBuilder code(int code) {
                this.code = code;
                return this;
            }

            @Generated
            public StatusBuilder reason(String reason) {
                this.reason = reason;
                return this;
            }

            @Generated
            public Status build() {
                return new Status(this.code, this.reason);
            }

            @Generated
            public String toString() {
                return "HttpResponse.Status.StatusBuilder(code=" + this.code + ", reason=" + this.reason + ")";
            }
        }
    }

    public static final class EndpointDetail {
        private final SocketAddress remoteAddress;
        private final SocketAddress localAddress;
        private final Long requestCount;
        private final Long responseCount;
        private final Long sentBytesCount;
        private final Long receivedBytesCount;

        public static EndpointDetail from(EndpointDetails details) {
            return EndpointDetail.builder().localAddress(details.getLocalAddress()).remoteAddress(details.getRemoteAddress()).requestCount(details.getRequestCount()).responseCount(details.getResponseCount()).sentBytesCount(details.getSentBytesCount()).receivedBytesCount(details.getReceivedBytesCount()).build();
        }

        @ConstructorProperties(value={"remoteAddress", "localAddress", "requestCount", "responseCount", "sentBytesCount", "receivedBytesCount"})
        @Generated
        EndpointDetail(SocketAddress remoteAddress, SocketAddress localAddress, Long requestCount, Long responseCount, Long sentBytesCount, Long receivedBytesCount) {
            this.remoteAddress = remoteAddress;
            this.localAddress = localAddress;
            this.requestCount = requestCount;
            this.responseCount = responseCount;
            this.sentBytesCount = sentBytesCount;
            this.receivedBytesCount = receivedBytesCount;
        }

        @Generated
        public static EndpointDetailBuilder builder() {
            return new EndpointDetailBuilder();
        }

        @Generated
        public SocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        @Generated
        public SocketAddress getLocalAddress() {
            return this.localAddress;
        }

        @Generated
        public Long getRequestCount() {
            return this.requestCount;
        }

        @Generated
        public Long getResponseCount() {
            return this.responseCount;
        }

        @Generated
        public Long getSentBytesCount() {
            return this.sentBytesCount;
        }

        @Generated
        public Long getReceivedBytesCount() {
            return this.receivedBytesCount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EndpointDetail)) {
                return false;
            }
            EndpointDetail other = (EndpointDetail)o;
            Long this$requestCount = this.getRequestCount();
            Long other$requestCount = other.getRequestCount();
            if (this$requestCount == null ? other$requestCount != null : !((Object)this$requestCount).equals(other$requestCount)) {
                return false;
            }
            Long this$responseCount = this.getResponseCount();
            Long other$responseCount = other.getResponseCount();
            if (this$responseCount == null ? other$responseCount != null : !((Object)this$responseCount).equals(other$responseCount)) {
                return false;
            }
            Long this$sentBytesCount = this.getSentBytesCount();
            Long other$sentBytesCount = other.getSentBytesCount();
            if (this$sentBytesCount == null ? other$sentBytesCount != null : !((Object)this$sentBytesCount).equals(other$sentBytesCount)) {
                return false;
            }
            Long this$receivedBytesCount = this.getReceivedBytesCount();
            Long other$receivedBytesCount = other.getReceivedBytesCount();
            if (this$receivedBytesCount == null ? other$receivedBytesCount != null : !((Object)this$receivedBytesCount).equals(other$receivedBytesCount)) {
                return false;
            }
            SocketAddress this$remoteAddress = this.getRemoteAddress();
            SocketAddress other$remoteAddress = other.getRemoteAddress();
            if (this$remoteAddress == null ? other$remoteAddress != null : !this$remoteAddress.equals(other$remoteAddress)) {
                return false;
            }
            SocketAddress this$localAddress = this.getLocalAddress();
            SocketAddress other$localAddress = other.getLocalAddress();
            return !(this$localAddress == null ? other$localAddress != null : !this$localAddress.equals(other$localAddress));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $requestCount = this.getRequestCount();
            result = result * 59 + ($requestCount == null ? 43 : ((Object)$requestCount).hashCode());
            Long $responseCount = this.getResponseCount();
            result = result * 59 + ($responseCount == null ? 43 : ((Object)$responseCount).hashCode());
            Long $sentBytesCount = this.getSentBytesCount();
            result = result * 59 + ($sentBytesCount == null ? 43 : ((Object)$sentBytesCount).hashCode());
            Long $receivedBytesCount = this.getReceivedBytesCount();
            result = result * 59 + ($receivedBytesCount == null ? 43 : ((Object)$receivedBytesCount).hashCode());
            SocketAddress $remoteAddress = this.getRemoteAddress();
            result = result * 59 + ($remoteAddress == null ? 43 : $remoteAddress.hashCode());
            SocketAddress $localAddress = this.getLocalAddress();
            result = result * 59 + ($localAddress == null ? 43 : $localAddress.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HttpResponse.EndpointDetail(remoteAddress=" + String.valueOf(this.getRemoteAddress()) + ", localAddress=" + String.valueOf(this.getLocalAddress()) + ", requestCount=" + this.getRequestCount() + ", responseCount=" + this.getResponseCount() + ", sentBytesCount=" + this.getSentBytesCount() + ", receivedBytesCount=" + this.getReceivedBytesCount() + ")";
        }

        @Generated
        public static class EndpointDetailBuilder {
            @Generated
            private SocketAddress remoteAddress;
            @Generated
            private SocketAddress localAddress;
            @Generated
            private Long requestCount;
            @Generated
            private Long responseCount;
            @Generated
            private Long sentBytesCount;
            @Generated
            private Long receivedBytesCount;

            @Generated
            EndpointDetailBuilder() {
            }

            @Generated
            public EndpointDetailBuilder remoteAddress(SocketAddress remoteAddress) {
                this.remoteAddress = remoteAddress;
                return this;
            }

            @Generated
            public EndpointDetailBuilder localAddress(SocketAddress localAddress) {
                this.localAddress = localAddress;
                return this;
            }

            @Generated
            public EndpointDetailBuilder requestCount(Long requestCount) {
                this.requestCount = requestCount;
                return this;
            }

            @Generated
            public EndpointDetailBuilder responseCount(Long responseCount) {
                this.responseCount = responseCount;
                return this;
            }

            @Generated
            public EndpointDetailBuilder sentBytesCount(Long sentBytesCount) {
                this.sentBytesCount = sentBytesCount;
                return this;
            }

            @Generated
            public EndpointDetailBuilder receivedBytesCount(Long receivedBytesCount) {
                this.receivedBytesCount = receivedBytesCount;
                return this;
            }

            @Generated
            public EndpointDetail build() {
                return new EndpointDetail(this.remoteAddress, this.localAddress, this.requestCount, this.responseCount, this.sentBytesCount, this.receivedBytesCount);
            }

            @Generated
            public String toString() {
                return "HttpResponse.EndpointDetail.EndpointDetailBuilder(remoteAddress=" + String.valueOf(this.remoteAddress) + ", localAddress=" + String.valueOf(this.localAddress) + ", requestCount=" + this.requestCount + ", responseCount=" + this.responseCount + ", sentBytesCount=" + this.sentBytesCount + ", receivedBytesCount=" + this.receivedBytesCount + ")";
            }
        }
    }
}

