/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.http;

import jakarta.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpHeaders;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;

public abstract class HttpService {
    public static URI safeURI(HttpRequest request) {
        try {
            return request.getUri();
        }
        catch (URISyntaxException e1) {
            return URI.create(request.getRequestUri());
        }
    }

    public static HttpHeaders toHttpHeaders(@Nullable Header[] headers) {
        if (headers == null) {
            return null;
        }
        return HttpHeaders.of(Arrays.stream(headers).collect(Collectors.groupingBy(header -> header.getName().toLowerCase(Locale.ROOT), Collectors.mapping(NameValuePair::getValue, Collectors.toList()))), (s, s2) -> true);
    }

    public static HttpEntityCopy copy(HttpEntity entity) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)os);
        byte[] body = os.toByteArray();
        ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
        boolean chunked = entity.isChunked();
        String contentEncoding = entity.getContentEncoding();
        ByteArrayEntity copy = new ByteArrayEntity(body, contentType, contentEncoding, chunked);
        return new HttpEntityCopy((HttpEntity)copy, body);
    }

    public static final class HttpEntityCopy
    implements HttpEntity {
        private final HttpEntity entity;
        private final byte[] body;

        @ConstructorProperties(value={"entity", "body"})
        @Generated
        public HttpEntityCopy(HttpEntity entity, byte[] body) {
            this.entity = entity;
            this.body = body;
        }

        @Generated
        public byte[] getBody() {
            return this.body;
        }

        @Generated
        public boolean isRepeatable() {
            return this.entity.isRepeatable();
        }

        @Generated
        public InputStream getContent() throws IOException, UnsupportedOperationException {
            return this.entity.getContent();
        }

        @Generated
        public void writeTo(OutputStream arg0) throws IOException {
            this.entity.writeTo(arg0);
        }

        @Generated
        public boolean isStreaming() {
            return this.entity.isStreaming();
        }

        @Generated
        public Supplier<List<? extends Header>> getTrailers() {
            return this.entity.getTrailers();
        }

        @Generated
        public long getContentLength() {
            return this.entity.getContentLength();
        }

        @Generated
        public String getContentType() {
            return this.entity.getContentType();
        }

        @Generated
        public String getContentEncoding() {
            return this.entity.getContentEncoding();
        }

        @Generated
        public boolean isChunked() {
            return this.entity.isChunked();
        }

        @Generated
        public Set<String> getTrailerNames() {
            return this.entity.getTrailerNames();
        }

        @Generated
        public void close() throws IOException {
            this.entity.close();
        }
    }
}

