/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.kestra.core.exceptions.InvalidQueryFiltersException;
import io.kestra.core.models.dashboards.filters.AbstractFilter;
import io.kestra.core.models.dashboards.filters.Contains;
import io.kestra.core.models.dashboards.filters.EndsWith;
import io.kestra.core.models.dashboards.filters.EqualTo;
import io.kestra.core.models.dashboards.filters.GreaterThan;
import io.kestra.core.models.dashboards.filters.GreaterThanOrEqualTo;
import io.kestra.core.models.dashboards.filters.In;
import io.kestra.core.models.dashboards.filters.LessThan;
import io.kestra.core.models.dashboards.filters.LessThanOrEqualTo;
import io.kestra.core.models.dashboards.filters.NotEqualTo;
import io.kestra.core.models.dashboards.filters.NotIn;
import io.kestra.core.models.dashboards.filters.Regex;
import io.kestra.core.models.dashboards.filters.StartsWith;
import io.kestra.core.utils.Enums;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public record QueryFilter(Field field, Op operation, Object value) {
    private List<Object> asValues(Object value) {
        List<String> list;
        if (value instanceof String) {
            String valueStr = (String)value;
            list = Arrays.asList(valueStr.split(","));
        } else {
            list = (List<String>)value;
        }
        return list;
    }

    public <T extends Enum<T>> AbstractFilter<T> toDashboardFilterBuilder(T field, Object value) {
        return switch (this.operation.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ((EqualTo.EqualToBuilder)((EqualTo.EqualToBuilder)EqualTo.builder().field(field)).value(value)).build();
            case 1 -> ((NotEqualTo.NotEqualToBuilder)((NotEqualTo.NotEqualToBuilder)NotEqualTo.builder().field(field)).value(value)).build();
            case 2 -> ((GreaterThan.GreaterThanBuilder)((GreaterThan.GreaterThanBuilder)GreaterThan.builder().field(field)).value(value)).build();
            case 3 -> ((LessThan.LessThanBuilder)((LessThan.LessThanBuilder)LessThan.builder().field(field)).value(value)).build();
            case 4 -> ((GreaterThanOrEqualTo.GreaterThanOrEqualToBuilder)((GreaterThanOrEqualTo.GreaterThanOrEqualToBuilder)GreaterThanOrEqualTo.builder().field(field)).value(value)).build();
            case 5 -> ((LessThanOrEqualTo.LessThanOrEqualToBuilder)((LessThanOrEqualTo.LessThanOrEqualToBuilder)LessThanOrEqualTo.builder().field(field)).value(value)).build();
            case 6 -> ((In.InBuilder)((In.InBuilder)In.builder().field(field)).values(this.asValues(value))).build();
            case 7 -> ((NotIn.NotInBuilder)((NotIn.NotInBuilder)NotIn.builder().field(field)).values(this.asValues(value))).build();
            case 8 -> ((StartsWith.StartsWithBuilder)((StartsWith.StartsWithBuilder)StartsWith.builder().field(field)).value(value.toString())).build();
            case 9 -> ((EndsWith.EndsWithBuilder)((EndsWith.EndsWithBuilder)EndsWith.builder().field(field)).value(value.toString())).build();
            case 10 -> ((Contains.ContainsBuilder)((Contains.ContainsBuilder)Contains.builder().field(field)).value(value.toString())).build();
            case 11 -> ((Regex.RegexBuilder)((Regex.RegexBuilder)Regex.builder().field(field)).value(value.toString())).build();
            case 12 -> ((Regex.RegexBuilder)((Regex.RegexBuilder)Regex.builder().field(field)).value("^" + value.toString().replace(".", "\\.") + "(?:\\..+)?$")).build();
        };
    }

    public static void validateQueryFilters(List<QueryFilter> filters, Resource resource) {
        if (filters == null) {
            return;
        }
        ArrayList<String> errors = new ArrayList<String>();
        filters.forEach(filter -> {
            if (!filter.field().supportedOp().contains((Object)filter.operation())) {
                errors.add("Operation %s is not supported for field %s. Supported operations are %s".formatted(new Object[]{filter.operation(), filter.field().name(), filter.field().supportedOp().stream().map(Enum::name).collect(Collectors.joining(", "))}));
            }
            if (!resource.supportedField().contains((Object)filter.field())) {
                errors.add("Field %s is not supported for resource %s. Supported fields are %s".formatted(filter.field().name(), resource.name(), resource.supportedField().stream().map(Enum::name).collect(Collectors.joining(", "))));
            }
        });
        if (!errors.isEmpty()) {
            throw new InvalidQueryFiltersException(errors);
        }
    }

    @Generated
    public static QueryFilterBuilder builder() {
        return new QueryFilterBuilder();
    }

    public static enum Field {
        QUERY("q"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS, Op.NOT_EQUALS);
            }
        }
        ,
        SCOPE("scope"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS, Op.NOT_EQUALS);
            }
        }
        ,
        NAMESPACE("namespace"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS, Op.NOT_EQUALS, Op.CONTAINS, Op.STARTS_WITH, Op.ENDS_WITH, Op.REGEX, Op.IN, Op.NOT_IN, Op.PREFIX);
            }
        }
        ,
        LABELS("labels"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS, Op.NOT_EQUALS);
            }
        }
        ,
        FLOW_ID("flowId"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS, Op.NOT_EQUALS, Op.CONTAINS, Op.STARTS_WITH, Op.ENDS_WITH, Op.REGEX);
            }
        }
        ,
        START_DATE("startDate"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.GREATER_THAN_OR_EQUAL_TO, Op.GREATER_THAN, Op.LESS_THAN_OR_EQUAL_TO, Op.LESS_THAN, Op.EQUALS, Op.NOT_EQUALS);
            }
        }
        ,
        END_DATE("endDate"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.GREATER_THAN_OR_EQUAL_TO, Op.GREATER_THAN, Op.LESS_THAN_OR_EQUAL_TO, Op.LESS_THAN, Op.EQUALS, Op.NOT_EQUALS);
            }
        }
        ,
        STATE("state"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS, Op.NOT_EQUALS, Op.IN, Op.NOT_IN);
            }
        }
        ,
        TIME_RANGE("timeRange"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS);
            }
        }
        ,
        TRIGGER_EXECUTION_ID("triggerExecutionId"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS, Op.NOT_EQUALS, Op.CONTAINS, Op.STARTS_WITH, Op.ENDS_WITH, Op.IN, Op.NOT_IN);
            }
        }
        ,
        TRIGGER_ID("triggerId"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS, Op.NOT_EQUALS, Op.CONTAINS, Op.STARTS_WITH, Op.ENDS_WITH, Op.IN, Op.NOT_IN);
            }
        }
        ,
        EXECUTION_ID("executionId"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS, Op.NOT_EQUALS, Op.CONTAINS, Op.STARTS_WITH, Op.ENDS_WITH, Op.IN, Op.NOT_IN);
            }
        }
        ,
        CHILD_FILTER("childFilter"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS, Op.NOT_EQUALS);
            }
        }
        ,
        WORKER_ID("workerId"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS, Op.NOT_EQUALS, Op.CONTAINS, Op.STARTS_WITH, Op.ENDS_WITH, Op.IN, Op.NOT_IN);
            }
        }
        ,
        EXISTING_ONLY("existingOnly"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS, Op.NOT_EQUALS);
            }
        }
        ,
        MIN_LEVEL("level"){

            @Override
            public List<Op> supportedOp() {
                return List.of(Op.EQUALS, Op.NOT_EQUALS);
            }
        };

        private static final Map<String, Field> BY_VALUE;
        private final String value;

        public abstract List<Op> supportedOp();

        private Field(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Field fromString(String value) {
            return Enums.fromString(value, BY_VALUE, "field");
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            BY_VALUE = Arrays.stream(Field.values()).collect(Collectors.toMap(Field::value, Function.identity()));
        }
    }

    public static enum Op {
        EQUALS,
        NOT_EQUALS,
        GREATER_THAN,
        LESS_THAN,
        GREATER_THAN_OR_EQUAL_TO,
        LESS_THAN_OR_EQUAL_TO,
        IN,
        NOT_IN,
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS,
        REGEX,
        PREFIX;

    }

    public static enum Resource {
        FLOW{

            @Override
            public List<Field> supportedField() {
                return List.of(Field.LABELS, Field.NAMESPACE, Field.QUERY, Field.SCOPE);
            }
        }
        ,
        NAMESPACE{

            @Override
            public List<Field> supportedField() {
                return List.of(Field.EXISTING_ONLY);
            }
        }
        ,
        EXECUTION{

            @Override
            public List<Field> supportedField() {
                return List.of(Field.QUERY, Field.SCOPE, Field.FLOW_ID, Field.START_DATE, Field.END_DATE, Field.STATE, Field.LABELS, Field.TRIGGER_EXECUTION_ID, Field.CHILD_FILTER, Field.NAMESPACE);
            }
        }
        ,
        LOG{

            @Override
            public List<Field> supportedField() {
                return List.of(Field.QUERY, Field.SCOPE, Field.NAMESPACE, Field.START_DATE, Field.END_DATE, Field.FLOW_ID, Field.TRIGGER_ID, Field.MIN_LEVEL, Field.EXECUTION_ID);
            }
        }
        ,
        TASK{

            @Override
            public List<Field> supportedField() {
                return List.of(Field.NAMESPACE, Field.QUERY, Field.END_DATE, Field.FLOW_ID, Field.START_DATE, Field.STATE, Field.LABELS, Field.TRIGGER_EXECUTION_ID, Field.CHILD_FILTER);
            }
        }
        ,
        TEMPLATE{

            @Override
            public List<Field> supportedField() {
                return List.of(Field.NAMESPACE, Field.QUERY);
            }
        }
        ,
        TRIGGER{

            @Override
            public List<Field> supportedField() {
                return List.of(Field.QUERY, Field.SCOPE, Field.NAMESPACE, Field.WORKER_ID, Field.FLOW_ID, Field.START_DATE, Field.END_DATE, Field.TRIGGER_ID);
            }
        };


        public abstract List<Field> supportedField();

        public static List<ResourceField> asResourceList() {
            return Arrays.stream(Resource.values()).map(Resource::toResourceField).toList();
        }

        private static ResourceField toResourceField(Resource resource) {
            List<FieldOp> fieldOps = resource.supportedField().stream().map(Resource::toFieldInfo).toList();
            return new ResourceField(resource.name().toLowerCase(), fieldOps);
        }

        private static FieldOp toFieldInfo(Field field) {
            List<Operation> operations = field.supportedOp().stream().map(Resource::toOperation).toList();
            return new FieldOp(field.name().toLowerCase(), field.value(), operations);
        }

        private static Operation toOperation(Op op) {
            return new Operation(op.name(), op.name());
        }
    }

    @Generated
    public static class QueryFilterBuilder {
        @Generated
        private Field field;
        @Generated
        private Op operation;
        @Generated
        private Object value;

        @Generated
        QueryFilterBuilder() {
        }

        @Generated
        public QueryFilterBuilder field(Field field) {
            this.field = field;
            return this;
        }

        @Generated
        public QueryFilterBuilder operation(Op operation) {
            this.operation = operation;
            return this;
        }

        @Generated
        public QueryFilterBuilder value(Object value) {
            this.value = value;
            return this;
        }

        @Generated
        public QueryFilter build() {
            return new QueryFilter(this.field, this.operation, this.value);
        }

        @Generated
        public String toString() {
            return "QueryFilter.QueryFilterBuilder(field=" + String.valueOf((Object)this.field) + ", operation=" + String.valueOf((Object)this.operation) + ", value=" + String.valueOf(this.value) + ")";
        }
    }

    public record Operation(String name, String value) {
    }

    public record FieldOp(String name, String value, List<Operation> operations) {
    }

    public record ResourceField(String name, List<FieldOp> fields) {
    }
}

