/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import io.kestra.core.debug.Breakpoint;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.DeletedInterface;
import io.kestra.core.models.Label;
import io.kestra.core.models.TenantInterface;
import io.kestra.core.models.executions.ExecutionKind;
import io.kestra.core.models.executions.ExecutionMetadata;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContextLogger;
import io.kestra.core.serializers.ListOrMapOfLabelDeserializer;
import io.kestra.core.serializers.ListOrMapOfLabelSerializer;
import io.kestra.core.services.LabelService;
import io.kestra.core.test.flow.TaskFixture;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.MapUtils;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Execution
implements DeletedInterface,
TenantInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Execution.class);
    @Hidden
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]*")
    private final @Pattern(regexp="^[a-z0-9][a-z0-9_-]*") String tenantId;
    @NotNull
    private final String id;
    @NotNull
    private final String namespace;
    @NotNull
    private final String flowId;
    @NotNull
    private final Integer flowRevision;
    private final List<TaskRun> taskRunList;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, Object> inputs;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, Object> outputs;
    @JsonSerialize(using=ListOrMapOfLabelSerializer.class)
    @JsonDeserialize(using=ListOrMapOfLabelDeserializer.class)
    private final List<Label> labels;
    private final Map<String, Object> variables;
    @NotNull
    private final State state;
    private final String parentId;
    private final String originalId;
    private final ExecutionTrigger trigger;
    @NotNull
    private final boolean deleted;
    private final ExecutionMetadata metadata;
    @Nullable
    private final Instant scheduleDate;
    private String traceParent;
    @Nullable
    private final List<TaskFixture> fixtures;
    @Nullable
    private final ExecutionKind kind;
    @Nullable
    private final List<Breakpoint> breakpoints;

    public static Execution newExecution(FlowInterface flow, List<Label> labels) {
        return Execution.newExecution(flow, null, labels, Optional.empty());
    }

    public List<Label> getLabels() {
        return ListUtils.emptyOnNull(this.labels);
    }

    public static Execution newExecution(FlowInterface flow, BiFunction<FlowInterface, Execution, Map<String, Object>> inputs, List<Label> labels, Optional<ZonedDateTime> scheduleDate) {
        Execution execution = Execution.builder().id(IdUtils.create()).tenantId(flow.getTenantId()).namespace(flow.getNamespace()).flowId(flow.getId()).flowRevision(flow.getRevision()).state(new State()).scheduleDate(scheduleDate.map(ChronoZonedDateTime::toInstant).orElse(null)).variables(flow.getVariables()).build();
        ArrayList<Label> executionLabels = new ArrayList<Label>(LabelService.labelsExcludingSystem(flow));
        if (labels != null) {
            executionLabels.addAll(labels);
        }
        if (executionLabels.stream().noneMatch(label -> "system.correlationId".equals(label.key()))) {
            executionLabels.add(new Label("system.correlationId", execution.getId()));
        }
        execution = execution.withLabels(executionLabels);
        if (inputs != null) {
            execution = execution.withInputs(inputs.apply(flow, execution));
        }
        return execution;
    }

    public static ExecutionBuilder builder() {
        return new CustomExecutionBuilder();
    }

    public Execution withState(State.Type state) {
        return new Execution(this.tenantId, this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, this.outputs, this.labels, this.variables, this.state.withState(state), this.parentId, this.originalId, this.trigger, this.deleted, this.metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
    }

    public Execution withLabels(List<Label> labels) {
        return new Execution(this.tenantId, this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, this.outputs, Label.deduplicate(labels), this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted, this.metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
    }

    public Execution withTaskRun(TaskRun taskRun) throws InternalException {
        ArrayList<TaskRun> newTaskRunList = this.taskRunList == null ? new ArrayList<TaskRun>() : new ArrayList<TaskRun>(this.taskRunList);
        boolean b = Collections.replaceAll(newTaskRunList, this.findTaskRunByTaskRunId(taskRun.getId()), taskRun);
        if (!b) {
            throw new IllegalStateException("Can't replace taskRun '" + taskRun.getId() + "' on execution'" + this.getId() + "'");
        }
        return new Execution(this.tenantId, this.id, this.namespace, this.flowId, this.flowRevision, newTaskRunList, this.inputs, this.outputs, this.labels, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted, this.metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
    }

    public Execution withBreakpoints(List<Breakpoint> newBreakpoints) {
        return new Execution(this.tenantId, this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, this.outputs, this.labels, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted, this.metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, newBreakpoints);
    }

    public Execution childExecution(String childExecutionId, List<TaskRun> taskRunList, State state) {
        return new Execution(this.tenantId, childExecutionId != null ? childExecutionId : this.getId(), this.namespace, this.flowId, this.flowRevision, taskRunList, this.inputs, this.outputs, this.labels, this.variables, state, childExecutionId != null ? this.getId() : null, this.originalId, this.trigger, this.deleted, this.metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
    }

    public List<TaskRun> findTaskRunsByTaskId(String id) {
        if (this.taskRunList == null) {
            return Collections.emptyList();
        }
        return this.taskRunList.stream().filter(taskRun -> taskRun.getTaskId().equals(id)).toList();
    }

    public TaskRun findTaskRunByTaskRunId(String id) throws InternalException {
        Optional<TaskRun> find = (this.taskRunList == null ? Collections.emptyList() : this.taskRunList).stream().filter(taskRun -> taskRun.getId().equals(id)).findFirst();
        if (find.isEmpty()) {
            throw new InternalException("Can't find taskrun with taskrunId '" + id + "' on execution '" + this.id + "' " + this.toStringState());
        }
        return find.get();
    }

    public TaskRun findTaskRunByTaskIdAndValue(String id, List<String> values) throws InternalException {
        Optional<TaskRun> find = (this.taskRunList == null ? Collections.emptyList() : this.taskRunList).stream().filter(taskRun -> taskRun.getTaskId().equals(id) && this.findParentsValues((TaskRun)taskRun, true).equals(values)).findFirst();
        if (find.isEmpty()) {
            throw new InternalException("Can't find taskrun with taskrunId '" + id + "' & value '" + String.valueOf(values) + "' on execution '" + this.id + "' " + this.toStringState());
        }
        return find.get();
    }

    public List<ResolvedTask> findTaskDependingFlowState(List<ResolvedTask> resolvedTasks, List<ResolvedTask> resolvedErrors, List<ResolvedTask> resolvedFinally) {
        return this.findTaskDependingFlowState(resolvedTasks, resolvedErrors, resolvedFinally, null);
    }

    public List<ResolvedTask> findTaskDependingFlowState(List<ResolvedTask> resolvedTasks, @Nullable List<ResolvedTask> resolvedErrors, @Nullable List<ResolvedTask> resolvedFinally, TaskRun parentTaskRun) {
        return this.findTaskDependingFlowState(resolvedTasks, resolvedErrors, resolvedFinally, parentTaskRun, null);
    }

    public List<ResolvedTask> findTaskDependingFlowState(List<ResolvedTask> resolvedTasks, @Nullable List<ResolvedTask> resolvedErrors, @Nullable List<ResolvedTask> resolvedFinally, TaskRun parentTaskRun, @Nullable State.Type terminalState) {
        resolvedTasks = this.removeDisabled(resolvedTasks);
        resolvedErrors = this.removeDisabled(resolvedErrors);
        resolvedFinally = this.removeDisabled(resolvedFinally);
        List<TaskRun> errorsFlow = this.findTaskRunByTasks(resolvedErrors, parentTaskRun);
        List<TaskRun> finallyFlow = this.findTaskRunByTasks(resolvedFinally, parentTaskRun);
        if (!finallyFlow.isEmpty()) {
            return resolvedFinally == null ? Collections.emptyList() : resolvedFinally;
        }
        if (errorsFlow.isEmpty() && terminalState == State.Type.FAILED) {
            return resolvedErrors == null ? (resolvedFinally == null ? Collections.emptyList() : resolvedFinally) : resolvedErrors;
        }
        if (!errorsFlow.isEmpty() || this.hasFailed(resolvedTasks, parentTaskRun)) {
            if (!this.hasFailedNoRetry(resolvedTasks, parentTaskRun) && terminalState != State.Type.FAILED) {
                return Collections.emptyList();
            }
            if (resolvedFinally != null && resolvedErrors != null && !this.isTerminated(resolvedErrors, parentTaskRun)) {
                return resolvedErrors;
            }
            if (resolvedFinally == null) {
                return resolvedErrors == null ? Collections.emptyList() : resolvedErrors;
            }
        }
        if (resolvedFinally != null && (this.isTerminated(resolvedTasks, parentTaskRun) || this.hasFailed(resolvedTasks, parentTaskRun))) {
            return resolvedFinally;
        }
        return resolvedTasks;
    }

    public List<ResolvedTask> findTaskDependingFlowState(List<ResolvedTask> resolvedTasks) {
        resolvedTasks = this.removeDisabled(resolvedTasks);
        return resolvedTasks;
    }

    private List<ResolvedTask> removeDisabled(List<ResolvedTask> tasks) {
        if (tasks == null) {
            return null;
        }
        return tasks.stream().filter(resolvedTask -> resolvedTask.getTask().getDisabled() == false).toList();
    }

    public List<TaskRun> findTaskRunByTasks(List<ResolvedTask> resolvedTasks, TaskRun parentTaskRun) {
        if (resolvedTasks == null || this.taskRunList == null) {
            return Collections.emptyList();
        }
        return this.getTaskRunList().stream().filter(t -> resolvedTasks.stream().anyMatch(resolvedTask -> FlowableUtils.isTaskRunFor(resolvedTask, t, parentTaskRun))).toList();
    }

    public Optional<TaskRun> findFirstByState(State.Type state) {
        if (this.taskRunList == null) {
            return Optional.empty();
        }
        return this.taskRunList.stream().filter(t -> t.getState().getCurrent() == state).findFirst();
    }

    public Optional<TaskRun> findFirstRunning() {
        if (this.taskRunList == null) {
            return Optional.empty();
        }
        return this.taskRunList.stream().filter(t -> t.getState().isRunning()).findFirst();
    }

    public Optional<TaskRun> findLastNotTerminated() {
        if (this.taskRunList == null) {
            return Optional.empty();
        }
        return Streams.findLast(this.taskRunList.stream().filter(t -> !t.getState().isTerminated() || !t.getState().isPaused()));
    }

    public Optional<TaskRun> findLastByState(List<TaskRun> taskRuns, State.Type state) {
        return Streams.findLast(taskRuns.stream().filter(t -> t.getState().getCurrent() == state));
    }

    public Optional<TaskRun> findLastCreated(List<TaskRun> taskRuns) {
        return Streams.findLast(taskRuns.stream().filter(t -> t.getState().isCreated()));
    }

    public Optional<TaskRun> findLastRunning(List<TaskRun> taskRuns) {
        return Streams.findLast(taskRuns.stream().filter(t -> t.getState().isRunning()));
    }

    public Optional<TaskRun> findLastTerminated(List<TaskRun> taskRuns) {
        return Streams.findLast(taskRuns.stream().filter(t -> t.getState().isTerminated()));
    }

    public boolean isTerminated(List<ResolvedTask> resolvedTasks) {
        return this.isTerminated(resolvedTasks, null);
    }

    public boolean isTerminated(List<ResolvedTask> resolvedTasks, TaskRun parentTaskRun) {
        long terminatedCount = this.findTaskRunByTasks(resolvedTasks, parentTaskRun).stream().filter(taskRun -> taskRun.getState().isTerminated()).count();
        return terminatedCount == (long)resolvedTasks.size();
    }

    public boolean hasWarning() {
        return this.taskRunList != null && this.taskRunList.stream().anyMatch(taskRun -> taskRun.getState().getCurrent() == State.Type.WARNING);
    }

    public boolean hasWarning(List<ResolvedTask> resolvedTasks) {
        return this.hasWarning(resolvedTasks, null);
    }

    public boolean hasWarning(List<ResolvedTask> resolvedTasks, TaskRun parentTaskRun) {
        return this.findTaskRunByTasks(resolvedTasks, parentTaskRun).stream().anyMatch(taskRun -> taskRun.getState().getCurrent() == State.Type.WARNING);
    }

    public boolean hasFailed() {
        return this.taskRunList != null && this.taskRunList.stream().anyMatch(taskRun -> taskRun.getState().isFailed());
    }

    public boolean hasFailed(List<ResolvedTask> resolvedTasks) {
        return this.hasFailed(resolvedTasks, null);
    }

    public boolean hasFailed(List<ResolvedTask> resolvedTasks, TaskRun parentTaskRun) {
        return this.findTaskRunByTasks(resolvedTasks, parentTaskRun).stream().anyMatch(taskRun -> taskRun.getState().isFailed());
    }

    public boolean hasFailedNoRetry(List<ResolvedTask> resolvedTasks, TaskRun parentTaskRun) {
        return this.findTaskRunByTasks(resolvedTasks, parentTaskRun).stream().anyMatch(taskRun -> {
            ResolvedTask resolvedTask = resolvedTasks.stream().filter(t -> t.getTask().getId().equals(taskRun.getTaskId())).findFirst().orElse(null);
            if (resolvedTask == null) {
                log.warn("Can't find task for taskRun '{}' in parentTaskRun '{}'", (Object)taskRun.getId(), (Object)parentTaskRun.getId());
                return false;
            }
            return !taskRun.shouldBeRetried(resolvedTask.getTask().getRetry()) && taskRun.getState().isFailed();
        });
    }

    public boolean hasCreated() {
        return this.taskRunList != null && this.taskRunList.stream().anyMatch(taskRun -> taskRun.getState().isCreated());
    }

    public boolean hasCreated(List<ResolvedTask> resolvedTasks) {
        return this.hasCreated(resolvedTasks, null);
    }

    public boolean hasCreated(List<ResolvedTask> resolvedTasks, TaskRun parentTaskRun) {
        return this.findTaskRunByTasks(resolvedTasks, parentTaskRun).stream().anyMatch(taskRun -> taskRun.getState().isCreated());
    }

    public boolean hasRunning(List<ResolvedTask> resolvedTasks) {
        return this.hasRunning(resolvedTasks, null);
    }

    public boolean hasRunning(List<ResolvedTask> resolvedTasks, TaskRun parentTaskRun) {
        return this.findTaskRunByTasks(resolvedTasks, parentTaskRun).stream().anyMatch(taskRun -> taskRun.getState().isRunning());
    }

    public State.Type guessFinalState(Flow flow) {
        return this.guessFinalState(ResolvedTask.of(flow.getTasks()), null, false, false);
    }

    public State.Type guessFinalState(List<ResolvedTask> currentTasks, TaskRun parentTaskRun, boolean allowFailure, boolean allowWarning) {
        return this.guessFinalState(currentTasks, parentTaskRun, allowFailure, allowWarning, State.Type.SUCCESS);
    }

    public State.Type guessFinalState(List<ResolvedTask> currentTasks, TaskRun parentTaskRun, boolean allowFailure, boolean allowWarning, State.Type terminalState) {
        List<TaskRun> taskRuns = this.findTaskRunByTasks(currentTasks, parentTaskRun);
        State.Type state = this.findLastByState(taskRuns, State.Type.KILLED).map(taskRun -> taskRun.getState().getCurrent()).or(() -> this.findLastByState(taskRuns, State.Type.FAILED).map(taskRun -> taskRun.getState().getCurrent())).or(() -> this.findLastByState(taskRuns, State.Type.WARNING).map(taskRun -> taskRun.getState().getCurrent())).or(() -> this.findLastByState(taskRuns, State.Type.PAUSED).map(taskRun -> taskRun.getState().getCurrent())).orElse(terminalState);
        if (state == State.Type.FAILED && allowFailure) {
            if (allowWarning) {
                return State.Type.SUCCESS;
            }
            return State.Type.WARNING;
        }
        if (State.Type.WARNING.equals((Object)state) && allowWarning) {
            return State.Type.SUCCESS;
        }
        return state;
    }

    @JsonIgnore
    public boolean hasTaskRunJoinable(TaskRun taskRun) {
        if (this.taskRunList == null) {
            return true;
        }
        TaskRun current = this.taskRunList.stream().filter(r -> r.isSame(taskRun)).findFirst().orElse(null);
        if (current == null) {
            return true;
        }
        if (current.getAttempts() == null && taskRun.getAttempts() != null || current.getAttempts() != null && taskRun.getAttempts() != null && current.getAttempts().size() < taskRun.getAttempts().size()) {
            return true;
        }
        if (current.getState().getCurrent() == taskRun.getState().getCurrent()) {
            return false;
        }
        if (current.getState().isTerminated() && !taskRun.getState().isTerminated()) {
            return false;
        }
        return current.getState().getHistories().size() <= taskRun.getState().getHistories().size();
    }

    public FailedExecutionWithLog failedExecutionFromExecutor(Exception e) {
        if (log.isWarnEnabled()) {
            log.warn("[namespace: {}] [flow: {}] [execution: {}] Flow failed from executor in {} with exception '{}'", new Object[]{this.getNamespace(), this.getFlowId(), this.getId(), this.getState().humanDuration(), e.getMessage(), e});
        }
        return this.findLastNotTerminated().map(taskRun -> {
            TaskRunAttempt lastAttempt = taskRun.lastAttempt();
            if (lastAttempt == null) {
                return this.newAttemptsTaskRunForFailedExecution((TaskRun)taskRun, e);
            }
            return this.lastAttemptsTaskRunForFailedExecution((TaskRun)taskRun, lastAttempt, e);
        }).map(t -> {
            try {
                return new FailedExecutionWithLog(this.withTaskRun(t.getTaskRun()), t.getLogs());
            }
            catch (InternalException ex) {
                return null;
            }
        }).orElseGet(() -> new FailedExecutionWithLog(this.state.getCurrent() != State.Type.FAILED ? this.withState(State.Type.FAILED) : this, RunContextLogger.logEntries(Execution.loggingEventFromException(e), LogEntry.of(this))));
    }

    public Optional<TaskFixture> getFixtureForTaskRun(TaskRun taskRun) {
        if (this.fixtures == null) {
            return Optional.empty();
        }
        return this.fixtures.stream().filter(fixture -> Objects.equals(fixture.getId(), taskRun.getTaskId()) && Objects.equals(fixture.getValue(), taskRun.getValue())).findFirst();
    }

    private FailedTaskRunWithLog newAttemptsTaskRunForFailedExecution(TaskRun taskRun, Exception e) {
        return new FailedTaskRunWithLog(taskRun.withAttempts(Collections.singletonList(TaskRunAttempt.builder().state(new State()).build().withState(State.Type.FAILED))).withState(State.Type.FAILED), RunContextLogger.logEntries(Execution.loggingEventFromException(e), LogEntry.of(taskRun, this.kind)));
    }

    private FailedTaskRunWithLog lastAttemptsTaskRunForFailedExecution(TaskRun taskRun, TaskRunAttempt lastAttempt, Exception e) {
        return new FailedTaskRunWithLog(taskRun.withAttempts(Stream.concat(taskRun.getAttempts().stream().limit(taskRun.getAttempts().size() - 1), Stream.of(lastAttempt.withState(State.Type.FAILED))).toList()).withState(State.Type.FAILED), RunContextLogger.logEntries(Execution.loggingEventFromException(e), LogEntry.of(taskRun, this.kind)));
    }

    public static ILoggingEvent loggingEventFromException(Throwable e) {
        LoggingEvent loggingEvent = new LoggingEvent();
        loggingEvent.setLevel(Level.ERROR);
        loggingEvent.setThrowableProxy(new ThrowableProxy(e));
        loggingEvent.setMessage(e.getMessage());
        loggingEvent.setThreadName(Thread.currentThread().getName());
        loggingEvent.setTimeStamp(Instant.now().toEpochMilli());
        loggingEvent.setLoggerName(Execution.class.getName());
        return loggingEvent;
    }

    public Map<String, Object> outputs() {
        if (this.taskRunList == null) {
            return ImmutableMap.of();
        }
        Map<String, TaskRun> byIds = this.taskRunList.stream().collect(Collectors.toMap(taskRun -> taskRun.getId(), taskRun -> taskRun));
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.taskRunList.stream().filter(taskRun -> taskRun.getOutputs() != null).collect(Collectors.groupingBy(taskRun -> taskRun.getTaskId())).forEach((taskId, taskRuns) -> {
            Map<String, Object> taskOutputs = new HashMap<String, Object>();
            for (TaskRun current : taskRuns) {
                if (MapUtils.isEmpty(current.getOutputs())) continue;
                if (current.getIteration() != null) {
                    taskOutputs = MapUtils.merge(taskOutputs, this.outputs(current, byIds));
                    continue;
                }
                taskOutputs.putAll(this.outputs(current, byIds));
            }
            result.put((String)taskId, taskOutputs);
        });
        return result;
    }

    private Map<String, Object> outputs(TaskRun taskRun, Map<String, TaskRun> byIds) {
        HashMap<String, Object> result;
        List<TaskRun> parents = this.findParents(taskRun, byIds).stream().filter(r -> r.getValue() != null).toList();
        if (parents.isEmpty()) {
            if (taskRun.getValue() == null) {
                return taskRun.getOutputs();
            }
            return Map.of(taskRun.getValue(), taskRun.getOutputs());
        }
        HashMap<String, Object> current = result = HashMap.newHashMap(1);
        for (TaskRun t : parents) {
            HashMap item = HashMap.newHashMap(1);
            current.put(t.getValue(), item);
            current = item;
        }
        if (taskRun.getOutputs() != null) {
            if (taskRun.getValue() != null) {
                current.put(taskRun.getValue(), taskRun.getOutputs());
            } else {
                current.putAll(taskRun.getOutputs());
            }
        }
        return result;
    }

    public List<Map<String, Object>> parents(TaskRun taskRun) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<TaskRun> parents = this.findParents(taskRun);
        Collections.reverse(parents);
        for (TaskRun childTaskRun : parents) {
            HashMap<String, Map<String, String>> current = new HashMap<String, Map<String, String>>();
            if (childTaskRun.getValue() != null) {
                current.put("taskrun", Map.of("value", childTaskRun.getValue()));
            }
            if (childTaskRun.getOutputs() != null && !childTaskRun.getOutputs().isEmpty()) {
                current.put("outputs", childTaskRun.getOutputs());
            }
            if (current.isEmpty()) continue;
            result.add(current);
        }
        return result;
    }

    public List<TaskRun> findParents(TaskRun taskRun) {
        if (taskRun.getParentTaskRunId() == null || this.taskRunList == null) {
            return Collections.emptyList();
        }
        ArrayList<TaskRun> result = new ArrayList<TaskRun>();
        boolean ended = false;
        while (!ended) {
            TaskRun finalTaskRun = taskRun;
            Optional<TaskRun> find = this.taskRunList.stream().filter(t -> t.getId().equals(finalTaskRun.getParentTaskRunId())).findFirst();
            if (find.isPresent()) {
                result.add(find.get());
                taskRun = find.get();
                continue;
            }
            ended = true;
        }
        Collections.reverse(result);
        return result;
    }

    private List<TaskRun> findParents(TaskRun taskRun, Map<String, TaskRun> taskRunById) {
        if (taskRun.getParentTaskRunId() == null || taskRunById.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TaskRun> result = new ArrayList<TaskRun>();
        boolean ended = false;
        while (!ended) {
            TaskRun finalTaskRun = taskRun;
            TaskRun find = taskRunById.get(finalTaskRun.getParentTaskRunId());
            if (find != null) {
                result.add(find);
                taskRun = find;
                continue;
            }
            ended = true;
        }
        Collections.reverse(result);
        return result;
    }

    public List<TaskRun> findChildren(TaskRun parentTaskRun) {
        return this.taskRunList.stream().filter(taskRun -> parentTaskRun.getId().equals(taskRun.getParentTaskRunId())).toList();
    }

    public List<String> findParentsValues(TaskRun taskRun, boolean withCurrent) {
        return (withCurrent ? Stream.concat(this.findParents(taskRun).stream(), Stream.of(taskRun)) : this.findParents(taskRun).stream()).filter(t -> t.getValue() != null).map(TaskRun::getValue).toList();
    }

    public Execution toDeleted() {
        return this.toBuilder().deleted(true).build();
    }

    public String toString(boolean pretty) {
        if (!pretty) {
            return super.toString();
        }
        return "Execution(\n  id=" + this.getId() + "\n  flowId=" + this.getFlowId() + "\n  state=" + this.getState().getCurrent().toString() + "\n  taskRunList=\n  [\n    " + (this.taskRunList == null ? "" : this.taskRunList.stream().map(t -> t.toString(true)).collect(Collectors.joining(",\n    "))) + "\n  ], \n  inputs=" + String.valueOf(this.getInputs()) + "\n)";
    }

    public String toStringState() {
        return "(\n  state=" + this.getState().getCurrent().toString() + "\n  taskRunList=\n  [\n    " + (this.taskRunList == null ? "" : this.taskRunList.stream().map(TaskRun::toStringState).collect(Collectors.joining(",\n    "))) + "\n  ] \n)";
    }

    public Long toCrc32State() {
        CRC32 crc32 = new CRC32();
        crc32.update(this.toStringState().getBytes());
        return crc32.getValue();
    }

    @Generated
    private static boolean $default$deleted() {
        return false;
    }

    @Generated
    public ExecutionBuilder toBuilder() {
        return new ExecutionBuilder().tenantId(this.tenantId).id(this.id).namespace(this.namespace).flowId(this.flowId).flowRevision(this.flowRevision).taskRunList(this.taskRunList).inputs(this.inputs).outputs(this.outputs).labels(this.labels).variables(this.variables).state(this.state).parentId(this.parentId).originalId(this.originalId).trigger(this.trigger).deleted(this.deleted).metadata(this.metadata).scheduleDate(this.scheduleDate).traceParent(this.traceParent).fixtures(this.fixtures).kind(this.kind).breakpoints(this.breakpoints);
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public Integer getFlowRevision() {
        return this.flowRevision;
    }

    @Generated
    public List<TaskRun> getTaskRunList() {
        return this.taskRunList;
    }

    @Generated
    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    @Generated
    public Map<String, Object> getOutputs() {
        return this.outputs;
    }

    @Generated
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public String getParentId() {
        return this.parentId;
    }

    @Generated
    public String getOriginalId() {
        return this.originalId;
    }

    @Generated
    public ExecutionTrigger getTrigger() {
        return this.trigger;
    }

    @Override
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public ExecutionMetadata getMetadata() {
        return this.metadata;
    }

    @Nullable
    @Generated
    public Instant getScheduleDate() {
        return this.scheduleDate;
    }

    @Generated
    public String getTraceParent() {
        return this.traceParent;
    }

    @Nullable
    @Generated
    public List<TaskFixture> getFixtures() {
        return this.fixtures;
    }

    @Nullable
    @Generated
    public ExecutionKind getKind() {
        return this.kind;
    }

    @Nullable
    @Generated
    public List<Breakpoint> getBreakpoints() {
        return this.breakpoints;
    }

    @ConstructorProperties(value={"tenantId", "id", "namespace", "flowId", "flowRevision", "taskRunList", "inputs", "outputs", "labels", "variables", "state", "parentId", "originalId", "trigger", "deleted", "metadata", "scheduleDate", "traceParent", "fixtures", "kind", "breakpoints"})
    @Generated
    public Execution(String tenantId, String id, String namespace, String flowId, Integer flowRevision, List<TaskRun> taskRunList, Map<String, Object> inputs, Map<String, Object> outputs, List<Label> labels, Map<String, Object> variables, State state, String parentId, String originalId, ExecutionTrigger trigger, boolean deleted, ExecutionMetadata metadata, @Nullable Instant scheduleDate, String traceParent, @Nullable List<TaskFixture> fixtures, @Nullable ExecutionKind kind, @Nullable List<Breakpoint> breakpoints) {
        this.tenantId = tenantId;
        this.id = id;
        this.namespace = namespace;
        this.flowId = flowId;
        this.flowRevision = flowRevision;
        this.taskRunList = taskRunList;
        this.inputs = inputs;
        this.outputs = outputs;
        this.labels = labels;
        this.variables = variables;
        this.state = state;
        this.parentId = parentId;
        this.originalId = originalId;
        this.trigger = trigger;
        this.deleted = deleted;
        this.metadata = metadata;
        this.scheduleDate = scheduleDate;
        this.traceParent = traceParent;
        this.fixtures = fixtures;
        this.kind = kind;
        this.breakpoints = breakpoints;
    }

    @Generated
    public String toString() {
        return "Execution(tenantId=" + this.getTenantId() + ", id=" + this.getId() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", flowRevision=" + this.getFlowRevision() + ", taskRunList=" + String.valueOf(this.getTaskRunList()) + ", inputs=" + String.valueOf(this.getInputs()) + ", outputs=" + String.valueOf(this.getOutputs()) + ", labels=" + String.valueOf(this.getLabels()) + ", variables=" + String.valueOf(this.getVariables()) + ", state=" + String.valueOf(this.getState()) + ", parentId=" + this.getParentId() + ", originalId=" + this.getOriginalId() + ", trigger=" + String.valueOf(this.getTrigger()) + ", deleted=" + this.isDeleted() + ", metadata=" + String.valueOf(this.getMetadata()) + ", scheduleDate=" + String.valueOf(this.getScheduleDate()) + ", traceParent=" + this.getTraceParent() + ", fixtures=" + String.valueOf(this.getFixtures()) + ", kind=" + String.valueOf((Object)this.getKind()) + ", breakpoints=" + String.valueOf(this.getBreakpoints()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Execution)) {
            return false;
        }
        Execution other = (Execution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Integer this$flowRevision = this.getFlowRevision();
        Integer other$flowRevision = other.getFlowRevision();
        if (this$flowRevision == null ? other$flowRevision != null : !((Object)this$flowRevision).equals(other$flowRevision)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        List<TaskRun> this$taskRunList = this.getTaskRunList();
        List<TaskRun> other$taskRunList = other.getTaskRunList();
        if (this$taskRunList == null ? other$taskRunList != null : !((Object)this$taskRunList).equals(other$taskRunList)) {
            return false;
        }
        Map<String, Object> this$inputs = this.getInputs();
        Map<String, Object> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Map<String, Object> this$outputs = this.getOutputs();
        Map<String, Object> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        List<Label> this$labels = this.getLabels();
        List<Label> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Map<String, Object> this$variables = this.getVariables();
        Map<String, Object> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        String this$originalId = this.getOriginalId();
        String other$originalId = other.getOriginalId();
        if (this$originalId == null ? other$originalId != null : !this$originalId.equals(other$originalId)) {
            return false;
        }
        ExecutionTrigger this$trigger = this.getTrigger();
        ExecutionTrigger other$trigger = other.getTrigger();
        if (this$trigger == null ? other$trigger != null : !((Object)this$trigger).equals(other$trigger)) {
            return false;
        }
        ExecutionMetadata this$metadata = this.getMetadata();
        ExecutionMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        Instant this$scheduleDate = this.getScheduleDate();
        Instant other$scheduleDate = other.getScheduleDate();
        if (this$scheduleDate == null ? other$scheduleDate != null : !((Object)this$scheduleDate).equals(other$scheduleDate)) {
            return false;
        }
        String this$traceParent = this.getTraceParent();
        String other$traceParent = other.getTraceParent();
        if (this$traceParent == null ? other$traceParent != null : !this$traceParent.equals(other$traceParent)) {
            return false;
        }
        List<TaskFixture> this$fixtures = this.getFixtures();
        List<TaskFixture> other$fixtures = other.getFixtures();
        if (this$fixtures == null ? other$fixtures != null : !((Object)this$fixtures).equals(other$fixtures)) {
            return false;
        }
        ExecutionKind this$kind = this.getKind();
        ExecutionKind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        List<Breakpoint> this$breakpoints = this.getBreakpoints();
        List<Breakpoint> other$breakpoints = other.getBreakpoints();
        return !(this$breakpoints == null ? other$breakpoints != null : !((Object)this$breakpoints).equals(other$breakpoints));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Execution;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Integer $flowRevision = this.getFlowRevision();
        result = result * 59 + ($flowRevision == null ? 43 : ((Object)$flowRevision).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        List<TaskRun> $taskRunList = this.getTaskRunList();
        result = result * 59 + ($taskRunList == null ? 43 : ((Object)$taskRunList).hashCode());
        Map<String, Object> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Map<String, Object> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        List<Label> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Map<String, Object> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        String $originalId = this.getOriginalId();
        result = result * 59 + ($originalId == null ? 43 : $originalId.hashCode());
        ExecutionTrigger $trigger = this.getTrigger();
        result = result * 59 + ($trigger == null ? 43 : ((Object)$trigger).hashCode());
        ExecutionMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        Instant $scheduleDate = this.getScheduleDate();
        result = result * 59 + ($scheduleDate == null ? 43 : ((Object)$scheduleDate).hashCode());
        String $traceParent = this.getTraceParent();
        result = result * 59 + ($traceParent == null ? 43 : $traceParent.hashCode());
        List<TaskFixture> $fixtures = this.getFixtures();
        result = result * 59 + ($fixtures == null ? 43 : ((Object)$fixtures).hashCode());
        ExecutionKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        List<Breakpoint> $breakpoints = this.getBreakpoints();
        result = result * 59 + ($breakpoints == null ? 43 : ((Object)$breakpoints).hashCode());
        return result;
    }

    @Generated
    public Execution withTenantId(String tenantId) {
        return this.tenantId == tenantId ? this : new Execution(tenantId, this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, this.outputs, this.labels, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted, this.metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
    }

    @Generated
    public Execution withFlowRevision(Integer flowRevision) {
        return this.flowRevision == flowRevision ? this : new Execution(this.tenantId, this.id, this.namespace, this.flowId, flowRevision, this.taskRunList, this.inputs, this.outputs, this.labels, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted, this.metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
    }

    @Generated
    public Execution withTaskRunList(List<TaskRun> taskRunList) {
        return this.taskRunList == taskRunList ? this : new Execution(this.tenantId, this.id, this.namespace, this.flowId, this.flowRevision, taskRunList, this.inputs, this.outputs, this.labels, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted, this.metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
    }

    @Generated
    public Execution withInputs(Map<String, Object> inputs) {
        return this.inputs == inputs ? this : new Execution(this.tenantId, this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, inputs, this.outputs, this.labels, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted, this.metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
    }

    @Generated
    public Execution withOutputs(Map<String, Object> outputs) {
        return this.outputs == outputs ? this : new Execution(this.tenantId, this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, outputs, this.labels, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted, this.metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
    }

    @Generated
    public Execution withVariables(Map<String, Object> variables) {
        return this.variables == variables ? this : new Execution(this.tenantId, this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, this.outputs, this.labels, variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted, this.metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
    }

    @Generated
    public Execution withTrigger(ExecutionTrigger trigger) {
        return this.trigger == trigger ? this : new Execution(this.tenantId, this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, this.outputs, this.labels, this.variables, this.state, this.parentId, this.originalId, trigger, this.deleted, this.metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
    }

    @Generated
    public Execution withMetadata(ExecutionMetadata metadata) {
        return this.metadata == metadata ? this : new Execution(this.tenantId, this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, this.outputs, this.labels, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted, metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
    }

    @Generated
    public Execution withScheduleDate(@Nullable Instant scheduleDate) {
        return this.scheduleDate == scheduleDate ? this : new Execution(this.tenantId, this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, this.outputs, this.labels, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted, this.metadata, scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
    }

    @Generated
    public void setTraceParent(String traceParent) {
        this.traceParent = traceParent;
    }

    @Generated
    public Execution withFixtures(@Nullable List<TaskFixture> fixtures) {
        return this.fixtures == fixtures ? this : new Execution(this.tenantId, this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, this.outputs, this.labels, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted, this.metadata, this.scheduleDate, this.traceParent, fixtures, this.kind, this.breakpoints);
    }

    public static class ExecutionBuilder {
        @Generated
        private String tenantId;
        @Generated
        private String id;
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private Integer flowRevision;
        @Generated
        private List<TaskRun> taskRunList;
        @Generated
        private Map<String, Object> inputs;
        @Generated
        private Map<String, Object> outputs;
        @Generated
        private List<Label> labels;
        @Generated
        private Map<String, Object> variables;
        @Generated
        private State state;
        @Generated
        private String parentId;
        @Generated
        private String originalId;
        @Generated
        private ExecutionTrigger trigger;
        @Generated
        private boolean deleted$set;
        @Generated
        private boolean deleted$value;
        @Generated
        private ExecutionMetadata metadata;
        @Generated
        private Instant scheduleDate;
        @Generated
        private String traceParent;
        @Generated
        private List<TaskFixture> fixtures;
        @Generated
        private ExecutionKind kind;
        @Generated
        private List<Breakpoint> breakpoints;

        public ExecutionBuilder labels(List<Label> labels) {
            this.labels = Label.deduplicate(labels);
            return this;
        }

        void prebuild() {
            this.originalId = this.id;
            this.metadata = ExecutionMetadata.builder().originalCreatedDate(Instant.now()).build();
        }

        @Generated
        ExecutionBuilder() {
        }

        @Generated
        public ExecutionBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public ExecutionBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ExecutionBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public ExecutionBuilder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        @Generated
        public ExecutionBuilder flowRevision(Integer flowRevision) {
            this.flowRevision = flowRevision;
            return this;
        }

        @Generated
        public ExecutionBuilder taskRunList(List<TaskRun> taskRunList) {
            this.taskRunList = taskRunList;
            return this;
        }

        @Generated
        public ExecutionBuilder inputs(Map<String, Object> inputs) {
            this.inputs = inputs;
            return this;
        }

        @Generated
        public ExecutionBuilder outputs(Map<String, Object> outputs) {
            this.outputs = outputs;
            return this;
        }

        @Generated
        public ExecutionBuilder variables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        @Generated
        public ExecutionBuilder state(State state) {
            this.state = state;
            return this;
        }

        @Generated
        public ExecutionBuilder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        @Generated
        public ExecutionBuilder originalId(String originalId) {
            this.originalId = originalId;
            return this;
        }

        @Generated
        public ExecutionBuilder trigger(ExecutionTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        @Generated
        public ExecutionBuilder deleted(boolean deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return this;
        }

        @Generated
        public ExecutionBuilder metadata(ExecutionMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public ExecutionBuilder scheduleDate(@Nullable Instant scheduleDate) {
            this.scheduleDate = scheduleDate;
            return this;
        }

        @Generated
        public ExecutionBuilder traceParent(String traceParent) {
            this.traceParent = traceParent;
            return this;
        }

        @Generated
        public ExecutionBuilder fixtures(@Nullable List<TaskFixture> fixtures) {
            this.fixtures = fixtures;
            return this;
        }

        @Generated
        public ExecutionBuilder kind(@Nullable ExecutionKind kind) {
            this.kind = kind;
            return this;
        }

        @Generated
        public ExecutionBuilder breakpoints(@Nullable List<Breakpoint> breakpoints) {
            this.breakpoints = breakpoints;
            return this;
        }

        @Generated
        public Execution build() {
            boolean deleted$value = this.deleted$value;
            if (!this.deleted$set) {
                deleted$value = Execution.$default$deleted();
            }
            return new Execution(this.tenantId, this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, this.outputs, this.labels, this.variables, this.state, this.parentId, this.originalId, this.trigger, deleted$value, this.metadata, this.scheduleDate, this.traceParent, this.fixtures, this.kind, this.breakpoints);
        }

        @Generated
        public String toString() {
            return "Execution.ExecutionBuilder(tenantId=" + this.tenantId + ", id=" + this.id + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", flowRevision=" + this.flowRevision + ", taskRunList=" + String.valueOf(this.taskRunList) + ", inputs=" + String.valueOf(this.inputs) + ", outputs=" + String.valueOf(this.outputs) + ", labels=" + String.valueOf(this.labels) + ", variables=" + String.valueOf(this.variables) + ", state=" + String.valueOf(this.state) + ", parentId=" + this.parentId + ", originalId=" + this.originalId + ", trigger=" + String.valueOf(this.trigger) + ", deleted$value=" + this.deleted$value + ", metadata=" + String.valueOf(this.metadata) + ", scheduleDate=" + String.valueOf(this.scheduleDate) + ", traceParent=" + this.traceParent + ", fixtures=" + String.valueOf(this.fixtures) + ", kind=" + String.valueOf((Object)this.kind) + ", breakpoints=" + String.valueOf(this.breakpoints) + ")";
        }
    }

    private static class CustomExecutionBuilder
    extends ExecutionBuilder {
        private CustomExecutionBuilder() {
        }

        @Override
        public Execution build() {
            this.prebuild();
            return super.build();
        }
    }

    public static final class FailedExecutionWithLog {
        private final Execution execution;
        private final List<LogEntry> logs;

        @ConstructorProperties(value={"execution", "logs"})
        @Generated
        FailedExecutionWithLog(Execution execution, List<LogEntry> logs) {
            this.execution = execution;
            this.logs = logs;
        }

        @Generated
        public static FailedExecutionWithLogBuilder builder() {
            return new FailedExecutionWithLogBuilder();
        }

        @Generated
        public Execution getExecution() {
            return this.execution;
        }

        @Generated
        public List<LogEntry> getLogs() {
            return this.logs;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FailedExecutionWithLog)) {
                return false;
            }
            FailedExecutionWithLog other = (FailedExecutionWithLog)o;
            Execution this$execution = this.getExecution();
            Execution other$execution = other.getExecution();
            if (this$execution == null ? other$execution != null : !((Object)this$execution).equals(other$execution)) {
                return false;
            }
            List<LogEntry> this$logs = this.getLogs();
            List<LogEntry> other$logs = other.getLogs();
            return !(this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Execution $execution = this.getExecution();
            result = result * 59 + ($execution == null ? 43 : ((Object)$execution).hashCode());
            List<LogEntry> $logs = this.getLogs();
            result = result * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Execution.FailedExecutionWithLog(execution=" + String.valueOf(this.getExecution()) + ", logs=" + String.valueOf(this.getLogs()) + ")";
        }

        @Generated
        public static class FailedExecutionWithLogBuilder {
            @Generated
            private Execution execution;
            @Generated
            private List<LogEntry> logs;

            @Generated
            FailedExecutionWithLogBuilder() {
            }

            @Generated
            public FailedExecutionWithLogBuilder execution(Execution execution) {
                this.execution = execution;
                return this;
            }

            @Generated
            public FailedExecutionWithLogBuilder logs(List<LogEntry> logs) {
                this.logs = logs;
                return this;
            }

            @Generated
            public FailedExecutionWithLog build() {
                return new FailedExecutionWithLog(this.execution, this.logs);
            }

            @Generated
            public String toString() {
                return "Execution.FailedExecutionWithLog.FailedExecutionWithLogBuilder(execution=" + String.valueOf(this.execution) + ", logs=" + String.valueOf(this.logs) + ")";
            }
        }
    }

    public static final class FailedTaskRunWithLog {
        private final TaskRun taskRun;
        private final List<LogEntry> logs;

        @ConstructorProperties(value={"taskRun", "logs"})
        @Generated
        public FailedTaskRunWithLog(TaskRun taskRun, List<LogEntry> logs) {
            this.taskRun = taskRun;
            this.logs = logs;
        }

        @Generated
        public TaskRun getTaskRun() {
            return this.taskRun;
        }

        @Generated
        public List<LogEntry> getLogs() {
            return this.logs;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FailedTaskRunWithLog)) {
                return false;
            }
            FailedTaskRunWithLog other = (FailedTaskRunWithLog)o;
            TaskRun this$taskRun = this.getTaskRun();
            TaskRun other$taskRun = other.getTaskRun();
            if (this$taskRun == null ? other$taskRun != null : !((Object)this$taskRun).equals(other$taskRun)) {
                return false;
            }
            List<LogEntry> this$logs = this.getLogs();
            List<LogEntry> other$logs = other.getLogs();
            return !(this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskRun $taskRun = this.getTaskRun();
            result = result * 59 + ($taskRun == null ? 43 : ((Object)$taskRun).hashCode());
            List<LogEntry> $logs = this.getLogs();
            result = result * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Execution.FailedTaskRunWithLog(taskRun=" + String.valueOf(this.getTaskRun()) + ", logs=" + String.valueOf(this.getLogs()) + ")";
        }
    }
}

