/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.utils.IdUtils;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;

public interface FlowId {
    public String getId();

    public String getNamespace();

    public Integer getRevision();

    public String getTenantId();

    public static String uid(FlowId flow) {
        return FlowId.uid(flow.getTenantId(), flow.getNamespace(), flow.getId(), Optional.ofNullable(flow.getRevision()));
    }

    public static String uid(String tenantId, String namespace, String id, Optional<Integer> revision) {
        return FlowId.of(tenantId, namespace, id, revision.orElse(-1)).toString();
    }

    public static String uidWithoutRevision(FlowId flow) {
        return FlowId.of(flow.getTenantId(), flow.getNamespace(), flow.getId(), null).toString();
    }

    public static String uidWithoutRevision(String tenantId, String namespace, String id) {
        return FlowId.of(tenantId, namespace, id, null).toString();
    }

    public static String uid(Trigger trigger) {
        return FlowId.of(trigger.getTenantId(), trigger.getNamespace(), trigger.getFlowId(), null).toString();
    }

    public static String uidWithoutRevision(Execution execution) {
        return FlowId.of(execution.getTenantId(), execution.getNamespace(), execution.getFlowId(), null).toString();
    }

    public static FlowId of(String tenantId, String namespace, String id, Integer revision) {
        return new Default(tenantId, namespace, id, revision);
    }

    public static class Default
    implements FlowId {
        private final String tenantId;
        private final String namespace;
        private final String id;
        private final Integer revision;

        public String toString() {
            return IdUtils.fromParts(this.tenantId, this.namespace, this.id, Optional.ofNullable(this.revision).map(String::valueOf).orElse(null));
        }

        @Override
        @Generated
        public String getTenantId() {
            return this.tenantId;
        }

        @Override
        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Override
        @Generated
        public Integer getRevision() {
            return this.revision;
        }

        @ConstructorProperties(value={"tenantId", "namespace", "id", "revision"})
        @Generated
        public Default(String tenantId, String namespace, String id, Integer revision) {
            this.tenantId = tenantId;
            this.namespace = namespace;
            this.id = id;
            this.revision = revision;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Default)) {
                return false;
            }
            Default other = (Default)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$revision = this.getRevision();
            Integer other$revision = other.getRevision();
            if (this$revision == null ? other$revision != null : !((Object)this$revision).equals(other$revision)) {
                return false;
            }
            String this$tenantId = this.getTenantId();
            String other$tenantId = other.getTenantId();
            if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Default;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $revision = this.getRevision();
            result = result * 59 + ($revision == null ? 43 : ((Object)$revision).hashCode());
            String $tenantId = this.getTenantId();
            result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }
    }
}

