/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.kestra.core.exceptions.DeserializationException;
import io.kestra.core.models.HasUID;
import io.kestra.core.models.flows.AbstractFlow;
import io.kestra.core.models.flows.Concurrency;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.sla.SLA;
import io.kestra.core.models.tasks.GenericTask;
import io.kestra.core.models.triggers.GenericTrigger;
import io.kestra.core.serializers.YamlParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

@JsonDeserialize
public class GenericFlow
extends AbstractFlow
implements HasUID {
    private String source;
    private List<SLA> sla;
    private Concurrency concurrency;
    private List<GenericTask> tasks;
    private List<GenericTrigger> triggers;
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    public static GenericFlow of(FlowInterface flow) throws DeserializationException {
        return GenericFlow.fromYaml(flow.getTenantId(), flow.sourceOrGenerateIfNull());
    }

    public static GenericFlow fromYaml(String tenantId, String source) throws DeserializationException {
        GenericFlow parsed = YamlParser.parse(source, GenericFlow.class);
        return ((GenericFlowBuilder)((GenericFlowBuilder)parsed.toBuilder().tenantId(tenantId)).source(source)).build();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public List<GenericTask> getTasks() {
        return Optional.ofNullable(this.tasks).orElse(List.of());
    }

    public List<GenericTrigger> getTriggers() {
        return Optional.ofNullable(this.triggers).orElse(List.of());
    }

    @Generated
    private static Map<String, Object> $default$additionalProperties() {
        return new HashMap<String, Object>();
    }

    @Generated
    protected GenericFlow(GenericFlowBuilder<?, ?> b) {
        super(b);
        this.source = b.source;
        this.sla = b.sla;
        this.concurrency = b.concurrency;
        this.tasks = b.tasks;
        this.triggers = b.triggers;
        this.additionalProperties = b.additionalProperties$set ? b.additionalProperties$value : GenericFlow.$default$additionalProperties();
    }

    @Generated
    public static GenericFlowBuilder<?, ?> builder() {
        return new GenericFlowBuilderImpl();
    }

    @Generated
    public GenericFlowBuilder<?, ?> toBuilder() {
        return new GenericFlowBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getSource() {
        return this.source;
    }

    @Override
    @Generated
    public List<SLA> getSla() {
        return this.sla;
    }

    @Override
    @Generated
    public Concurrency getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public GenericFlow() {
        this.additionalProperties = GenericFlow.$default$additionalProperties();
    }

    @Generated
    public static abstract class GenericFlowBuilder<C extends GenericFlow, B extends GenericFlowBuilder<C, B>>
    extends AbstractFlow.AbstractFlowBuilder<C, B> {
        @Generated
        private String source;
        @Generated
        private List<SLA> sla;
        @Generated
        private Concurrency concurrency;
        @Generated
        private List<GenericTask> tasks;
        @Generated
        private List<GenericTrigger> triggers;
        @Generated
        private boolean additionalProperties$set;
        @Generated
        private Map<String, Object> additionalProperties$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GenericFlowBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(GenericFlow instance, GenericFlowBuilder<?, ?> b) {
            b.source(instance.source);
            b.sla(instance.sla);
            b.concurrency(instance.concurrency);
            b.tasks(instance.tasks);
            b.triggers(instance.triggers);
            b.additionalProperties(instance.additionalProperties);
        }

        @Generated
        public B source(String source) {
            this.source = source;
            return (B)this.self();
        }

        @Generated
        public B sla(List<SLA> sla) {
            this.sla = sla;
            return (B)this.self();
        }

        @Generated
        public B concurrency(Concurrency concurrency) {
            this.concurrency = concurrency;
            return (B)this.self();
        }

        @Generated
        public B tasks(List<GenericTask> tasks) {
            this.tasks = tasks;
            return (B)this.self();
        }

        @Generated
        public B triggers(List<GenericTrigger> triggers) {
            this.triggers = triggers;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B additionalProperties(Map<String, Object> additionalProperties) {
            this.additionalProperties$value = additionalProperties;
            this.additionalProperties$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "GenericFlow.GenericFlowBuilder(super=" + super.toString() + ", source=" + this.source + ", sla=" + String.valueOf(this.sla) + ", concurrency=" + String.valueOf(this.concurrency) + ", tasks=" + String.valueOf(this.tasks) + ", triggers=" + String.valueOf(this.triggers) + ", additionalProperties$value=" + String.valueOf(this.additionalProperties$value) + ")";
        }
    }

    @Generated
    private static final class GenericFlowBuilderImpl
    extends GenericFlowBuilder<GenericFlow, GenericFlowBuilderImpl> {
        @Generated
        private GenericFlowBuilderImpl() {
        }

        @Override
        @Generated
        protected GenericFlowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GenericFlow build() {
            return new GenericFlow(this);
        }
    }
}

