/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.kestra.core.models.tasks.Task;
import io.micronaut.core.annotation.Introspected;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Introspected
public final class State {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(State.class);
    @NotNull
    @JsonInclude
    private final Type current;
    @Valid
    private final List<History> histories;

    public State() {
        this.current = Type.CREATED;
        this.histories = new ArrayList<History>();
        this.histories.add(new History(this.current, Instant.now()));
    }

    public State(Type type) {
        this.current = type;
        this.histories = new ArrayList<History>();
        this.histories.add(new History(this.current, Instant.now()));
    }

    public State(State state, Type type) {
        this.current = type;
        this.histories = state.histories;
        this.histories.add(new History(this.current, Instant.now()));
    }

    public State(Type state, State actual) {
        this.current = state;
        this.histories = new ArrayList<History>(actual.histories);
        this.histories.add(new History(this.current, Instant.now()));
    }

    public State(Type type, List<History> histories) {
        this.current = type;
        this.histories = histories;
    }

    public static State of(Type state, List<History> histories) {
        State result = new State(state);
        result.histories.removeIf(history -> true);
        result.histories.addAll(histories);
        return result;
    }

    public State withState(Type state) {
        if (this.current == state) {
            log.warn("Can't change state, already {}", (Object)this.current);
            return this;
        }
        return new State(state, this);
    }

    public State reset() {
        return new State(Type.CREATED, List.of(this.histories.getFirst()));
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public Duration getDuration() {
        return Duration.between(this.histories.getFirst().getDate(), this.histories.size() > 1 ? this.histories.get(this.histories.size() - 1).getDate() : Instant.now());
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public Instant getStartDate() {
        return this.histories.getFirst().getDate();
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Optional<Instant> getEndDate() {
        if (!this.isTerminated() && !this.isPaused()) {
            return Optional.empty();
        }
        return Optional.of(this.histories.get(this.histories.size() - 1).getDate());
    }

    public String humanDuration() {
        try {
            return DurationFormatUtils.formatDurationHMS((long)this.getDuration().toMillis());
        }
        catch (Throwable e) {
            return this.getDuration().toString();
        }
    }

    public Instant maxDate() {
        if (this.histories.isEmpty()) {
            return Instant.now();
        }
        return this.histories.get(this.histories.size() - 1).getDate();
    }

    public Instant minDate() {
        if (this.histories.isEmpty()) {
            return Instant.now();
        }
        return this.histories.getFirst().getDate();
    }

    @JsonIgnore
    public boolean isTerminated() {
        return this.current.isTerminated();
    }

    @JsonIgnore
    public boolean isTerminatedNoFail() {
        return this.current.isTerminatedNoFail();
    }

    @JsonIgnore
    public boolean isRunning() {
        return this.current.isRunning();
    }

    @JsonIgnore
    public boolean isCreated() {
        return this.current.isCreated();
    }

    @JsonIgnore
    public static Type[] runningTypes() {
        return (Type[])Arrays.stream(Type.values()).filter(type -> type.isRunning() || type.isCreated()).toArray(Type[]::new);
    }

    @JsonIgnore
    public boolean isFailed() {
        return this.current.isFailed();
    }

    @JsonIgnore
    public boolean isPaused() {
        return this.current.isPaused();
    }

    @JsonIgnore
    public boolean isBreakpoint() {
        return this.current.isBreakpoint();
    }

    @JsonIgnore
    public boolean isQueued() {
        return this.current.isQueued();
    }

    @JsonIgnore
    public boolean isRetrying() {
        return this.current.isRetrying();
    }

    @JsonIgnore
    public boolean isSuccess() {
        return this.current.isSuccess();
    }

    @JsonIgnore
    public boolean isRestartable() {
        return this.current.isFailed() || this.isPaused();
    }

    @JsonIgnore
    public boolean isResumable() {
        return this.current.isPaused() || this.current.isRetrying() || this.current.isCreated();
    }

    @JsonIgnore
    public boolean isResumingAfterPause() {
        if (!this.current.equals((Object)Type.RESTARTED) || this.histories.size() < 2) {
            return false;
        }
        return this.histories.get((int)(this.histories.size() - 2)).state.isPaused();
    }

    public boolean failedThenRestarted() {
        return this.current == Type.RESTARTED && this.histories.get((int)(this.histories.size() - 2)).state.isFailed();
    }

    @Generated
    public Type getCurrent() {
        return this.current;
    }

    @Generated
    public List<History> getHistories() {
        return this.histories;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State other = (State)o;
        Type this$current = this.getCurrent();
        Type other$current = other.getCurrent();
        if (this$current == null ? other$current != null : !((Object)((Object)this$current)).equals((Object)other$current)) {
            return false;
        }
        List<History> this$histories = this.getHistories();
        List<History> other$histories = other.getHistories();
        return !(this$histories == null ? other$histories != null : !((Object)this$histories).equals(other$histories));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $current = this.getCurrent();
        result = result * 59 + ($current == null ? 43 : ((Object)((Object)$current)).hashCode());
        List<History> $histories = this.getHistories();
        result = result * 59 + ($histories == null ? 43 : ((Object)$histories).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "State(current=" + String.valueOf((Object)this.getCurrent()) + ", histories=" + String.valueOf(this.getHistories()) + ")";
    }

    @Introspected
    public static enum Type {
        CREATED,
        RUNNING,
        PAUSED,
        RESTARTED,
        KILLING,
        SUCCESS,
        WARNING,
        FAILED,
        KILLED,
        CANCELLED,
        QUEUED,
        RETRYING,
        RETRIED,
        SKIPPED,
        BREAKPOINT;


        public boolean isTerminated() {
            return this == FAILED || this == WARNING || this == SUCCESS || this == KILLED || this == CANCELLED || this == RETRIED || this == SKIPPED;
        }

        public boolean isTerminatedNoFail() {
            return this == WARNING || this == SUCCESS || this == RETRIED || this == SKIPPED;
        }

        public boolean isCreated() {
            return this == CREATED || this == RESTARTED;
        }

        public boolean isRunning() {
            return this == RUNNING || this == KILLING;
        }

        public boolean isFailed() {
            return this == FAILED;
        }

        public boolean isPaused() {
            return this == PAUSED;
        }

        public boolean isBreakpoint() {
            return this == BREAKPOINT;
        }

        public boolean isRetrying() {
            return this == RETRYING || this == RETRIED;
        }

        public boolean isSuccess() {
            return this == SUCCESS;
        }

        public boolean isKilled() {
            return this == KILLED;
        }

        public boolean isQueued() {
            return this == QUEUED;
        }

        public static List<Type> terminatedTypes() {
            return Stream.of(Type.values()).filter(type -> type.isTerminated()).toList();
        }

        public static Type fail(Task task) {
            return task.isAllowFailure() ? (task.isAllowWarning() ? SUCCESS : WARNING) : FAILED;
        }
    }

    public static final class History {
        @NotNull
        private final Type state;
        @NotNull
        private final Instant date;

        @ConstructorProperties(value={"state", "date"})
        @Generated
        public History(Type state, Instant date) {
            this.state = state;
            this.date = date;
        }

        @Generated
        public Type getState() {
            return this.state;
        }

        @Generated
        public Instant getDate() {
            return this.date;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof History)) {
                return false;
            }
            History other = (History)o;
            Type this$state = this.getState();
            Type other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
                return false;
            }
            Instant this$date = this.getDate();
            Instant other$date = other.getDate();
            return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            Instant $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "State.History(state=" + String.valueOf((Object)this.getState()) + ", date=" + String.valueOf(this.getDate()) + ")";
        }
    }
}

