/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.input;

import io.kestra.core.models.flows.Input;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.ConstraintViolationException;
import java.time.Instant;
import lombok.Generated;

public class DateTimeInput
extends Input<Instant> {
    @Schema(title="Minimal value.")
    Instant after;
    @Schema(title="Maximal value.")
    Instant before;

    @Override
    public void validate(Instant input) throws ConstraintViolationException {
        if (this.after != null && input.isBefore(this.after)) {
            throw ManualConstraintViolation.toConstraintViolationException("it must be after `" + String.valueOf(this.after) + "`", this, DateTimeInput.class, this.getId(), input);
        }
        if (this.before != null && input.isAfter(this.before)) {
            throw ManualConstraintViolation.toConstraintViolationException("it must be before `" + String.valueOf(this.before) + "`", this, DateTimeInput.class, this.getId(), input);
        }
    }

    @Generated
    protected DateTimeInput(DateTimeInputBuilder<?, ?> b) {
        super(b);
        this.after = b.after;
        this.before = b.before;
    }

    @Generated
    public static DateTimeInputBuilder<?, ?> builder() {
        return new DateTimeInputBuilderImpl();
    }

    @Generated
    public Instant getAfter() {
        return this.after;
    }

    @Generated
    public Instant getBefore() {
        return this.before;
    }

    @Generated
    public DateTimeInput() {
    }

    @Generated
    public static abstract class DateTimeInputBuilder<C extends DateTimeInput, B extends DateTimeInputBuilder<C, B>>
    extends Input.InputBuilder<Instant, C, B> {
        @Generated
        private Instant after;
        @Generated
        private Instant before;

        @Generated
        public B after(Instant after) {
            this.after = after;
            return (B)this.self();
        }

        @Generated
        public B before(Instant before) {
            this.before = before;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DateTimeInput.DateTimeInputBuilder(super=" + super.toString() + ", after=" + String.valueOf(this.after) + ", before=" + String.valueOf(this.before) + ")";
        }
    }

    @Generated
    private static final class DateTimeInputBuilderImpl
    extends DateTimeInputBuilder<DateTimeInput, DateTimeInputBuilderImpl> {
        @Generated
        private DateTimeInputBuilderImpl() {
        }

        @Override
        @Generated
        protected DateTimeInputBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DateTimeInput build() {
            return new DateTimeInput(this);
        }
    }
}

