/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.input;

import io.kestra.core.models.flows.Input;
import io.kestra.core.validations.FileInputValidation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.List;
import lombok.Generated;

@FileInputValidation
public class FileInput
extends Input<URI> {
    private static final String DEFAULT_EXTENSION = ".upl";
    @Deprecated(since="0.24", forRemoval=true)
    public String extension;

    @Override
    public void validate(URI input) throws ConstraintViolationException {
    }

    public static String findFileInputExtension(@NotNull List<Input<?>> inputs, @NotNull String fileName) {
        String res = inputs.stream().filter(in -> in instanceof FileInput).filter(in -> in.getId().equals(fileName)).filter(flowInput -> ((FileInput)flowInput).getExtension() != null).map(flowInput -> ((FileInput)flowInput).getExtension()).findFirst().orElse(DEFAULT_EXTENSION);
        return res.startsWith(".") ? res : "." + res;
    }

    @Generated
    protected FileInput(FileInputBuilder<?, ?> b) {
        super(b);
        this.extension = b.extension;
    }

    @Generated
    public static FileInputBuilder<?, ?> builder() {
        return new FileInputBuilderImpl();
    }

    @Deprecated
    @Generated
    public String getExtension() {
        return this.extension;
    }

    @Generated
    public FileInput() {
    }

    @Generated
    public static abstract class FileInputBuilder<C extends FileInput, B extends FileInputBuilder<C, B>>
    extends Input.InputBuilder<URI, C, B> {
        @Generated
        private String extension;

        @Deprecated
        @Generated
        public B extension(String extension) {
            this.extension = extension;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FileInput.FileInputBuilder(super=" + super.toString() + ", extension=" + this.extension + ")";
        }
    }

    @Generated
    private static final class FileInputBuilderImpl
    extends FileInputBuilder<FileInput, FileInputBuilderImpl> {
        @Generated
        private FileInputBuilderImpl() {
        }

        @Override
        @Generated
        protected FileInputBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FileInput build() {
            return new FileInput(this);
        }
    }
}

