/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.input;

import io.kestra.core.models.flows.Input;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.ConstraintViolationException;
import lombok.Generated;

public class FloatInput
extends Input<Float> {
    @Schema(title="Minimal value.")
    Float min;
    @Schema(title="Maximal value.")
    Float max;

    @Override
    public void validate(Float input) throws ConstraintViolationException {
        if (this.min != null && input.compareTo(this.min) < 0) {
            throw ManualConstraintViolation.toConstraintViolationException("it must be more than `" + this.min + "`", this, FloatInput.class, this.getId(), input);
        }
        if (this.max != null && input.compareTo(this.max) > 0) {
            throw ManualConstraintViolation.toConstraintViolationException("it must be less than `" + this.max + "`", this, FloatInput.class, this.getId(), input);
        }
    }

    @Generated
    protected FloatInput(FloatInputBuilder<?, ?> b) {
        super(b);
        this.min = b.min;
        this.max = b.max;
    }

    @Generated
    public static FloatInputBuilder<?, ?> builder() {
        return new FloatInputBuilderImpl();
    }

    @Generated
    public Float getMin() {
        return this.min;
    }

    @Generated
    public Float getMax() {
        return this.max;
    }

    @Generated
    public FloatInput() {
    }

    @Generated
    public static abstract class FloatInputBuilder<C extends FloatInput, B extends FloatInputBuilder<C, B>>
    extends Input.InputBuilder<Float, C, B> {
        @Generated
        private Float min;
        @Generated
        private Float max;

        @Generated
        public B min(Float min) {
            this.min = min;
            return (B)this.self();
        }

        @Generated
        public B max(Float max) {
            this.max = max;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FloatInput.FloatInputBuilder(super=" + super.toString() + ", min=" + this.min + ", max=" + this.max + ")";
        }
    }

    @Generated
    private static final class FloatInputBuilderImpl
    extends FloatInputBuilder<FloatInput, FloatInputBuilderImpl> {
        @Generated
        private FloatInputBuilderImpl() {
        }

        @Override
        @Generated
        protected FloatInputBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FloatInput build() {
            return new FloatInput(this);
        }
    }
}

