/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.input;

import io.kestra.core.models.flows.Input;
import io.kestra.core.models.flows.RenderableInput;
import io.kestra.core.models.flows.Type;
import io.kestra.core.models.flows.input.ItemTypeInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.validations.Regex;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;

public class MultiselectInput
extends Input<List<String>>
implements ItemTypeInterface,
RenderableInput {
    @Schema(title="Deprecated, please use `values` instead.")
    @Deprecated
    List<@Regex String> options;
    @Schema(title="List of values available.")
    List<@Regex String> values;
    @Schema(title="Expression to be used for dynamically generating the list of values")
    String expression;
    @Schema(title="Type of the different values available.", description="Cannot be of type `ARRAY` nor 'MULTISELECT'.")
    private Type itemType;
    @Schema(title="If the user can provide customs value.")
    @NotNull
    Boolean allowCustomValue;
    @Schema(title="Whether the first value of the multi-select should be selected by default.")
    @NotNull
    Boolean autoSelectFirst;

    @Override
    public Property<List<String>> getDefaults() {
        Property<List<String>> baseDefaults = super.getDefaults();
        if (baseDefaults == null && this.autoSelectFirst.booleanValue() && !Optional.ofNullable(this.values).map(Collection::isEmpty).orElse(true).booleanValue()) {
            return Property.ofValue(List.of(this.values.getFirst()));
        }
        return baseDefaults;
    }

    @Override
    public void validate(List<String> inputs) throws ConstraintViolationException {
        if (this.values != null && this.options != null) {
            throw ManualConstraintViolation.toConstraintViolationException("you can't define both `values` and `options`", this, MultiselectInput.class, this.getId(), "");
        }
        if (!this.getAllowCustomValue().booleanValue()) {
            Iterator<String> iterator = inputs.iterator();
            while (iterator.hasNext()) {
                String input;
                List<@Regex String> finalValues = this.values != null ? this.values : this.options;
                if (finalValues.contains(input = iterator.next())) continue;
                throw ManualConstraintViolation.toConstraintViolationException("it must match the values `" + String.valueOf(finalValues) + "`", this, MultiselectInput.class, this.getId(), input);
            }
        }
    }

    @Override
    public Input<?> render(Function<String, Object> renderer) {
        if (this.expression != null) {
            return ((MultiselectInputBuilder)((MultiselectInputBuilder)((Input.InputBuilder)((MultiselectInputBuilder)((MultiselectInputBuilder)((MultiselectInputBuilder)((MultiselectInputBuilder)((Input.InputBuilder)((MultiselectInputBuilder)((MultiselectInputBuilder)((Input.InputBuilder)MultiselectInput.builder().values(this.renderExpressionValues(renderer))).id(this.getId())).type(this.getType())).allowCustomValue(this.getAllowCustomValue())).required(this.getRequired())).defaults(this.getDefaults())).description(this.getDescription())).dependsOn(this.getDependsOn())).itemType(this.getItemType())).displayName(this.getDisplayName())).autoSelectFirst(this.getAutoSelectFirst())).build();
        }
        return this;
    }

    private List<String> renderExpressionValues(Function<String, Object> renderer) {
        Object result;
        try {
            result = renderer.apply(this.expression.trim());
        }
        catch (Exception e) {
            throw ManualConstraintViolation.toConstraintViolationException("Cannot render 'expression'. Cause: " + e.getMessage(), this, MultiselectInput.class, this.getId(), this);
        }
        if (result instanceof List) {
            List list = (List)result;
            return list.stream().filter(Objects::nonNull).map(Object::toString).toList();
        }
        String type = Optional.ofNullable(result).map(Object::getClass).map(Class::getSimpleName).orElse("<null>");
        throw ManualConstraintViolation.toConstraintViolationException("Invalid expression result. Expected a list of strings, but received " + type, this, MultiselectInput.class, this.getId(), this);
    }

    @Generated
    private static Type $default$itemType() {
        return Type.STRING;
    }

    @Generated
    private static Boolean $default$allowCustomValue() {
        return false;
    }

    @Generated
    private static Boolean $default$autoSelectFirst() {
        return false;
    }

    @Generated
    protected MultiselectInput(MultiselectInputBuilder<?, ?> b) {
        super(b);
        this.options = b.options;
        this.values = b.values;
        this.expression = b.expression;
        this.itemType = b.itemType$set ? b.itemType$value : MultiselectInput.$default$itemType();
        this.allowCustomValue = b.allowCustomValue$set ? b.allowCustomValue$value : MultiselectInput.$default$allowCustomValue();
        this.autoSelectFirst = b.autoSelectFirst$set ? b.autoSelectFirst$value : MultiselectInput.$default$autoSelectFirst();
    }

    @Generated
    public static MultiselectInputBuilder<?, ?> builder() {
        return new MultiselectInputBuilderImpl();
    }

    @Deprecated
    @Generated
    public List<@Regex String> getOptions() {
        return this.options;
    }

    @Generated
    public List<@Regex String> getValues() {
        return this.values;
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Override
    @Generated
    public Type getItemType() {
        return this.itemType;
    }

    @Generated
    public Boolean getAllowCustomValue() {
        return this.allowCustomValue;
    }

    @Generated
    public Boolean getAutoSelectFirst() {
        return this.autoSelectFirst;
    }

    @Generated
    public MultiselectInput() {
        this.itemType = MultiselectInput.$default$itemType();
        this.allowCustomValue = MultiselectInput.$default$allowCustomValue();
        this.autoSelectFirst = MultiselectInput.$default$autoSelectFirst();
    }

    @Generated
    public static abstract class MultiselectInputBuilder<C extends MultiselectInput, B extends MultiselectInputBuilder<C, B>>
    extends Input.InputBuilder<List<String>, C, B> {
        @Generated
        private List<@Regex String> options;
        @Generated
        private List<@Regex String> values;
        @Generated
        private String expression;
        @Generated
        private boolean itemType$set;
        @Generated
        private Type itemType$value;
        @Generated
        private boolean allowCustomValue$set;
        @Generated
        private Boolean allowCustomValue$value;
        @Generated
        private boolean autoSelectFirst$set;
        @Generated
        private Boolean autoSelectFirst$value;

        @Deprecated
        @Generated
        public B options(List<@Regex String> options) {
            this.options = options;
            return (B)this.self();
        }

        @Generated
        public B values(List<@Regex String> values) {
            this.values = values;
            return (B)this.self();
        }

        @Generated
        public B expression(String expression) {
            this.expression = expression;
            return (B)this.self();
        }

        @Generated
        public B itemType(Type itemType) {
            this.itemType$value = itemType;
            this.itemType$set = true;
            return (B)this.self();
        }

        @Generated
        public B allowCustomValue(Boolean allowCustomValue) {
            this.allowCustomValue$value = allowCustomValue;
            this.allowCustomValue$set = true;
            return (B)this.self();
        }

        @Generated
        public B autoSelectFirst(Boolean autoSelectFirst) {
            this.autoSelectFirst$value = autoSelectFirst;
            this.autoSelectFirst$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MultiselectInput.MultiselectInputBuilder(super=" + super.toString() + ", options=" + String.valueOf(this.options) + ", values=" + String.valueOf(this.values) + ", expression=" + this.expression + ", itemType$value=" + String.valueOf((Object)this.itemType$value) + ", allowCustomValue$value=" + this.allowCustomValue$value + ", autoSelectFirst$value=" + this.autoSelectFirst$value + ")";
        }
    }

    @Generated
    private static final class MultiselectInputBuilderImpl
    extends MultiselectInputBuilder<MultiselectInput, MultiselectInputBuilderImpl> {
        @Generated
        private MultiselectInputBuilderImpl() {
        }

        @Override
        @Generated
        protected MultiselectInputBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MultiselectInput build() {
            return new MultiselectInput(this);
        }
    }
}

