/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.input;

import io.kestra.core.models.flows.Input;
import io.kestra.core.models.flows.RenderableInput;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.validations.Regex;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;

public class SelectInput
extends Input<String>
implements RenderableInput {
    @Schema(title="List of values.")
    List<@Regex String> values;
    @Schema(title="Expression to be used for dynamically generating the list of values")
    String expression;
    @Schema(title="If the user can provide a custom value.")
    @NotNull
    Boolean allowCustomValue;
    @Schema(title="Indicates if the input should be rendered as a radio button group.")
    @NotNull
    Boolean isRadio;
    @Schema(title="Whether the first value of the select should be selected by default.")
    @NotNull
    Boolean autoSelectFirst;

    @Override
    public Property<String> getDefaults() {
        Property<String> baseDefaults = super.getDefaults();
        if (baseDefaults == null && this.autoSelectFirst.booleanValue() && !Optional.ofNullable(this.values).map(Collection::isEmpty).orElse(true).booleanValue()) {
            return Property.ofValue(this.values.getFirst());
        }
        return baseDefaults;
    }

    @Override
    public void validate(String input) throws ConstraintViolationException {
        if (!this.values.contains(input) && this.getRequired().booleanValue()) {
            if (this.getAllowCustomValue().booleanValue()) {
                return;
            }
            throw ManualConstraintViolation.toConstraintViolationException("it must match the values `" + String.valueOf(this.values) + "`", this, SelectInput.class, this.getId(), input);
        }
    }

    @Override
    public Input<?> render(Function<String, Object> renderer) {
        if (this.expression != null) {
            return ((SelectInputBuilder)((SelectInputBuilder)((SelectInputBuilder)((SelectInputBuilder)((SelectInputBuilder)((SelectInputBuilder)((SelectInputBuilder)((Input.InputBuilder)((SelectInputBuilder)((SelectInputBuilder)((Input.InputBuilder)SelectInput.builder().values(this.renderExpressionValues(renderer))).id(this.getId())).type(this.getType())).allowCustomValue(this.getAllowCustomValue())).required(this.getRequired())).defaults(this.getDefaults())).description(this.getDescription())).dependsOn(this.getDependsOn())).displayName(this.getDisplayName())).isRadio(this.getIsRadio())).autoSelectFirst(this.getAutoSelectFirst())).build();
        }
        return this;
    }

    private List<String> renderExpressionValues(Function<String, Object> renderer) {
        Object result;
        try {
            result = renderer.apply(this.expression.trim());
        }
        catch (Exception e) {
            throw ManualConstraintViolation.toConstraintViolationException("Cannot render 'expression'. Cause: " + e.getMessage(), this, SelectInput.class, this.getId(), this);
        }
        if (result instanceof List) {
            List list = (List)result;
            return list.stream().filter(Objects::nonNull).map(Object::toString).toList();
        }
        String type = Optional.ofNullable(result).map(Object::getClass).map(Class::getSimpleName).orElse("<null>");
        throw ManualConstraintViolation.toConstraintViolationException("Invalid expression result. Expected a list of strings, but received " + type, this, SelectInput.class, this.getId(), this);
    }

    @Generated
    private static Boolean $default$allowCustomValue() {
        return false;
    }

    @Generated
    private static Boolean $default$isRadio() {
        return false;
    }

    @Generated
    private static Boolean $default$autoSelectFirst() {
        return false;
    }

    @Generated
    protected SelectInput(SelectInputBuilder<?, ?> b) {
        super(b);
        this.values = b.values;
        this.expression = b.expression;
        this.allowCustomValue = b.allowCustomValue$set ? b.allowCustomValue$value : SelectInput.$default$allowCustomValue();
        this.isRadio = b.isRadio$set ? b.isRadio$value : SelectInput.$default$isRadio();
        this.autoSelectFirst = b.autoSelectFirst$set ? b.autoSelectFirst$value : SelectInput.$default$autoSelectFirst();
    }

    @Generated
    public static SelectInputBuilder<?, ?> builder() {
        return new SelectInputBuilderImpl();
    }

    @Generated
    public List<@Regex String> getValues() {
        return this.values;
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public Boolean getAllowCustomValue() {
        return this.allowCustomValue;
    }

    @Generated
    public Boolean getIsRadio() {
        return this.isRadio;
    }

    @Generated
    public Boolean getAutoSelectFirst() {
        return this.autoSelectFirst;
    }

    @Generated
    public SelectInput() {
        this.allowCustomValue = SelectInput.$default$allowCustomValue();
        this.isRadio = SelectInput.$default$isRadio();
        this.autoSelectFirst = SelectInput.$default$autoSelectFirst();
    }

    @Generated
    public static abstract class SelectInputBuilder<C extends SelectInput, B extends SelectInputBuilder<C, B>>
    extends Input.InputBuilder<String, C, B> {
        @Generated
        private List<@Regex String> values;
        @Generated
        private String expression;
        @Generated
        private boolean allowCustomValue$set;
        @Generated
        private Boolean allowCustomValue$value;
        @Generated
        private boolean isRadio$set;
        @Generated
        private Boolean isRadio$value;
        @Generated
        private boolean autoSelectFirst$set;
        @Generated
        private Boolean autoSelectFirst$value;

        @Generated
        public B values(List<@Regex String> values) {
            this.values = values;
            return (B)this.self();
        }

        @Generated
        public B expression(String expression) {
            this.expression = expression;
            return (B)this.self();
        }

        @Generated
        public B allowCustomValue(Boolean allowCustomValue) {
            this.allowCustomValue$value = allowCustomValue;
            this.allowCustomValue$set = true;
            return (B)this.self();
        }

        @Generated
        public B isRadio(Boolean isRadio) {
            this.isRadio$value = isRadio;
            this.isRadio$set = true;
            return (B)this.self();
        }

        @Generated
        public B autoSelectFirst(Boolean autoSelectFirst) {
            this.autoSelectFirst$value = autoSelectFirst;
            this.autoSelectFirst$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SelectInput.SelectInputBuilder(super=" + super.toString() + ", values=" + String.valueOf(this.values) + ", expression=" + this.expression + ", allowCustomValue$value=" + this.allowCustomValue$value + ", isRadio$value=" + this.isRadio$value + ", autoSelectFirst$value=" + this.autoSelectFirst$value + ")";
        }
    }

    @Generated
    private static final class SelectInputBuilderImpl
    extends SelectInputBuilder<SelectInput, SelectInputBuilderImpl> {
        @Generated
        private SelectInputBuilderImpl() {
        }

        @Override
        @Generated
        protected SelectInputBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SelectInput build() {
            return new SelectInput(this);
        }
    }
}

