/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.input;

import io.kestra.core.models.flows.Input;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.validations.Regex;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.ConstraintViolationException;
import java.util.regex.Pattern;
import lombok.Generated;

public class StringInput
extends Input<String> {
    @Schema(title="Regular expression validating the value.")
    @Regex
    String validator;

    @Override
    public void validate(String input) throws ConstraintViolationException {
        if (this.validator != null && !Pattern.matches(this.validator, input)) {
            throw ManualConstraintViolation.toConstraintViolationException("it must match the pattern `" + this.validator + "`", this, StringInput.class, this.getId(), input);
        }
    }

    @Generated
    protected StringInput(StringInputBuilder<?, ?> b) {
        super(b);
        this.validator = b.validator;
    }

    @Generated
    public static StringInputBuilder<?, ?> builder() {
        return new StringInputBuilderImpl();
    }

    @Generated
    public String getValidator() {
        return this.validator;
    }

    @Generated
    public StringInput() {
    }

    @Generated
    public static abstract class StringInputBuilder<C extends StringInput, B extends StringInputBuilder<C, B>>
    extends Input.InputBuilder<String, C, B> {
        @Generated
        private String validator;

        @Generated
        public B validator(String validator) {
            this.validator = validator;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "StringInput.StringInputBuilder(super=" + super.toString() + ", validator=" + this.validator + ")";
        }
    }

    @Generated
    private static final class StringInputBuilderImpl
    extends StringInputBuilder<StringInput, StringInputBuilderImpl> {
        @Generated
        private StringInputBuilderImpl() {
        }

        @Override
        @Generated
        protected StringInputBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public StringInput build() {
            return new StringInput(this);
        }
    }
}

