/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowId;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.runners.FlowMetaStoreInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.SubflowExecution;
import io.kestra.core.runners.SubflowExecutionResult;
import java.util.List;
import java.util.Optional;

public interface ExecutableTask<T extends Output> {
    public List<SubflowExecution<?>> createSubflowExecutions(RunContext var1, FlowMetaStoreInterface var2, Flow var3, Execution var4, TaskRun var5) throws InternalException;

    public Optional<SubflowExecutionResult> createSubflowExecutionResult(RunContext var1, TaskRun var2, FlowInterface var3, Execution var4);

    public boolean waitForExecution();

    public SubflowId subflowId();

    public RestartBehavior getRestartBehavior();

    public static enum RestartBehavior {
        NEW_EXECUTION,
        RETRY_FAILED;

    }

    public record SubflowId(String namespace, String flowId, Optional<Integer> revision) {
        public String flowUid() {
            return FlowId.uid(null, this.namespace, this.flowId, this.revision);
        }

        public String flowUidWithoutRevision() {
            return FlowId.uidWithoutRevision(null, this.namespace, this.flowId);
        }
    }
}

