/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.metrics;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Timer;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.metrics.AbstractMetric;
import io.kestra.core.runners.RunContext;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;

public class TimerMetric
extends AbstractMetric {
    public static final String TYPE = "timer";
    @NotNull
    private Property<Duration> value;

    @Override
    public AbstractMetricEntry<?> toMetric(RunContext runContext) throws IllegalVariableEvaluationException {
        String name = runContext.render(this.name).as(String.class).orElseThrow();
        Duration value = runContext.render(this.value).as(Duration.class).orElseThrow();
        String description = runContext.render(this.description).as(String.class).orElse(null);
        Map tags = (Map)runContext.render(this.tags).asMap(String.class, String.class);
        String[] tagsAsStrings = (String[])tags.entrySet().stream().flatMap(e -> Stream.of((String)e.getKey(), (String)e.getValue())).toArray(String[]::new);
        return Timer.of(name, description, value, tagsAsStrings);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Generated
    protected TimerMetric(TimerMetricBuilder<?, ?> b) {
        super(b);
        this.value = b.value;
    }

    @Generated
    public static TimerMetricBuilder<?, ?> builder() {
        return new TimerMetricBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "TimerMetric(super=" + super.toString() + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimerMetric)) {
            return false;
        }
        TimerMetric other = (TimerMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimerMetric;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Property<Duration> getValue() {
        return this.value;
    }

    @Generated
    public TimerMetric() {
    }

    @ConstructorProperties(value={"value"})
    @Generated
    public TimerMetric(Property<Duration> value) {
        this.value = value;
    }

    @Generated
    public static abstract class TimerMetricBuilder<C extends TimerMetric, B extends TimerMetricBuilder<C, B>>
    extends AbstractMetric.AbstractMetricBuilder<C, B> {
        @Generated
        private Property<Duration> value;

        @Generated
        public B value(Property<Duration> value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TimerMetric.TimerMetricBuilder(super=" + super.toString() + ", value=" + String.valueOf(this.value) + ")";
        }
    }

    @Generated
    private static final class TimerMetricBuilderImpl
    extends TimerMetricBuilder<TimerMetric, TimerMetricBuilderImpl> {
        @Generated
        private TimerMetricBuilderImpl() {
        }

        @Override
        @Generated
        protected TimerMetricBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TimerMetric build() {
            return new TimerMetric(this);
        }
    }
}

