/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.runners;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.runners.TargetOS;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.utils.Slugify;
import jakarta.annotation.Nullable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public final class ScriptService {
    private static final Pattern INTERNAL_STORAGE_PATTERN = Pattern.compile("(kestra:\\/\\/[-\\p{Alnum}._\\+~#=/]*)", 256);
    public static final String VAR_WORKING_DIR = "workingDir";
    public static final String VAR_OUTPUT_DIR = "outputDir";
    public static final String VAR_BUCKET_PATH = "bucketPath";
    public static final String ENV_WORKING_DIR = "WORKING_DIR";
    public static final String ENV_OUTPUT_DIR = "OUTPUT_DIR";
    public static final String ENV_BUCKET_PATH = "BUCKET_PATH";

    private ScriptService() {
    }

    public static String replaceInternalStorage(RunContext runContext, @Nullable String command, boolean replaceWithRelativePath) throws IOException {
        if (command == null) {
            return "";
        }
        return INTERNAL_STORAGE_PATTERN.matcher(command).replaceAll(Rethrow.throwFunction(matchResult -> {
            String localFile = ScriptService.saveOnLocalStorage(runContext, matchResult.group()).replace("\\", "/");
            if (!replaceWithRelativePath) {
                return localFile;
            }
            return runContext.workingDir().path().relativize(Path.of(localFile, new String[0])).toString();
        }));
    }

    public static String replaceInternalStorage(RunContext runContext, Map<String, Object> additionalVars, String command, boolean replaceWithRelativePath) throws IOException, IllegalVariableEvaluationException {
        if (command == null) {
            return null;
        }
        return ScriptService.replaceInternalStorage(runContext, additionalVars, List.of(command), replaceWithRelativePath).getFirst();
    }

    public static List<String> replaceInternalStorage(RunContext runContext, Map<String, Object> additionalVars, List<String> commands, boolean replaceWithRelativePath) throws IOException, IllegalVariableEvaluationException {
        return ListUtils.emptyOnNull(commands).stream().map(Rethrow.throwFunction(c -> runContext.render((String)c, additionalVars))).map(Rethrow.throwFunction(c -> ScriptService.replaceInternalStorage(runContext, c, replaceWithRelativePath))).toList();
    }

    public static List<String> replaceInternalStorage(RunContext runContext, Map<String, Object> additionalVars, Property<List<String>> commands, boolean replaceWithRelativePath) throws IOException, IllegalVariableEvaluationException {
        return commands == null ? Collections.emptyList() : runContext.render(commands).asList(String.class, additionalVars).stream().map(Rethrow.throwFunction(c -> ScriptService.replaceInternalStorage(runContext, c, replaceWithRelativePath))).toList();
    }

    public static List<String> replaceInternalStorage(RunContext runContext, List<String> commands) throws IOException, IllegalVariableEvaluationException {
        return ScriptService.replaceInternalStorage(runContext, Collections.emptyMap(), commands, false);
    }

    private static String saveOnLocalStorage(RunContext runContext, String uri) throws IOException {
        Path path = runContext.workingDir().createTempFile();
        try (InputStream inputStream = runContext.storage().getFile(URI.create(uri));){
            String string;
            try (FileOutputStream outputStream = new FileOutputStream(path.toFile());){
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                string = path.toString();
            }
            return string;
        }
    }

    public static Map<String, URI> uploadOutputFiles(RunContext runContext, Path outputDir) throws IOException {
        HashMap<String, URI> uploaded = new HashMap<String, URI>();
        try (Stream<Path> walk = Files.walk(outputDir, new FileVisitOption[0]);){
            walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> !path.startsWith(".")).forEach(Rethrow.throwConsumer(path -> {
                String filename = outputDir.relativize((Path)path).toString();
                uploaded.put(filename, runContext.storage().putFile(path.toFile(), filename));
            }));
        }
        return uploaded;
    }

    public static List<String> scriptCommands(List<String> interpreter, List<String> beforeCommands, String command) {
        return ScriptService.scriptCommands(interpreter, beforeCommands, List.of(command), TargetOS.LINUX);
    }

    public static List<String> scriptCommands(List<String> interpreter, List<String> beforeCommands, List<String> commands) {
        return ScriptService.scriptCommands(interpreter, beforeCommands, commands, TargetOS.LINUX);
    }

    public static List<String> scriptCommands(List<String> interpreter, List<String> beforeCommands, String command, TargetOS targetOS) {
        return ScriptService.scriptCommands(interpreter, beforeCommands, List.of(command), targetOS);
    }

    public static List<String> scriptCommands(List<String> interpreter, List<String> beforeCommands, List<String> commands, TargetOS targetOS) {
        ArrayList<String> commandsArgs = new ArrayList<String>(interpreter);
        commandsArgs.add(Stream.concat(ListUtils.emptyOnNull(beforeCommands).stream(), commands.stream()).collect(Collectors.joining(targetOS.lineSeparator)));
        return commandsArgs;
    }

    public static Map<String, String> labels(RunContext runContext, String prefix) {
        return ScriptService.labels(runContext, prefix, true, false);
    }

    public static Map<String, String> labels(RunContext runContext, String prefix, boolean normalizeValue, boolean lowerCase) {
        Map flow = (Map)runContext.getVariables().get("flow");
        Map task = (Map)runContext.getVariables().get("task");
        Map execution = (Map)runContext.getVariables().get("execution");
        Map taskrun = (Map)runContext.getVariables().get("taskrun");
        return ImmutableMap.of((Object)ScriptService.withPrefix("namespace", prefix), (Object)ScriptService.normalizeValue((String)flow.get("namespace"), normalizeValue, lowerCase), (Object)ScriptService.withPrefix("flow-id", prefix), (Object)ScriptService.normalizeValue((String)flow.get("id"), normalizeValue, lowerCase), (Object)ScriptService.withPrefix("task-id", prefix), (Object)ScriptService.normalizeValue((String)task.get("id"), normalizeValue, lowerCase), (Object)ScriptService.withPrefix("execution-id", prefix), (Object)ScriptService.normalizeValue((String)execution.get("id"), normalizeValue, lowerCase), (Object)ScriptService.withPrefix("taskrun-id", prefix), (Object)ScriptService.normalizeValue((String)taskrun.get("id"), normalizeValue, lowerCase), (Object)ScriptService.withPrefix("taskrun-attempt", prefix), (Object)ScriptService.normalizeValue(String.valueOf(taskrun.get("attemptsCount")), normalizeValue, lowerCase));
    }

    private static String withPrefix(String name, String prefix) {
        return prefix == null ? name : prefix + name;
    }

    private static String normalizeValue(String value, boolean normalizeValue, boolean lowerCase) {
        if (!normalizeValue) {
            return value;
        }
        return lowerCase ? ScriptService.normalize(value).toLowerCase() : ScriptService.normalize(value);
    }

    public static String normalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() > 63) {
            string = string.substring(0, 63);
        }
        string = StringUtils.stripEnd((String)string, (String)"-");
        string = StringUtils.stripEnd((String)string, (String)".");
        string = StringUtils.stripEnd((String)string, (String)"_");
        return string;
    }

    public static String jobName(RunContext runContext) {
        Map flow = (Map)runContext.getVariables().get("flow");
        Map task = (Map)runContext.getVariables().get("task");
        String name = Slugify.of(String.join((CharSequence)"-", (CharSequence)flow.get("namespace"), (CharSequence)flow.get("id"), (CharSequence)task.get("id")));
        String normalized = ScriptService.normalizeValue(name, true, true);
        if (normalized.length() > 58) {
            normalized = normalized.substring(0, 57);
        }
        String suffix = RandomStringUtils.secure().nextAlphanumeric(5).toLowerCase();
        return normalized + "-" + suffix;
    }
}

