/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.runners;

import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.runners.AbstractLogConsumer;
import io.kestra.core.models.tasks.runners.TargetOS;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface TaskCommands {
    public String getContainerImage();

    public AbstractLogConsumer getLogConsumer();

    public Property<List<String>> getInterpreter();

    public Property<List<String>> getBeforeCommands();

    public Property<List<String>> getCommands();

    public Map<String, Object> getAdditionalVars();

    public Path getWorkingDirectory();

    public Path getOutputDirectory();

    public Map<String, String> getEnv();

    public Boolean getEnableOutputDirectory();

    default public boolean outputDirectoryEnabled() {
        return Boolean.TRUE.equals(this.getEnableOutputDirectory());
    }

    public Duration getTimeout();

    public TargetOS getTargetOS();

    default public List<Path> relativeWorkingDirectoryFilesPaths() throws IOException {
        return this.relativeWorkingDirectoryFilesPaths(false);
    }

    default public List<Path> relativeWorkingDirectoryFilesPaths(boolean includeDirectories) throws IOException {
        Path workingDirectory = this.getWorkingDirectory();
        if (workingDirectory == null) {
            return Collections.emptyList();
        }
        try (Stream<Path> walk = Files.walk(workingDirectory, new FileVisitOption[0]);){
            Stream<Path> filtered = includeDirectories ? walk : walk.filter(path -> !Files.isDirectory(path, new LinkOption[0]));
            Path outputDirectory = this.getOutputDirectory();
            if (outputDirectory != null) {
                filtered = filtered.filter(Predicate.not(path -> path.startsWith(outputDirectory)));
            }
            List<Path> list = filtered.map(workingDirectory::relativize).toList();
            return list;
        }
    }
}

