/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.runners;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.slf4j.spi.LoggingEventBuilder;

@Singleton
public class TaskLogLineMatcher {
    protected static final Pattern LOG_DATA_SYNTAX = Pattern.compile("^::(\\{.*})::$");
    protected static final ObjectMapper MAPPER = JacksonMapper.ofJson(false);

    public Optional<TaskLogMatch> matches(String logLine, Logger logger, RunContext runContext, Instant instant) throws IOException {
        Optional<String> matches = this.matches(logLine);
        if (matches.isEmpty()) {
            return Optional.empty();
        }
        TaskLogMatch match = (TaskLogMatch)MAPPER.readValue(matches.get(), TaskLogMatch.class);
        return Optional.of(this.handle(logger, runContext, instant, match, matches.get()));
    }

    protected TaskLogMatch handle(Logger logger, RunContext runContext, Instant instant, TaskLogMatch match, String data) {
        if (match.metrics() != null) {
            match.metrics().forEach(runContext::metric);
        }
        if (match.logs() != null) {
            match.logs().forEach(it -> {
                try {
                    LoggingEventBuilder builder = runContext.logger().atLevel(it.level()).addKeyValue("originalTimestamp", (Object)instant);
                    builder.log(it.message());
                }
                catch (Exception e) {
                    logger.warn("Invalid log '{}'", (Object)data, (Object)e);
                }
            });
        }
        return match;
    }

    protected Optional<String> matches(String logLine) {
        Matcher m = LOG_DATA_SYNTAX.matcher(logLine);
        return m.find() ? Optional.ofNullable(m.group(1)) : Optional.empty();
    }

    public record TaskLogMatch(Map<String, Object> outputs, List<AbstractMetricEntry<?>> metrics, List<LogLine> logs) {
        private final Map<String, Object> outputs;

        public Map<String, Object> outputs() {
            return Optional.ofNullable(this.outputs).orElse(Map.of());
        }
    }

    public record LogLine(Level level, String message) {
    }
}

