/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.kestra.core.models.Label;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.WorkerGroup;
import io.kestra.core.models.triggers.TriggerInterface;
import io.kestra.core.serializers.ListOrMapOfLabelDeserializer;
import io.kestra.core.serializers.ListOrMapOfLabelSerializer;
import io.kestra.core.validations.NoSystemLabelValidation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.event.Level;

@Plugin
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public abstract class AbstractTrigger
implements TriggerInterface {
    protected String id;
    protected String type;
    @PluginProperty(hidden=true, group="core")
    protected String version;
    @PluginProperty(hidden=true, group="core")
    private String description;
    @PluginProperty(group="core")
    @Schema(title="List of conditions in order to limit the flow trigger.")
    @Valid
    protected @Valid List<@Valid @NotNull Condition> conditions;
    @NotNull
    @PluginProperty(hidden=true, group="core")
    @Schema(defaultValue="false")
    private boolean disabled;
    @Valid
    @PluginProperty(hidden=true, group="core")
    private WorkerGroup workerGroup;
    @PluginProperty(hidden=true, group="core")
    private Level logLevel;
    @Schema(title="The labels to pass to the execution created.", implementation=Object.class, oneOf={List.class, Map.class})
    @JsonSerialize(using=ListOrMapOfLabelSerializer.class)
    @JsonDeserialize(using=ListOrMapOfLabelDeserializer.class)
    @PluginProperty(hidden=true, group="core")
    private List<@NoSystemLabelValidation Label> labels;
    @PluginProperty(group="core")
    @Schema(title="List of execution states after which a trigger should be stopped (a.k.a. disabled).")
    private List<State.Type> stopAfter;
    @PluginProperty(hidden=true, group="core")
    private boolean logToFile;
    @PluginProperty(hidden=true, group="core")
    private boolean failOnTriggerError;

    @Deprecated
    public void setMinLogLevel(Level minLogLevel) {
        this.logLevel = minLogLevel;
    }

    @Generated
    private static boolean $default$disabled() {
        return false;
    }

    @Generated
    private static boolean $default$logToFile() {
        return false;
    }

    @Generated
    private static boolean $default$failOnTriggerError() {
        return false;
    }

    @Generated
    protected AbstractTrigger(AbstractTriggerBuilder<?, ?> b) {
        this.id = b.id;
        this.type = b.type;
        this.version = b.version;
        this.description = b.description;
        this.conditions = b.conditions;
        this.disabled = b.disabled$set ? b.disabled$value : AbstractTrigger.$default$disabled();
        this.workerGroup = b.workerGroup;
        this.logLevel = b.logLevel;
        this.labels = b.labels;
        this.stopAfter = b.stopAfter;
        this.logToFile = b.logToFile$set ? b.logToFile$value : AbstractTrigger.$default$logToFile();
        this.failOnTriggerError = b.failOnTriggerError$set ? b.failOnTriggerError$value : AbstractTrigger.$default$failOnTriggerError();
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<@Valid @NotNull Condition> getConditions() {
        return this.conditions;
    }

    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Generated
    public WorkerGroup getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public Level getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public List<@NoSystemLabelValidation Label> getLabels() {
        return this.labels;
    }

    @Generated
    public List<State.Type> getStopAfter() {
        return this.stopAfter;
    }

    @Generated
    public boolean isLogToFile() {
        return this.logToFile;
    }

    @Generated
    public boolean isFailOnTriggerError() {
        return this.failOnTriggerError;
    }

    @Generated
    public AbstractTrigger() {
        this.disabled = AbstractTrigger.$default$disabled();
        this.logToFile = AbstractTrigger.$default$logToFile();
        this.failOnTriggerError = AbstractTrigger.$default$failOnTriggerError();
    }

    @Generated
    public static abstract class AbstractTriggerBuilder<C extends AbstractTrigger, B extends AbstractTriggerBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String type;
        @Generated
        private String version;
        @Generated
        private String description;
        @Generated
        private List<@Valid @NotNull Condition> conditions;
        @Generated
        private boolean disabled$set;
        @Generated
        private boolean disabled$value;
        @Generated
        private WorkerGroup workerGroup;
        @Generated
        private Level logLevel;
        @Generated
        private List<@NoSystemLabelValidation Label> labels;
        @Generated
        private List<State.Type> stopAfter;
        @Generated
        private boolean logToFile$set;
        @Generated
        private boolean logToFile$value;
        @Generated
        private boolean failOnTriggerError$set;
        @Generated
        private boolean failOnTriggerError$value;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B version(String version) {
            this.version = version;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B conditions(List<@Valid @NotNull Condition> conditions) {
            this.conditions = conditions;
            return this.self();
        }

        @Generated
        public B disabled(boolean disabled) {
            this.disabled$value = disabled;
            this.disabled$set = true;
            return this.self();
        }

        @Generated
        public B workerGroup(WorkerGroup workerGroup) {
            this.workerGroup = workerGroup;
            return this.self();
        }

        @Generated
        public B logLevel(Level logLevel) {
            this.logLevel = logLevel;
            return this.self();
        }

        @JsonDeserialize(using=ListOrMapOfLabelDeserializer.class)
        @Generated
        public B labels(List<@NoSystemLabelValidation Label> labels) {
            this.labels = labels;
            return this.self();
        }

        @Generated
        public B stopAfter(List<State.Type> stopAfter) {
            this.stopAfter = stopAfter;
            return this.self();
        }

        @Generated
        public B logToFile(boolean logToFile) {
            this.logToFile$value = logToFile;
            this.logToFile$set = true;
            return this.self();
        }

        @Generated
        public B failOnTriggerError(boolean failOnTriggerError) {
            this.failOnTriggerError$value = failOnTriggerError;
            this.failOnTriggerError$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractTrigger.AbstractTriggerBuilder(id=" + this.id + ", type=" + this.type + ", version=" + this.version + ", description=" + this.description + ", conditions=" + String.valueOf(this.conditions) + ", disabled$value=" + this.disabled$value + ", workerGroup=" + String.valueOf(this.workerGroup) + ", logLevel=" + String.valueOf(this.logLevel) + ", labels=" + String.valueOf(this.labels) + ", stopAfter=" + String.valueOf(this.stopAfter) + ", logToFile$value=" + this.logToFile$value + ", failOnTriggerError$value=" + this.failOnTriggerError$value + ")";
        }
    }
}

