/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import io.kestra.core.models.HasUID;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowId;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Backfill;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.models.triggers.RecoverMissedSchedules;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.core.trigger.Schedule;
import io.micronaut.core.annotation.Nullable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import lombok.Generated;

public class Trigger
extends TriggerContext
implements HasUID {
    @Nullable
    private String executionId;
    @Nullable
    private Instant updatedDate;
    @Nullable
    private ZonedDateTime evaluateRunningDate;
    @Nullable
    private String workerId;

    protected Trigger(TriggerBuilder<?, ?> b) {
        super(b);
        this.executionId = b.executionId;
        this.updatedDate = b.updatedDate;
        this.evaluateRunningDate = b.evaluateRunningDate;
    }

    public static TriggerBuilder<?, ?> builder() {
        return new TriggerBuilderImpl();
    }

    @Override
    public String uid() {
        return Trigger.uid(this);
    }

    public static String uid(Trigger trigger) {
        return IdUtils.fromParts(trigger.getTenantId(), trigger.getNamespace(), trigger.getFlowId(), trigger.getTriggerId());
    }

    public static String uid(Execution execution) {
        return IdUtils.fromParts(execution.getTenantId(), execution.getNamespace(), execution.getFlowId(), execution.getTrigger().getId());
    }

    public static String uid(Flow flow, AbstractTrigger abstractTrigger) {
        return IdUtils.fromParts(flow.getTenantId(), flow.getNamespace(), flow.getId(), abstractTrigger.getId());
    }

    public String flowUid() {
        return FlowId.uidWithoutRevision(this.getTenantId(), this.getNamespace(), this.getFlowId());
    }

    public static Trigger of(FlowInterface flow, AbstractTrigger abstractTrigger) {
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().tenantId(flow.getTenantId())).namespace(flow.getNamespace())).flowId(flow.getId())).triggerId(abstractTrigger.getId())).stopAfter(abstractTrigger.getStopAfter())).build();
    }

    public static Trigger of(TriggerContext triggerContext, ZonedDateTime nextExecutionDate) {
        return ((TriggerBuilder)Trigger.fromContext(triggerContext).nextExecutionDate(nextExecutionDate)).build();
    }

    public static Trigger of(TriggerContext triggerContext, Execution execution, ZonedDateTime nextExecutionDate) {
        return ((TriggerBuilder)((TriggerContext.TriggerContextBuilder)((TriggerBuilder)Trigger.fromContext(triggerContext).executionId(execution.getId())).updatedDate(Instant.now())).nextExecutionDate(nextExecutionDate)).build();
    }

    public static Trigger fromEvaluateFailed(TriggerContext triggerContext, ZonedDateTime nextExecutionDate) {
        return ((TriggerBuilder)((TriggerContext.TriggerContextBuilder)((TriggerBuilder)Trigger.fromContext(triggerContext).executionId(null)).updatedDate(Instant.now())).nextExecutionDate(nextExecutionDate)).build();
    }

    public static Trigger of(Execution execution, Trigger trigger) {
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerContext.TriggerContextBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().tenantId(execution.getTenantId())).namespace(execution.getNamespace())).flowId(execution.getFlowId())).triggerId(execution.getTrigger().getId())).date(trigger.getDate())).nextExecutionDate(trigger.getNextExecutionDate())).executionId(execution.getId())).updatedDate(Instant.now())).backfill(trigger.getBackfill())).stopAfter(trigger.getStopAfter())).disabled(trigger.getDisabled())).build();
    }

    public static Trigger of(Trigger trigger, ZonedDateTime evaluateRunningDate) {
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.fromContext(trigger).nextExecutionDate(trigger.getNextExecutionDate())).evaluateRunningDate(evaluateRunningDate)).updatedDate(Instant.now())).build();
    }

    public static Trigger of(FlowInterface flow, AbstractTrigger abstractTrigger, ConditionContext conditionContext, Optional<Trigger> lastTrigger) throws Exception {
        ZonedDateTime nextDate = null;
        if (abstractTrigger instanceof PollingTriggerInterface) {
            PollingTriggerInterface pollingTriggerInterface = (PollingTriggerInterface)((Object)abstractTrigger);
            nextDate = pollingTriggerInterface.nextEvaluationDate(conditionContext, Optional.empty());
        }
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().tenantId(flow.getTenantId())).namespace(flow.getNamespace())).flowId(flow.getId())).triggerId(abstractTrigger.getId())).date(ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS))).nextExecutionDate(nextDate)).stopAfter(abstractTrigger.getStopAfter())).disabled(lastTrigger.map(TriggerContext::getDisabled).orElse(Boolean.FALSE))).backfill(null)).build();
    }

    public Trigger resetExecution(Flow flow, Execution execution, ConditionContext conditionContext) {
        boolean disabled;
        boolean bl = disabled = this.getStopAfter() != null ? this.getStopAfter().contains((Object)execution.getState().getCurrent()) : this.getDisabled().booleanValue();
        if (!disabled) {
            AbstractTrigger abstractTrigger = flow.findTriggerByTriggerId(this.getTriggerId());
            if (abstractTrigger == null) {
                throw new IllegalArgumentException("Unable to find trigger with id '" + this.getTriggerId() + "'");
            }
            if (abstractTrigger instanceof Schedule) {
                Schedule schedule = (Schedule)abstractTrigger;
                if (this.getNextExecutionDate() != null && execution.getState().getEndDate().get().isAfter(this.getNextExecutionDate().toInstant())) {
                    RecoverMissedSchedules recoverMissedSchedules = Optional.ofNullable(schedule.getRecoverMissedSchedules()).orElseGet(() -> schedule.defaultRecoverMissedSchedules(conditionContext.getRunContext()));
                    ZonedDateTime previousDate = schedule.previousEvaluationDate(conditionContext);
                    if (recoverMissedSchedules.equals((Object)RecoverMissedSchedules.LAST)) {
                        return this.resetExecution(execution.getState().getCurrent(), previousDate);
                    }
                    if (recoverMissedSchedules.equals((Object)RecoverMissedSchedules.NONE)) {
                        return this.resetExecution(execution.getState().getCurrent(), schedule.nextEvaluationDate(conditionContext, Optional.empty()));
                    }
                }
            }
        }
        return this.resetExecution(execution.getState().getCurrent());
    }

    public Trigger resetExecution(State.Type executionEndState) {
        return this.resetExecution(executionEndState, this.getNextExecutionDate());
    }

    public Trigger resetExecution(State.Type executionEndState, ZonedDateTime nextExecutionDate) {
        Boolean disabled = this.getStopAfter() != null ? this.getStopAfter().contains((Object)executionEndState) : this.getDisabled().booleanValue();
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().tenantId(this.getTenantId())).namespace(this.getNamespace())).flowId(this.getFlowId())).triggerId(this.getTriggerId())).date(this.getDate())).nextExecutionDate(nextExecutionDate)).stopAfter(this.getStopAfter())).backfill(this.getBackfill())).disabled(disabled)).evaluateRunningDate(this.getEvaluateRunningDate())).build();
    }

    public Trigger unlock() {
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().tenantId(this.getTenantId())).namespace(this.getNamespace())).flowId(this.getFlowId())).triggerId(this.getTriggerId())).date(this.getDate())).nextExecutionDate(this.getNextExecutionDate())).backfill(this.getBackfill())).stopAfter(this.getStopAfter())).disabled(this.getDisabled())).build();
    }

    public Trigger withBackfill(Backfill backfill) {
        TriggerContext updated = this;
        if (backfill != null) {
            updated = ((TriggerBuilder)this.toBuilder().backfill((Backfill)((Backfill.BackfillBuilder)((Backfill.BackfillBuilder)((Backfill.BackfillBuilder)backfill.toBuilder().end(backfill.getEnd() != null ? backfill.getEnd() : ZonedDateTime.now())).currentDate(backfill.getStart())).previousNextExecutionDate(this.getNextExecutionDate())).build())).build();
        }
        return updated;
    }

    public Trigger checkBackfill() {
        if (this.getBackfill() != null && !this.getBackfill().getPaused().booleanValue()) {
            Backfill backfill = this.getBackfill();
            if (this.getNextExecutionDate().isAfter(backfill.getEnd())) {
                return ((TriggerBuilder)((TriggerBuilder)this.toBuilder().nextExecutionDate(backfill.getPreviousNextExecutionDate())).backfill(null)).build();
            }
            return ((TriggerBuilder)this.toBuilder().backfill((Backfill)((Backfill.BackfillBuilder)backfill.toBuilder().currentDate(this.getNextExecutionDate())).build())).build();
        }
        return this;
    }

    private static TriggerBuilder<?, ?> fromContext(TriggerContext triggerContext) {
        return (TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().tenantId(triggerContext.getTenantId())).namespace(triggerContext.getNamespace())).flowId(triggerContext.getFlowId())).triggerId(triggerContext.getTriggerId())).date(triggerContext.getDate())).backfill(triggerContext.getBackfill())).stopAfter(triggerContext.getStopAfter())).disabled(triggerContext.getDisabled());
    }

    @Generated
    public TriggerBuilder<?, ?> toBuilder() {
        return new TriggerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String toString() {
        return "Trigger(super=" + super.toString() + ", executionId=" + this.getExecutionId() + ", updatedDate=" + String.valueOf(this.getUpdatedDate()) + ", evaluateRunningDate=" + String.valueOf(this.getEvaluateRunningDate()) + ", workerId=" + this.getWorkerId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        Instant this$updatedDate = this.getUpdatedDate();
        Instant other$updatedDate = other.getUpdatedDate();
        if (this$updatedDate == null ? other$updatedDate != null : !((Object)this$updatedDate).equals(other$updatedDate)) {
            return false;
        }
        ZonedDateTime this$evaluateRunningDate = this.getEvaluateRunningDate();
        ZonedDateTime other$evaluateRunningDate = other.getEvaluateRunningDate();
        if (this$evaluateRunningDate == null ? other$evaluateRunningDate != null : !((Object)this$evaluateRunningDate).equals(other$evaluateRunningDate)) {
            return false;
        }
        String this$workerId = this.getWorkerId();
        String other$workerId = other.getWorkerId();
        return !(this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Trigger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        Instant $updatedDate = this.getUpdatedDate();
        result = result * 59 + ($updatedDate == null ? 43 : ((Object)$updatedDate).hashCode());
        ZonedDateTime $evaluateRunningDate = this.getEvaluateRunningDate();
        result = result * 59 + ($evaluateRunningDate == null ? 43 : ((Object)$evaluateRunningDate).hashCode());
        String $workerId = this.getWorkerId();
        result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
        return result;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public Instant getUpdatedDate() {
        return this.updatedDate;
    }

    @Generated
    public ZonedDateTime getEvaluateRunningDate() {
        return this.evaluateRunningDate;
    }

    @Generated
    public String getWorkerId() {
        return this.workerId;
    }

    @Generated
    public Trigger() {
    }

    @Generated
    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public static abstract class TriggerBuilder<C extends Trigger, B extends TriggerBuilder<C, B>>
    extends TriggerContext.TriggerContextBuilder<C, B> {
        @Generated
        private String executionId;
        @Generated
        private Instant updatedDate;
        @Generated
        private ZonedDateTime evaluateRunningDate;
        @Generated
        private String workerId;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TriggerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Trigger instance, TriggerBuilder<?, ?> b) {
            b.executionId(instance.executionId);
            b.updatedDate(instance.updatedDate);
            b.evaluateRunningDate(instance.evaluateRunningDate);
            b.workerId(instance.workerId);
        }

        @Generated
        public B executionId(String executionId) {
            this.executionId = executionId;
            return (B)this.self();
        }

        @Generated
        public B updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return (B)this.self();
        }

        @Generated
        public B evaluateRunningDate(ZonedDateTime evaluateRunningDate) {
            this.evaluateRunningDate = evaluateRunningDate;
            return (B)this.self();
        }

        @Generated
        public B workerId(String workerId) {
            this.workerId = workerId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Trigger.TriggerBuilder(super=" + super.toString() + ", executionId=" + this.executionId + ", updatedDate=" + String.valueOf(this.updatedDate) + ", evaluateRunningDate=" + String.valueOf(this.evaluateRunningDate) + ", workerId=" + this.workerId + ")";
        }
    }

    @Generated
    private static final class TriggerBuilderImpl
    extends TriggerBuilder<Trigger, TriggerBuilderImpl> {
        @Generated
        private TriggerBuilderImpl() {
        }

        @Override
        @Generated
        protected TriggerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Trigger build() {
            return new Trigger(this);
        }
    }
}

