/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers.multipleflows;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.triggers.TimeWindow;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionWindow;
import io.kestra.core.utils.Rethrow;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public interface MultipleCondition
extends Rethrow.PredicateChecked<ConditionContext, InternalException> {
    public String getId();

    public TimeWindow getTimeWindow();

    public Boolean getResetOnSuccess();

    public Map<String, Condition> getConditions();

    public Logger logger();

    @Override
    default public boolean test(ConditionContext conditionContext) throws InternalException {
        MultipleConditionStorageInterface multipleConditionStorage = conditionContext.getMultipleConditionStorage();
        Objects.requireNonNull(multipleConditionStorage);
        Optional<MultipleConditionWindow> triggerExecutionWindow = multipleConditionStorage.get(conditionContext.getFlow(), this.getId());
        Map<String, Boolean> results = this.getConditions().keySet().stream().map(condition -> new AbstractMap.SimpleEntry<String, Boolean>((String)condition, triggerExecutionWindow.isPresent() && ((MultipleConditionWindow)triggerExecutionWindow.get()).getResults() != null && ((MultipleConditionWindow)triggerExecutionWindow.get()).getResults().containsKey(condition) && ((MultipleConditionWindow)triggerExecutionWindow.get()).getResults().get(condition) != false)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        long validatedCount = results.entrySet().stream().filter(Map.Entry::getValue).count();
        boolean result = (long)this.getConditions().size() == validatedCount;
        Logger log = this.logger();
        if (result && log.isDebugEnabled()) {
            log.debug("[namespace: {}] [flow: {}] Multiple conditions validated!", (Object)conditionContext.getFlow().getNamespace(), (Object)conditionContext.getFlow().getId());
        } else if (log.isTraceEnabled()) {
            log.trace("[namespace: {}] [flow: {}] Multiple conditions failed ({}/{}) with '{}'", new Object[]{conditionContext.getFlow().getNamespace(), conditionContext.getFlow().getId(), validatedCount, this.getConditions().size(), results});
        }
        return result;
    }
}

