/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.contexts.MavenPluginRepositoryConfig;
import io.kestra.core.exceptions.KestraRuntimeException;
import io.kestra.core.plugins.PluginArtifact;
import io.kestra.core.plugins.PluginResolutionResult;
import io.kestra.core.utils.Version;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Nullable;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.MultiRuntimeException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.supplier.RepositorySystemSupplier;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MavenPluginDownloader
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MavenPluginDownloader.class);
    private static final String DEFAULT_LOCAL_REPOSITORY_PREFIX = "kestra-plugins-m2-repository";
    private static final String DEFAULT_REPOSITORY_TYPE = "default";
    public static final String LATEST = "latest";
    private final List<MavenPluginRepositoryConfig> repositoryConfigs;
    private final RepositorySystem system;
    private final RepositorySystemSession session;

    @Inject
    public MavenPluginDownloader(List<MavenPluginRepositoryConfig> repositoryConfigs, @Nullable @Value(value="${kestra.plugins.local-repository-path}") String localRepositoryPath) {
        this.repositoryConfigs = repositoryConfigs;
        this.system = new RepositorySystemSupplier().get();
        this.session = this.repositorySystemSession(this.system, localRepositoryPath);
    }

    public PluginArtifact resolve(String dependency) {
        return this.doResolve(MavenPluginDownloader.buildRemoteRepositories(this.repositoryConfigs), dependency);
    }

    public List<String> listAllVersions(String dependency) {
        try {
            DefaultArtifact artifact = new DefaultArtifact(dependency);
            VersionRangeRequest request = new VersionRangeRequest();
            request.setArtifact(artifact.setVersion("[0,)"));
            request.setRepositories(MavenPluginDownloader.buildRemoteRepositories(this.repositoryConfigs));
            VersionRangeResult result = this.system.resolveVersionRange(this.session, request);
            return result.getVersions().stream().map(Object::toString).toList();
        }
        catch (VersionRangeResolutionException e) {
            log.debug("Failed to resolve all versions for '{}'", (Object)dependency);
            return List.of();
        }
    }

    public PluginArtifact resolve(String dependency, List<MavenPluginRepositoryConfig> repositories) {
        ArrayList<RemoteRepository> allRepositories = new ArrayList<RemoteRepository>();
        allRepositories.addAll(MavenPluginDownloader.buildRemoteRepositories(this.repositoryConfigs));
        allRepositories.addAll(MavenPluginDownloader.buildRemoteRepositories(repositories));
        return this.doResolve(allRepositories, dependency);
    }

    private PluginArtifact doResolve(List<RemoteRepository> repositories, String dependency) {
        PluginArtifact result = this.resolveArtifact(repositories, dependency);
        log.debug("Resolved Plugin '{}' with '{}'", (Object)dependency, (Object)result.uri());
        return result;
    }

    public List<PluginResolutionResult> resolveVersions(List<PluginArtifact> artifacts) {
        return artifacts.stream().map(artifact -> {
            List<String> versions = this.listAllVersions(artifact.toCoordinates());
            List<Version> parsedVersions = versions.stream().map(Version::of).sorted().toList();
            if (versions.isEmpty()) {
                return new PluginResolutionResult((PluginArtifact)artifact, null, List.of(), false);
            }
            List<String> sortedVersions = parsedVersions.stream().map(Version::toString).toList();
            if (artifact.version().equalsIgnoreCase(LATEST)) {
                return new PluginResolutionResult((PluginArtifact)artifact, Version.getLatest(parsedVersions).toString(), sortedVersions, true);
            }
            return versions.contains(artifact.version()) ? new PluginResolutionResult((PluginArtifact)artifact, artifact.version(), versions, true) : new PluginResolutionResult((PluginArtifact)artifact, null, sortedVersions, false);
        }).toList();
    }

    private static List<RemoteRepository> buildRemoteRepositories(List<MavenPluginRepositoryConfig> repositoryConfigs) {
        return repositoryConfigs.stream().map(repositoryConfig -> {
            RemoteRepository.Builder build = new RemoteRepository.Builder(repositoryConfig.id(), DEFAULT_REPOSITORY_TYPE, repositoryConfig.url());
            if (repositoryConfig.basicAuth() != null) {
                AuthenticationBuilder authenticationBuilder = new AuthenticationBuilder();
                authenticationBuilder.addUsername(repositoryConfig.basicAuth().username());
                authenticationBuilder.addPassword(repositoryConfig.basicAuth().password());
                build.setAuthentication(authenticationBuilder.build());
            }
            return build.build();
        }).toList();
    }

    private RepositorySystemSession repositorySystemSession(RepositorySystem system, String localRepositoryPath) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        if (localRepositoryPath == null) {
            try {
                String tmpDir;
                localRepositoryPath = tmpDir = Files.createTempDirectory(DEFAULT_LOCAL_REPOSITORY_PREFIX, new FileAttribute[0]).toAbsolutePath().toString();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        FileUtils.deleteDirectory((File)new File(tmpDir));
                    }
                    catch (IOException e) {
                        throw new KestraRuntimeException(e);
                    }
                }));
            }
            catch (IOException e) {
                throw new KestraRuntimeException(e);
            }
        }
        LocalRepository localRepo = new LocalRepository(localRepositoryPath);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }

    private PluginArtifact resolveArtifact(List<RemoteRepository> repositories, String dependency) {
        try {
            DefaultArtifact artifact = new DefaultArtifact(dependency);
            VersionRangeResult version = this.system.resolveVersionRange(this.session, new VersionRangeRequest((Artifact)artifact, repositories, null));
            String highestVersion = version.getHighestVersion().toString();
            ArtifactRequest artifactRequest = new ArtifactRequest((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "jar", highestVersion), repositories, null);
            ArtifactResult result = this.system.resolveArtifact(this.session, artifactRequest);
            return new PluginArtifact(result.getArtifact().getGroupId(), result.getArtifact().getArtifactId(), result.getArtifact().getExtension(), result.getArtifact().getClassifier(), highestVersion.endsWith("-SNAPSHOT") ? highestVersion : result.getArtifact().getVersion(), result.getArtifact().getFile().toPath().toUri());
        }
        catch (ArtifactResolutionException | VersionRangeResolutionException e) {
            throw new KestraRuntimeException("Failed to resolve dependency: '" + dependency + "'", e);
        }
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        try {
            this.system.shutdown();
        }
        catch (MultiRuntimeException e) {
            log.warn("Error while shutting down Maven repository", (Throwable)e);
        }
    }
}

