/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.contexts.MavenPluginRepositoryConfig;
import io.kestra.core.plugins.PluginArtifact;
import io.kestra.core.plugins.PluginArtifactMetadata;
import io.kestra.core.plugins.PluginResolutionResult;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;

public interface PluginManager
extends AutoCloseable {
    public void start();

    public boolean isReady();

    public List<PluginArtifactMetadata> list();

    public PluginArtifact install(PluginArtifact var1, List<MavenPluginRepositoryConfig> var2, boolean var3, @Nullable Path var4);

    public PluginArtifact install(File var1, boolean var2, @Nullable Path var3, boolean var4);

    public List<PluginArtifact> install(List<PluginArtifact> var1, List<MavenPluginRepositoryConfig> var2, boolean var3, @Nullable Path var4);

    public List<PluginArtifact> uninstall(List<PluginArtifact> var1, boolean var2, @Nullable Path var3);

    public List<PluginResolutionResult> resolveVersions(List<PluginArtifact> var1);

    @Override
    default public void close() throws Exception {
    }

    public static Path getLocalManagedRepositoryPathOrDefault(@Nullable String path) {
        Path resolved = Optional.ofNullable(path).map(x$0 -> Path.of(x$0, new String[0])).orElseGet(() -> Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve("kestra/plugins-repository"));
        return PluginManager.createLocalRepositoryIfNotExist(resolved);
    }

    public static Path createLocalRepositoryIfNotExist(Path resolved) {
        if (!Files.exists(resolved, new LinkOption[0])) {
            try {
                Files.createDirectories(resolved, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot create local repository for plugins", e);
            }
        }
        return resolved;
    }
}

