/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter;

import io.kestra.core.reporter.Reportable;
import java.time.Duration;
import java.time.Instant;

public class Schedules {
    public static Reportable.ReportingSchedule every(final Duration period) {
        if (period.isZero() || period.isNegative()) {
            throw new IllegalArgumentException("Period must be positive");
        }
        return new Reportable.ReportingSchedule(){
            private Instant lastRun = Instant.EPOCH;

            @Override
            public boolean shouldRun(Instant now) {
                if (Duration.between(this.lastRun, now).compareTo(period) >= 0) {
                    this.lastRun = now;
                    return true;
                }
                return false;
            }
        };
    }

    public static Reportable.ReportingSchedule hourly() {
        return Schedules.every(Duration.ofHours(1L));
    }

    public static Reportable.ReportingSchedule daily() {
        return Schedules.every(Duration.ofDays(1L));
    }
}

