/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestra.core.models.HasUID;
import io.kestra.core.models.flows.State;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.time.Instant;
import lombok.Generated;

public final class ExecutionDelay
implements HasUID {
    @NotNull
    private final String taskRunId;
    @NotNull
    private final String executionId;
    @NotNull
    private final Instant date;
    @NotNull
    private final State.Type state;
    @NotNull
    private final DelayType delayType;

    @Override
    @JsonIgnore
    public String uid() {
        return String.join((CharSequence)"_", this.executionId, this.taskRunId);
    }

    public DelayType getDelayType() {
        return this.delayType == null ? DelayType.RESUME_FLOW : this.delayType;
    }

    @Generated
    public static ExecutionDelayBuilder builder() {
        return new ExecutionDelayBuilder();
    }

    @Generated
    public String getTaskRunId() {
        return this.taskRunId;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public Instant getDate() {
        return this.date;
    }

    @Generated
    public State.Type getState() {
        return this.state;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionDelay)) {
            return false;
        }
        ExecutionDelay other = (ExecutionDelay)o;
        String this$taskRunId = this.getTaskRunId();
        String other$taskRunId = other.getTaskRunId();
        if (this$taskRunId == null ? other$taskRunId != null : !this$taskRunId.equals(other$taskRunId)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        Instant this$date = this.getDate();
        Instant other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        State.Type this$state = this.getState();
        State.Type other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        DelayType this$delayType = this.getDelayType();
        DelayType other$delayType = other.getDelayType();
        return !(this$delayType == null ? other$delayType != null : !((Object)((Object)this$delayType)).equals((Object)other$delayType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $taskRunId = this.getTaskRunId();
        result = result * 59 + ($taskRunId == null ? 43 : $taskRunId.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        Instant $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        State.Type $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        DelayType $delayType = this.getDelayType();
        result = result * 59 + ($delayType == null ? 43 : ((Object)((Object)$delayType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExecutionDelay(taskRunId=" + this.getTaskRunId() + ", executionId=" + this.getExecutionId() + ", date=" + String.valueOf(this.getDate()) + ", state=" + String.valueOf((Object)this.getState()) + ", delayType=" + String.valueOf((Object)this.getDelayType()) + ")";
    }

    @ConstructorProperties(value={"taskRunId", "executionId", "date", "state", "delayType"})
    @Generated
    public ExecutionDelay(String taskRunId, String executionId, Instant date, State.Type state, DelayType delayType) {
        this.taskRunId = taskRunId;
        this.executionId = executionId;
        this.date = date;
        this.state = state;
        this.delayType = delayType;
    }

    public static enum DelayType {
        RESUME_FLOW,
        RESTART_FAILED_TASK,
        RESTART_FAILED_FLOW,
        CONTINUE_FLOWABLE;

    }

    @Generated
    public static class ExecutionDelayBuilder {
        @Generated
        private String taskRunId;
        @Generated
        private String executionId;
        @Generated
        private Instant date;
        @Generated
        private State.Type state;
        @Generated
        private DelayType delayType;

        @Generated
        ExecutionDelayBuilder() {
        }

        @Generated
        public ExecutionDelayBuilder taskRunId(String taskRunId) {
            this.taskRunId = taskRunId;
            return this;
        }

        @Generated
        public ExecutionDelayBuilder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        @Generated
        public ExecutionDelayBuilder date(Instant date) {
            this.date = date;
            return this;
        }

        @Generated
        public ExecutionDelayBuilder state(State.Type state) {
            this.state = state;
            return this;
        }

        @Generated
        public ExecutionDelayBuilder delayType(DelayType delayType) {
            this.delayType = delayType;
            return this;
        }

        @Generated
        public ExecutionDelay build() {
            return new ExecutionDelay(this.taskRunId, this.executionId, this.date, this.state, this.delayType);
        }

        @Generated
        public String toString() {
            return "ExecutionDelay.ExecutionDelayBuilder(taskRunId=" + this.taskRunId + ", executionId=" + this.executionId + ", date=" + String.valueOf(this.date) + ", state=" + String.valueOf((Object)this.state) + ", delayType=" + String.valueOf((Object)this.delayType) + ")";
        }
    }
}

